/*
 * Decompiled with CFR 0.152.
 */
package local.rip.entity;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import local.rip.engine.DamageBox;
import local.rip.engine.GameApp;
import local.rip.engine.Physical;
import local.rip.engine.Player;
import local.rip.entity.Entity;
import local.rip.entity.Entity001Rota;
import local.rip.entity.Entity002Phage;
import local.rip.entity.Entity003Adeno;
import local.rip.entity.Entity004HVbound;
import local.rip.entity.Entity005CityDoor;
import local.rip.entity.Entity006ElevatorDoor;
import local.rip.entity.Entity007PhysHVbound;
import local.rip.entity.Entity008ParkProp;
import local.rip.entity.Entity009Chloe;
import local.rip.entity.Entity010RunBarrier;
import local.rip.entity.Entity011SaveHealStation;
import local.rip.entity.Entity012HVwallBound;
import local.rip.entity.Entity013Bandage;
import local.rip.entity.Entity014EnvelopeAndOpener;
import local.rip.entity.Entity015Dandelion;
import local.rip.entity.Entity016AxeInStump;
import local.rip.entity.Entity017RisaKnife;
import local.rip.entity.Entity018NeighborhoodBox;
import local.rip.entity.Entity019Risa;
import local.rip.entity.Entity020RisaTV;
import local.rip.entity.Entity021Jay;
import local.rip.entity.Entity022WeaponBook;
import local.rip.entity.Entity023HeartFlower;
import local.rip.entity.Entity024CityKid;
import local.rip.entity.Entity025SandCastle;
import local.rip.entity.Entity026WaterFountain;
import local.rip.entity.Entity027WaterDropEnt;
import local.rip.entity.Entity028WreckerKid;
import local.rip.entity.Entity029BuilderKid;
import local.rip.entity.Entity030ParkFloatingBlock;
import local.rip.entity.Entity031SwarmBlob;
import local.rip.entity.Entity032SwarmParent;
import local.rip.entity.Entity033Luca;
import local.rip.entity.Entity034Partner;
import local.rip.entity.Entity035ElevatorDoorLab;
import local.rip.entity.Entity036SeedGeneratorEffect;
import local.rip.entity.Entity037NewTutorialProps;
import local.rip.entity.Entity038BigHospitalScreen;
import local.rip.entity.Entity039SmallHospitalScreen;
import local.rip.entity.Entity040Zip;
import local.rip.entity.Entity041RipInHospitalBed;

public class EntityManager {
    private static final int NUMBOFENTITIES = 200;
    private static final int NUMBOF_DBOXES = 10;
    private static ArrayList<Entity> entityArray = new ArrayList(200);
    private static ArrayList<Entity> entitiesToBeAdded = new ArrayList();
    private static ArrayList<DamageBox> dboxArray = new ArrayList(10);
    private static ArrayList<DamageBox> entityDboxArray = new ArrayList(200);
    private static final int CellSize = 40960;
    static int hashCols = 0;
    static int hashRows = 0;
    static int hashMaxKey = 0;
    static Hashtable<Integer, Vector<Entity>> Buckets = new Hashtable();

    public Vector<Entity> getEntity(int eventNum) {
        Vector<Entity> matchedEntities = new Vector<Entity>();
        for (Entity E : entityArray) {
            if (E.eventNumb != eventNum) continue;
            matchedEntities.add(E);
        }
        for (Entity E : entitiesToBeAdded) {
            if (E.eventNumb != eventNum) continue;
            matchedEntities.add(E);
        }
        return matchedEntities;
    }

    public void deleteEntities(int eventNum) {
        entityArray.removeAll(this.getEntity(eventNum));
    }

    public void animateEntities(int eventNum, int newState) {
        Vector<Entity> animatedEntities = this.getEntity(eventNum);
        for (Entity E : animatedEntities) {
            E.state = newState;
        }
    }

    public void changeEntitiesDirection(int eventNum, int newDirection) {
        Vector<Entity> animatedEntities = this.getEntity(eventNum);
        for (Entity E : animatedEntities) {
            E.direction = newDirection;
        }
    }

    public void changeEntitiesFlags(int eventNum, int newFlags) {
        System.out.println(Integer.toHexString(newFlags));
        Vector<Entity> animatedEntities = this.getEntity(eventNum);
        for (Entity E : animatedEntities) {
            E.entityFlags = newFlags;
            System.out.println(E.entityType);
        }
    }

    public Entity makeEntity(int eType, int x, int y, int xV, int yV, int eFlags, int event, int dir, int flagID) {
        Entity E;
        switch (eType) {
            case 1: {
                E = new Entity001Rota(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 2: {
                E = new Entity002Phage(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 3: {
                E = new Entity003Adeno(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 4: {
                E = new Entity004HVbound(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 5: {
                E = new Entity005CityDoor(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 6: {
                E = new Entity006ElevatorDoor(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 7: {
                E = new Entity007PhysHVbound(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 8: {
                E = new Entity008ParkProp(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 9: {
                E = new Entity009Chloe(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 10: {
                E = new Entity010RunBarrier(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 11: {
                E = new Entity011SaveHealStation(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 12: {
                E = new Entity012HVwallBound(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 13: {
                E = new Entity013Bandage(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 14: {
                E = new Entity014EnvelopeAndOpener(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 15: {
                E = new Entity015Dandelion(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 16: {
                E = new Entity016AxeInStump(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 17: {
                E = new Entity017RisaKnife(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 18: {
                E = new Entity018NeighborhoodBox(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 19: {
                E = new Entity019Risa(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 20: {
                E = new Entity020RisaTV(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 21: {
                E = new Entity021Jay(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 22: {
                E = new Entity022WeaponBook(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 23: {
                E = new Entity023HeartFlower(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 24: {
                E = new Entity024CityKid(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 25: {
                E = new Entity025SandCastle(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 26: {
                E = new Entity026WaterFountain(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 27: {
                E = new Entity027WaterDropEnt(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 28: {
                E = new Entity028WreckerKid(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 29: {
                E = new Entity029BuilderKid(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 30: {
                E = new Entity030ParkFloatingBlock(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 31: {
                E = new Entity031SwarmBlob(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 32: {
                E = new Entity032SwarmParent(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 33: {
                E = new Entity033Luca(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 34: {
                E = new Entity034Partner(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 35: {
                E = new Entity035ElevatorDoorLab(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 36: {
                E = new Entity036SeedGeneratorEffect(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 37: {
                E = new Entity037NewTutorialProps(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 38: {
                E = new Entity038BigHospitalScreen(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 39: {
                E = new Entity039SmallHospitalScreen(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 40: {
                E = new Entity040Zip(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            case 41: {
                E = new Entity041RipInHospitalBed(eType, x, y, xV, yV, eFlags, event, dir, flagID);
                break;
            }
            default: {
                E = new Entity(eType, x, y, xV, yV, eFlags, event, dir, flagID);
            }
        }
        return E;
    }

    public Entity addEntity(int eType, int x, int y, int xV, int yV, int eFlags, int event, int dir, int flagID) {
        Entity E = this.makeEntity(eType, x, y, xV, yV, eFlags, event, dir, flagID);
        entitiesToBeAdded.add(E);
        return E;
    }

    public void drawEntities(Graphics2D g) {
        ArrayList drawArray = (ArrayList)entityArray.clone();
        for (Entity drawE : drawArray) {
            if (drawE.getType() < 0) continue;
            drawE.draw(g);
        }
        if (GameApp.currentMap.isMirror()) {
            for (Entity drawE : drawArray) {
                if (drawE.getType() < 0) continue;
                drawE.drawReflect(g);
            }
        }
    }

    public static void setup2DHash(int scenewidth, int sceneheight) {
        hashCols = scenewidth / 40960 + 1;
        hashRows = sceneheight / 40960 + 1;
        hashMaxKey = hashCols * hashRows;
        Buckets = new Hashtable(hashMaxKey);
        int i = 0;
        while (i < hashMaxKey) {
            Buckets.put(i, new Vector());
            ++i;
        }
    }

    private static void clearBuckets() {
        int i = 0;
        while (i < hashMaxKey) {
            Buckets.get(i).clear();
            ++i;
        }
    }

    private static void addBucket(int x, int y, Vector<Integer> buckettoaddto) {
        int cellPosition = x / 40960 + y / 40960 * hashCols;
        if (!buckettoaddto.contains(cellPosition)) {
            buckettoaddto.add(cellPosition);
        }
    }

    private static Vector<Integer> getIdForObj(Physical obj) {
        Vector<Integer> bucketsObjIsIn = new Vector<Integer>();
        int minX = obj.xPos + obj.hitRect.x * 512;
        int minY = obj.yPos + obj.hitRect.y * 512;
        int maxX = minX + obj.hitRect.width * 512;
        int maxY = minY + obj.hitRect.height * 512;
        EntityManager.addBucket(minX, minY, bucketsObjIsIn);
        EntityManager.addBucket(maxX, minY, bucketsObjIsIn);
        EntityManager.addBucket(maxX, maxY, bucketsObjIsIn);
        EntityManager.addBucket(minX, maxY, bucketsObjIsIn);
        if (maxY - minY >= 81920) {
            EntityManager.addBucket(maxX, (maxY + minY) / 2, bucketsObjIsIn);
            EntityManager.addBucket(minX, (maxY + minY) / 2, bucketsObjIsIn);
        }
        return bucketsObjIsIn;
    }

    private static void registerObject(Entity e) {
        e.playerCollisionSide = 0;
        Vector<Integer> cellIds = EntityManager.getIdForObj(e);
        for (Integer i : cellIds) {
            if (i <= 0 || i >= hashMaxKey) continue;
            Buckets.get(i).add(e);
        }
    }

    public void runEntityAI() {
        ArrayList<Entity> deadNPCs = new ArrayList<Entity>();
        if (!entitiesToBeAdded.isEmpty()) {
            entityArray.addAll(entitiesToBeAdded);
            entitiesToBeAdded.clear();
        }
        for (Entity actE : entityArray) {
            actE.act();
            if ((actE.getFlags() & 4) == 0) {
                actE.tileCollision(actE.size);
            }
            if (actE.getType() >= 0) continue;
            deadNPCs.add(actE);
        }
        entityArray.removeAll(deadNPCs);
    }

    public void updateDamageBoxes() {
        for (DamageBox D : dboxArray) {
            D.update();
        }
        for (DamageBox D : entityDboxArray) {
            D.update();
        }
    }

    public void entityPCCollisions(Player pc) {
        EntityManager.clearBuckets();
        ArrayList<DamageBox> removeBoxes = new ArrayList<DamageBox>();
        for (Entity actE : entityArray) {
            EntityManager.registerObject(actE);
        }
        Vector<Integer> collIds = EntityManager.getIdForObj(pc);
        pc.interactablePresent = false;
        for (Integer i : collIds) {
            if (i >= hashMaxKey || i < 0) continue;
            for (Entity P : Buckets.get(i)) {
                if ((P.entityFlags & 0x41) != 0) {
                    P.pcCollision(pc);
                    continue;
                }
                if (!P.pcEventCollision(pc)) continue;
                if ((P.entityFlags & 0x200) != 0) {
                    pc.interactablePresent = true;
                    pc.interactableEntity = P;
                    continue;
                }
                if ((P.entityFlags & 0x400) == 0 || GameApp.isScriptRunning()) continue;
                switch (P.entityType) {
                    case 13: {
                        if (GameApp.scriptFlags.checkFlag(2001)) {
                            pc.heal(2);
                            GameApp.soundPlayer.playSound(25);
                            P.entityType = -1;
                            P.entityFlags = 0;
                            break;
                        }
                        GameApp.scriptRunner.runEvent(P.eventNumb);
                        break;
                    }
                    default: {
                        GameApp.scriptRunner.runEvent(P.eventNumb);
                    }
                }
            }
        }
        for (DamageBox D : entityDboxArray) {
            if (D.framesLife > 0) {
                pc.damageCollision(D);
                continue;
            }
            removeBoxes.add(D);
        }
        entityDboxArray.removeAll(removeBoxes);
    }

    public void damageEntityCollisions() {
        ArrayList<DamageBox> removeBoxes = new ArrayList<DamageBox>();
        ArrayList<Entity> entitiesHit = new ArrayList<Entity>();
        for (DamageBox D : dboxArray) {
            if (D.hitsLeft > 0 && D.framesLife > 0) {
                Vector<Integer> collIds = EntityManager.getIdForObj(D);
                for (Integer i : collIds) {
                    if (i >= hashMaxKey || i < 0) continue;
                    for (Entity E : Buckets.get(i)) {
                        if ((E.entityFlags & 0x10) == 0 || entitiesHit.contains(E)) continue;
                        E.damageCollision(D);
                        entitiesHit.add(E);
                    }
                }
            }
            entitiesHit.clear();
            if (D.hitsLeft > 0 && D.framesLife > 0) continue;
            removeBoxes.add(D);
        }
        dboxArray.removeAll(removeBoxes);
    }

    public void entityPCCollisionsOld(Player pc) {
        for (Entity actE : entityArray) {
            actE.pcCollision(pc);
        }
    }

    public static DamageBox addDbox(Physical own, int x, int y, int fLife, int hLeft, int dam, int width, int height, int direction, int weight, int ownOffsetX, int ownOffsetY) {
        DamageBox D = new DamageBox(own, x, y, fLife, hLeft, dam, width, height, direction, weight, ownOffsetX, ownOffsetY);
        dboxArray.add(D);
        return D;
    }

    public static DamageBox addEntityDbox(Physical own, int x, int y, int fLife, int hLeft, int dam, int width, int height, int direction, int weight, int ownOffsetX, int ownOffsetY) {
        DamageBox D = new DamageBox(own, x, y, fLife, hLeft, dam, width, height, direction, weight, ownOffsetX, ownOffsetY);
        entityDboxArray.add(D);
        return D;
    }

    public void clearEntities() {
        entityArray.clear();
        dboxArray.clear();
        entityDboxArray.clear();
    }

    public void updateAllRendCoords() {
        for (Entity E : entityArray) {
            E.updateRendCoords();
        }
    }

    public void changeEntities(Integer idNumb, Integer newType) {
        int i = 0;
        while (i < entityArray.size()) {
            Entity E = entityArray.get(i);
            if (E.eventNumb == idNumb) {
                System.out.println("Changed " + E.eventNumb);
                Entity E2 = this.makeEntity(newType, E.xPos, E.yPos, E.xVel, E.yVel, E.entityFlags, E.eventNumb, E.direction, E.flagID);
                entityArray.set(i, E2);
            }
            ++i;
        }
    }

    public void moveEntities(Integer idNumb, int x, int y) {
        int i = 0;
        while (i < entityArray.size()) {
            Entity E = entityArray.get(i);
            if (E.eventNumb == idNumb) {
                E.xPos = x;
                E.yPos = y;
            }
            ++i;
        }
    }
}

