/*
 * Decompiled with CFR 0.152.
 */
package local.rip.entity;

import local.rip.engine.GameApp;
import local.rip.entity.Entity;
import local.rip.entity.EntityManager;

public class Entity002Phage
extends Entity {
    private static final int[] idleFrameArray;
    private int hurtTimer = 0;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 1;
        nArray[7] = 2;
        idleFrameArray = nArray;
    }

    public Entity002Phage(int eType, int x, int y, int xV, int yV, int eFlags, int event, int dir, int flagID) {
        super(eType, x, y, xV, yV, eFlags, event, dir, flagID);
    }

    @Override
    public void act() {
        super.act();
        switch (this.state) {
            case 0: {
                this.bitmap = (byte)4;
                this.hurtSound = 3;
                this.displayOffsetX = 7680;
                this.displayOffsetY = 8192;
                this.frameRect.width = 30;
                this.frameRect.height = 54;
                this.maxHP = 10;
                this.frameRect.x = 60;
                this.currentHP = 10;
                this.hitRect.x = -7;
                this.hitRect.y = -8;
                this.hitRect.height = 34;
                this.hitRect.width = 14;
                this.dbox = EntityManager.addEntityDbox(this, this.xPos, this.yPos + 4608, 2, 1, 2, 16, 36, 0, 2, 0, 4608);
                this.state = 1;
                this.frameIndex = GameApp.randomInt(0, 7);
                this.entityFlags = 2288;
            }
            case 1: {
                if (this.frameIndex > 7) {
                    this.frameIndex = 0;
                }
                this.frameRect.y = idleFrameArray[this.frameIndex] * this.frameRect.height;
                this.frameRect.x = 64;
                if ((this.direction & 1) == 0) {
                    this.frameRect.x += this.frameRect.width;
                }
                ++this.frameTimer;
                if (this.frameTimer > 8) {
                    this.frameTimer = 0;
                    ++this.frameIndex;
                }
                if (GameApp.randomInt(0, 40) == 0) {
                    if (GameApp.randomInt(0, 1) == 0) {
                        this.direction |= 4;
                        this.direction &= 0xFFFFFFFE;
                    } else {
                        this.direction |= 1;
                        this.direction &= 0xFFFFFFFB;
                    }
                    this.state = 2;
                    this.scrTimer = GameApp.randomInt(0, 40);
                }
                this.friction();
                this.movement();
                this.dbox.framesLife = 2;
                break;
            }
            case 2: {
                if (this.frameIndex > 7) {
                    this.frameIndex = 0;
                }
                this.frameRect.y = idleFrameArray[this.frameIndex] * this.frameRect.height;
                this.frameRect.x = 64;
                if ((this.direction & 1) == 0) {
                    this.frameRect.x += this.frameRect.width;
                }
                ++this.frameTimer;
                if (this.frameTimer > 8) {
                    this.frameTimer = 0;
                    ++this.frameIndex;
                }
                if ((this.collision & 1) != 0) {
                    this.direction = 4;
                    this.xVel = 50;
                } else if ((this.collision & 4) != 0) {
                    this.direction = 1;
                    this.xVel = -50;
                }
                if ((this.direction & 1) == 0) {
                    this.xVel += 70;
                    if (this.xVel > 500) {
                        this.xVel = 500;
                    }
                } else {
                    this.xVel -= 70;
                    if (this.xVel < -500) {
                        this.xVel = -500;
                    }
                }
                if (GameApp.pc.xPos - 40960 < this.xPos && GameApp.pc.xPos + 40960 > this.xPos && GameApp.pc.yPos - 76800 < this.yPos && GameApp.pc.yPos - 20480 > this.yPos && ((this.direction & 1) != 0 && GameApp.pc.xPos < this.xPos || (this.direction & 4) != 0 && GameApp.pc.xPos > this.xPos)) {
                    this.state = 3;
                    this.yVel = 1000;
                    GameApp.soundPlayer.playSound(28);
                }
                this.friction();
                this.movement();
                this.dbox.framesLife = 2;
                break;
            }
            case 3: {
                this.frameRect.x = 124;
                if ((this.direction & 1) == 0) {
                    this.frameRect.x += this.frameRect.width;
                }
                this.frameRect.y = Math.abs(this.yVel) > 700 ? 0 : this.frameRect.height;
                this.yVel += 120;
                if (this.yVel > 2000) {
                    this.yVel = 2000;
                }
                if ((this.collision & 8) != 0 && this.yVel > 0) {
                    this.yVel = 0;
                }
                if ((this.direction & 1) == 0) {
                    this.xVel += 70;
                    if (this.xVel > 700) {
                        this.xVel = 700;
                    }
                } else {
                    this.xVel -= 70;
                    if (this.xVel < -700) {
                        this.xVel = -700;
                    }
                }
                if (GameApp.pc.yPos - this.yPos < 10240 || (this.collision & 8) != 0) {
                    this.state = 4;
                }
                this.friction();
                this.movement();
                this.dbox.framesLife = 2;
                break;
            }
            case 4: {
                this.frameRect.x = 124;
                if ((this.direction & 1) == 0) {
                    this.frameRect.x += this.frameRect.width;
                }
                this.frameRect.y = Math.abs(this.yVel) > 700 ? 0 : this.frameRect.height;
                this.yVel -= 120;
                if (this.yVel < -2000) {
                    this.yVel = -2000;
                }
                if ((this.collision & 8) != 0 && this.yVel > 0) {
                    this.yVel = 0;
                }
                if ((this.direction & 1) == 0) {
                    this.xVel += 70;
                    if (this.xVel > 700) {
                        this.xVel = 700;
                    }
                } else {
                    this.xVel -= 70;
                    if (this.xVel < -700) {
                        this.xVel = -700;
                    }
                }
                if (GameApp.pc.yPos - this.yPos > 30720) {
                    this.yVel /= 2;
                    this.state = 1;
                }
                this.friction();
                this.movement();
                this.dbox.framesLife = 2;
            }
        }
        if (this.hurtTimer > 0) {
            --this.hurtTimer;
            if ((this.hurtTimer & 2) == 0) {
                this.frameRect.height = 54;
                this.frameRect.width = 30;
                this.frameRect.y = 2 * this.frameRect.height;
                this.frameRect.x = 124;
            } else {
                this.frameRect.height = 0;
                this.frameRect.width = 0;
            }
        } else {
            this.frameRect.height = 54;
            this.frameRect.width = 30;
        }
    }

    @Override
    public void hurt(int damage) {
        this.hurtTimer = 30;
        this.state = 4;
    }

    @Override
    public void friction() {
        this.xVel = this.xVel > this.friction ? (this.xVel -= this.friction) : (this.xVel < -this.friction ? (this.xVel += this.friction) : 0);
        this.yVel = this.yVel > this.friction ? (this.yVel -= this.friction) : (this.yVel < -this.friction ? (this.yVel += this.friction) : 0);
    }
}

