/*
 * Decompiled with CFR 0.152.
 */
package local.rip.entity;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Vector;
import local.rip.engine.DamageBox;
import local.rip.engine.GameApp;
import local.rip.engine.Line;
import local.rip.engine.NumObj;
import local.rip.engine.Physical;
import local.rip.engine.Player;
import local.rip.engine.Stage;

public class Entity
extends Physical {
    public static final int SOLID = 1;
    public static final int RUN_EVENT_ON_DEATH = 2;
    public static final int NONSOLID = 4;
    public static final int INVINCIBLE = 8;
    public static final int KILLABLE = 16;
    public static final int PUSHABLE = 32;
    public static final int SPECIAL_SOLID = 64;
    public static final int DROP_HEALTH = 128;
    public static final int OPTION = 256;
    public static final int INTERACTABLE = 512;
    public static final int RUN_EVENT_ON_CONTACT = 1024;
    public static final int BOUND_BY_ENEMY_LINES = 2048;
    public static final int CAN_USE_ITEM_ON = 4096;
    public static final int SHOW_IF_FLAG_SET = 8192;
    public static final int DONT_SHOW_IF_FLAG_SET = 16384;
    public int playerCollisionSide = 0;
    protected DamageBox dbox;
    public int state = 0;
    public int eventNumb;
    private int frameX;
    private int frameY;
    public int frameTimer;
    public int frameIndex;
    protected int scrTimer;
    public int entityFlags = 0;
    public int flagID = 0;
    private int damage = 0;
    int entityType = -1;
    public int hitTimer = 0;
    private int deathType = 1;
    public int size = 1;
    public byte bitmap = (byte)3;
    protected Rectangle frameRect = new Rectangle(0, 0, 0, 0);

    @Override
    public void doDamage(int damage) {
        if (this.damageNumb == null || !this.damageNumb.active) {
            this.damageNumb = NumObj.addNumb(damage, this, 5120);
        } else {
            this.damageNumb.addNumber(damage);
        }
        if ((this.entityFlags & 8) == 0) {
            this.hurt(damage);
            this.currentHP -= damage;
            if (this.currentHP <= 0) {
                if ((this.entityFlags & 2) != 0) {
                    GameApp.scriptRunner.runEvent(this.eventNumb);
                } else {
                    this.entityType = -1;
                    switch (this.deathType) {
                        case 1: {
                            int yVel;
                            int xVel;
                            int i = 0;
                            while (i < 16) {
                                xVel = GameApp.randomInt(-1400, 1400);
                                yVel = GameApp.randomInt(-1400, 1400);
                                GameApp.effectMan.addEffect(6, this.xPos, this.yPos, xVel, yVel, 0);
                                ++i;
                            }
                            i = 0;
                            while (i < 9) {
                                xVel = GameApp.randomInt(-1000, 1000);
                                yVel = GameApp.randomInt(-1000, 1000);
                                GameApp.effectMan.addEffect(7, this.xPos, this.yPos, xVel, yVel, 0);
                                ++i;
                            }
                            GameApp.soundPlayer.playSound(6, 4);
                            break;
                        }
                        default: {
                            int i = 0;
                            while (i < 4) {
                                GameApp.entMan.addEntity(3, this.xPos, this.yPos, 0, 0, 0, 0, 0, 0);
                                ++i;
                            }
                            GameApp.soundPlayer.playSound(6, 4);
                        }
                    }
                    if ((this.entityFlags & 0x80) != 0) {
                        int current = GameApp.pc.getCurrentHP();
                        int max = GameApp.pc.getMaxHP();
                        int hpChanceBoost = (max - current) * 40 / max;
                        if (GameApp.randomInt(0, 100) >= 80 - hpChanceBoost) {
                            GameApp.entMan.addEntity(13, this.xPos, this.yPos, 0, 0, 0, 0, 0, 0);
                        }
                    }
                }
            } else {
                if (this.hitTimer == 0) {
                    GameApp.soundPlayer.playSound(this.hurtSound, 4);
                }
                this.hitTimer = 2;
            }
        }
    }

    public int getType() {
        return this.entityType;
    }

    public void setType(int entityType) {
        this.entityType = entityType;
    }

    public int getFlags() {
        return this.entityFlags;
    }

    public void setFlags(int entityFlags) {
        this.entityFlags = entityFlags;
    }

    public Entity(int eType, int x, int y, int xV, int yV, int eFlags, int event, int dir, int flagID) {
        this.setType(eType);
        this.xPos = x;
        this.yPos = y;
        this.xVel = xV;
        this.yVel = yV;
        this.setFlags(eFlags);
        this.eventNumb = event;
        this.hitRect = new Rectangle(0, 0, 0, 0);
        this.direction = dir;
        this.flagID = flagID;
    }

    public void draw(Graphics2D g) {
        GameApp.gMan.camBlit(this.bitmap, this.frameRect, this.rendX - this.displayOffsetX, this.rendY - this.displayOffsetY, g);
    }

    public void drawReflect(Graphics2D g) {
        int numOfMirrors = GameApp.currentMap.getNumOfMirrors();
        int i = 0;
        while (i < numOfMirrors) {
            if (GameApp.currentMap.isReflected(this.rendX - this.displayOffsetX, this.rendY - this.displayOffsetY, this.frameRect, i)) {
                int reflectY = GameApp.currentMap.getMirror((int)i).y;
                int reflectDispY = this.frameRect.height * 512 - this.displayOffsetY;
                GameApp.gMan.reflectCamBlit(this.bitmap, this.frameRect, this.rendX - this.displayOffsetX, 2 * reflectY - this.rendY - reflectDispY, g, i);
            }
            ++i;
        }
    }

    public void pcCollision(Player pc) {
        if (this.hitRect.height <= 0 || this.hitRect.width <= 0) {
            return;
        }
        if (pc.xPos + (pc.hitRect.x + pc.hitRect.width) * 512 < this.xPos + this.hitRect.x * 512) {
            return;
        }
        if (pc.xPos + pc.hitRect.x * 512 > this.xPos + (this.hitRect.x + this.hitRect.width) * 512) {
            return;
        }
        if (pc.yPos + (pc.hitRect.y + pc.hitRect.height) * 512 <= this.yPos + this.hitRect.y * 512) {
            return;
        }
        if (pc.yPos + pc.hitRect.y * 512 >= this.yPos + (this.hitRect.y + this.hitRect.height) * 512) {
            return;
        }
        int xDiff = (pc.xPos - this.xPos) / this.hitRect.width;
        int yDiff = (pc.yPos - this.yPos) / this.hitRect.height;
        int collSide = 0;
        if (Math.abs(xDiff) > Math.abs(yDiff)) {
            if (xDiff < 0) {
                this.playerCollisionSide = 1;
                collSide = 0;
            } else {
                this.playerCollisionSide = 4;
                collSide = 2;
            }
        } else if (yDiff < 0) {
            if (pc.yVel >= 0) {
                this.playerCollisionSide = 2;
                collSide = 1;
            } else if (xDiff < 0) {
                this.playerCollisionSide = 1;
                collSide = 0;
            } else {
                this.playerCollisionSide = 4;
                collSide = 2;
            }
        } else if (pc.yVel < 300) {
            this.playerCollisionSide = 8;
            collSide = 3;
        } else if (xDiff < 0) {
            this.playerCollisionSide = 1;
            collSide = 0;
        } else {
            this.playerCollisionSide = 4;
            collSide = 2;
        }
        switch (collSide) {
            case 0: {
                if (((this.entityFlags & 0x20) == 0 || (this.collision & 4) != 0 || (pc.direction & 4) == 0) && (pc.collision & 1) == 0) {
                    if ((this.entityFlags & 0x40) != 0) {
                        pc.xVel -= 200;
                        if (pc.xVel > 0) {
                            pc.xVel = 0;
                        }
                        if (pc.xVel < -900) {
                            pc.xVel = -900;
                        }
                    } else {
                        pc.xPos = this.xPos + (-(pc.hitRect.x + pc.hitRect.width) + this.hitRect.x) * 512 - 10;
                        if (pc.xVel > 100) {
                            pc.xVel = 100;
                        }
                    }
                } else {
                    if ((this.entityFlags & 0x40) != 0) break;
                    this.xPos = pc.xPos + (-this.hitRect.x + pc.hitRect.x + pc.hitRect.width) * 512 + 10;
                    if (this.xVel < -100) {
                        this.xVel = -100;
                    }
                }
                pc.collision |= 4;
                break;
            }
            case 2: {
                if ((this.entityFlags & 0x20) == 0 || (this.collision & 1) != 0 || (pc.direction & 1) == 0 && (pc.collision & 4) == 0) {
                    if ((this.entityFlags & 0x40) != 0) {
                        pc.xVel += 200;
                        if (pc.xVel < 0) {
                            pc.xVel = 0;
                        }
                        if (pc.xVel > 900) {
                            pc.xVel = 900;
                        }
                    } else {
                        pc.xPos = this.xPos + (-pc.hitRect.x + this.hitRect.x + this.hitRect.width) * 512 + 10;
                        if (pc.xVel < -100) {
                            pc.xVel = -100;
                        }
                    }
                } else {
                    if ((this.entityFlags & 0x40) != 0) break;
                    this.xPos = pc.xPos + (-(this.hitRect.x + this.hitRect.width) + pc.hitRect.x) * 512 - 10;
                    if (this.xVel > 100) {
                        this.xVel = 100;
                    }
                }
                pc.collision |= 1;
                break;
            }
            case 1: {
                if ((pc.collision & 2) == 0 || (this.collision & 8) != 0) {
                    if ((this.entityFlags & 0x40) != 0) {
                        pc.yVel -= 200;
                        if (pc.yVel > 0) {
                            pc.yVel = 0;
                        }
                        if (pc.yVel < -900) {
                            pc.yVel = -900;
                        }
                    } else {
                        pc.yPos = this.yPos + (-(pc.hitRect.y + pc.hitRect.height) + this.hitRect.y) * 512;
                    }
                } else {
                    if ((this.entityFlags & 0x40) != 0) break;
                    this.yPos = pc.yPos + (-this.hitRect.y + pc.hitRect.y + pc.hitRect.height) * 512;
                    if (this.yVel < -100) {
                        this.yVel = -100;
                    }
                }
                if (pc.yVel > 100) {
                    pc.yVel = 100;
                }
                pc.collision |= 8;
                pc.xPos += this.xVel;
                pc.yPos += this.yVel;
                pc.lineType = 1;
                break;
            }
            case 3: {
                if ((pc.collision & 8) == 0 || (this.collision & 2) != 0) {
                    if ((this.entityFlags & 0x40) != 0) {
                        pc.yVel += 200;
                        if (pc.yVel < 0) {
                            pc.yVel = 0;
                        }
                        if (pc.yVel > 900) {
                            pc.yVel = 900;
                        }
                    } else {
                        pc.yPos = this.yPos + (-pc.hitRect.y + this.hitRect.y + this.hitRect.height) * 512;
                    }
                } else {
                    if ((this.entityFlags & 0x40) != 0) break;
                    this.yPos = pc.yPos + (-(this.hitRect.y + this.hitRect.height) + pc.hitRect.y) * 512;
                    if (this.yVel > 100) {
                        this.yVel = 100;
                    }
                }
                if (pc.yVel < -100) {
                    pc.yVel = -100;
                }
                pc.collision |= 2;
            }
        }
    }

    public boolean pcEventCollision(Player pc) {
        if (this.hitRect.height <= 0 || this.hitRect.width <= 0) {
            return false;
        }
        if (pc.xPos + (pc.hitRect.x + pc.hitRect.width) * 512 < this.xPos + this.hitRect.x * 512) {
            return false;
        }
        if (pc.xPos + pc.hitRect.x * 512 > this.xPos + (this.hitRect.x + this.hitRect.width) * 512) {
            return false;
        }
        if (pc.yPos + (pc.hitRect.y + pc.hitRect.height) * 512 <= this.yPos + this.hitRect.y * 512) {
            return false;
        }
        return pc.yPos + pc.hitRect.y * 512 < this.yPos + (this.hitRect.y + this.hitRect.height) * 512;
    }

    public void act() {
        if (this.hitTimer > 0) {
            --this.hitTimer;
        }
        switch (this.entityType) {
            case 0: {
                this.emptyEntityAct();
                break;
            }
        }
    }

    public void hurt(int damage) {
    }

    private void emptyEntityAct() {
        switch (this.state) {
            case 0: {
                this.hitRect.x = -8;
                this.hitRect.y = -8;
                this.hitRect.height = 16;
                this.hitRect.width = 16;
                this.state = 1;
                break;
            }
        }
    }

    private void daggerAct() {
    }

    private void smokeCloudAct() {
        switch (this.state) {
            case 0: {
                this.displayOffsetX = 6144;
                this.displayOffsetY = 6144;
                this.frameRect.width = 24;
                this.frameRect.height = 24;
                this.frameRect.x = 8;
                this.frameRect.y = 0;
                this.maxHP = 0;
                this.currentHP = 0;
                this.hitRect.x = -10;
                this.hitRect.y = -10;
                this.hitRect.height = 20;
                this.hitRect.width = 20;
                this.state = 1;
                this.entityFlags = 0;
                this.bitmap = (byte)2;
                if (this.xVel == 0 && this.yVel == 0) {
                    this.yVel = GameApp.randomInt(0, 1) == 1 ? (this.yVel += GameApp.randomInt(400, 800)) : (this.yVel += GameApp.randomInt(-800, -400));
                    this.xVel = GameApp.randomInt(0, 1) == 1 ? (this.xVel += GameApp.randomInt(400, 800)) : (this.xVel += GameApp.randomInt(-800, -400));
                }
            }
            case 1: {
                ++this.frameTimer;
                this.frameRect.x = this.frameTimer / 5 * 24 + 8;
                if (this.frameTimer >= 40) {
                    this.entityType = -1;
                }
                this.movement();
            }
        }
    }

    @Override
    public void damageCollision(DamageBox d) {
        if (this.hitRect.height <= 0 || this.hitRect.width <= 0) {
            return;
        }
        if (d.xPos + (d.hitRect.x + d.hitRect.width) * 512 < this.xPos + this.hitRect.x * 512) {
            return;
        }
        if (d.xPos + d.hitRect.x * 512 > this.xPos + (this.hitRect.x + this.hitRect.width) * 512) {
            return;
        }
        if (d.yPos + (d.hitRect.y + d.hitRect.height) * 512 < this.yPos + this.hitRect.y * 512) {
            return;
        }
        if (d.yPos + d.hitRect.y * 512 > this.yPos + (this.hitRect.y + this.hitRect.height) * 512) {
            return;
        }
        if (!d.isHitThisFrame()) {
            --d.hitsLeft;
            d.setHitThisFrame(true);
        }
        this.doDamage(d.damage);
        int testDirection = d.direction;
        if ((testDirection & 4) != 0) {
            if (this.xVel < 0) {
                this.xVel = 0;
            }
            if (this.yVel > 0) {
                this.yVel = 0;
            }
            this.xVel += (10 - this.weight) * 25 * d.weight;
            this.yVel -= (10 - this.weight) * 50 * d.weight;
        } else if ((testDirection & 1) != 0) {
            if (this.xVel > 0) {
                this.xVel = 0;
            }
            if (this.yVel > 0) {
                this.yVel = 0;
            }
            this.xVel -= (10 - this.weight) * 25 * d.weight;
            this.yVel -= (10 - this.weight) * 50 * d.weight;
        } else {
            if (this.yVel > 0) {
                this.yVel = 0;
            }
            this.yVel -= (10 - this.weight) * 50 * d.weight;
        }
    }

    @Override
    public void tileCollision(int size) {
        this.collision = 0;
        Stage map = GameApp.currentMap;
        int testX = this.xPos / 10240;
        int testY = this.yPos / 10240;
        Vector<Line> collLines = new Vector<Line>(0);
        int maxTestRange = size + 1;
        int i = 1 - size;
        while (i < maxTestRange) {
            int j = 1 - size;
            while (j < maxTestRange) {
                Vector<Line> testLines = map.lines.get((testY + i) * map.getMapX() + testX + j);
                if (testLines != null) {
                    int k = 0;
                    while (k < testLines.size()) {
                        Line line = testLines.get(k);
                        if (!collLines.contains(line)) {
                            if (line.getSlope() == 0) {
                                collLines.add(0, line);
                            } else {
                                collLines.add(line);
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < collLines.size()) {
            switch (((Line)collLines.get(i)).getType()) {
                case 6: {
                    if ((this.entityFlags & 0x800) == 0) break;
                    ((Line)collLines.get(i)).collision(this);
                    break;
                }
                default: {
                    if (this.entityType == 30) {
                        int x = 9;
                        ++x;
                        x = 3;
                    }
                    ((Line)collLines.get(i)).collision(this);
                }
            }
            ++i;
        }
    }
}

