/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.Serializable;
import local.rip.engine.GameApp;
import local.rip.engine.Player;

public class Weapon
implements Serializable {
    private static final long serialVersionUID = 3861809629392881564L;
    static final int[] axeFrameWaitArray;
    static final int[] axeChargeFrameWaitArray;
    static final int[] axeAttackArray;
    static final int[] axeChargedHitsArray;
    Rectangle frameRect;
    int displayOffsetX;
    int displayOffsetY;
    int frameY;
    int frameX;
    int attackLevel = 0;
    int chargeLevel = 0;
    static final int SWORD_FRAME_COLS = 5;
    static final int BROADSWORD_FRAME_COLS = 3;
    byte type;
    byte bitmap;
    static final byte NO_WEAP = 0;
    static final byte AXE = 1;
    static final byte KNIFE = 2;
    boolean renderOff = false;
    Player owner;

    static {
        int[] nArray = new int[6];
        nArray[0] = 3;
        nArray[1] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 4;
        axeFrameWaitArray = nArray;
        axeChargeFrameWaitArray = new int[]{2, 2, 2, 2, 11, 8};
        axeAttackArray = new int[]{3, 4, 5, 7};
        axeChargedHitsArray = new int[]{4, 6, 8, 10};
    }

    Weapon(byte type, Player p) {
        this.type = type;
        this.owner = p;
        switch (type) {
            case 1: {
                this.frameRect = new Rectangle(0, 0, 90, 90);
                this.bitmap = (byte)6;
                break;
            }
            case 2: {
                this.displayOffsetX = this.owner.displayOffsetX;
                this.displayOffsetY = this.owner.displayOffsetY;
                this.frameRect = new Rectangle(0, 0, 54, 60);
                this.bitmap = (byte)20;
            }
        }
    }

    private void updateFrame() {
        switch (this.type) {
            case 1: {
                this.frameRect.x = this.frameX * this.frameRect.width;
                this.frameRect.y = this.frameY * this.frameRect.height;
                break;
            }
            case 2: {
                this.frameRect.x = 96 + this.frameX * this.frameRect.width;
                this.frameRect.y = this.frameY * this.frameRect.height;
            }
        }
    }

    public void use(int cycle) {
        this.renderOff = false;
        switch (this.type) {
            case 1: {
                int[] nArray = new int[6];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 4;
                int[] frameArray = nArray;
                this.frameY = frameArray[this.owner.frameIndex];
                this.frameX = 0;
                if ((this.owner.direction & 1) == 0) {
                    ++this.frameX;
                    this.displayOffsetX = 4608 + this.owner.displayOffsetX;
                    this.displayOffsetY = 2560 + this.owner.displayOffsetY;
                } else {
                    this.displayOffsetX = 12800 + this.owner.displayOffsetX;
                    this.displayOffsetY = 2560 + this.owner.displayOffsetY;
                }
                if (cycle == 1) {
                    this.frameX += 2;
                }
                this.updateFrame();
                break;
            }
            case 2: {
                this.frameX = 0;
                switch (cycle) {
                    case 0: {
                        if (this.owner.frameIndex == 0) {
                            this.frameY = 0;
                            break;
                        }
                        this.renderOff = true;
                        break;
                    }
                    case 8: {
                        if (this.owner.frameIndex == 0) {
                            this.frameY = 1;
                            break;
                        }
                        this.renderOff = true;
                        break;
                    }
                    case 2: {
                        if (this.owner.frameIndex == 0) {
                            this.frameY = 2;
                            break;
                        }
                        if (this.owner.frameIndex == 1) {
                            this.frameY = 3;
                            break;
                        }
                        this.renderOff = true;
                    }
                }
                if ((this.owner.direction & 1) == 0) {
                    ++this.frameX;
                }
                this.updateFrame();
            }
        }
    }

    public void guard() {
        this.renderOff = false;
        switch (this.type) {
            case 1: {
                this.frameY = 5;
                this.frameX = 0;
                if ((this.owner.direction & 1) == 0) {
                    ++this.frameX;
                    this.displayOffsetX = 4608 + this.owner.displayOffsetX;
                    this.displayOffsetY = 2560 + this.owner.displayOffsetY;
                } else {
                    this.displayOffsetX = 12800 + this.owner.displayOffsetX;
                    this.displayOffsetY = 2560 + this.owner.displayOffsetY;
                }
                this.updateFrame();
                break;
            }
            case 2: {
                this.frameY = 4;
                this.frameX = 0;
                if ((this.owner.direction & 1) == 0) {
                    ++this.frameX;
                }
                this.updateFrame();
            }
        }
    }

    public void idle() {
        this.renderOff = true;
    }

    public void draw(Graphics2D g) {
        if (!this.renderOff) {
            switch (this.type) {
                case 1: 
                case 2: {
                    int rendX = this.owner.xPos;
                    int rendY = this.owner.yPos;
                    GameApp.gMan.camBlit(this.bitmap, this.frameRect, this.owner.xPos - this.displayOffsetX, this.owner.yPos - this.displayOffsetY, g);
                    if (!GameApp.currentMap.isMirror()) break;
                    int numOfMirrors = GameApp.currentMap.getNumOfMirrors();
                    int i = 0;
                    while (i < numOfMirrors) {
                        if (GameApp.currentMap.isReflected(rendX - this.displayOffsetX, rendY - this.displayOffsetY, this.frameRect, i)) {
                            int reflectY = GameApp.currentMap.getMirror((int)i).y;
                            int reflectDispY = this.frameRect.height * 512 - this.displayOffsetY;
                            GameApp.gMan.reflectCamBlit(this.bitmap, this.frameRect, rendX - this.displayOffsetX, 2 * reflectY - rendY - reflectDispY, g, i);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
    }
}

