/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Vector;
import local.rip.engine.GameApp;
import local.rip.engine.Line;
import local.rip.engine.StrTools;
import local.rip.entity.Entity;
import local.rip.entity.Entity034Partner;
import local.rip.entity.EntityManager;

public class Stage {
    public static final int TILE_SIZE = 20;
    private static final Mapdata[] mapdat = Stage.initMapdata();
    private short[][][] tileArray;
    public HashMap<Integer, Vector<Line>> lines;
    public Background background;
    public Background background2 = null;
    private int mapX;
    private int mapY;
    private int currentMapNum;
    private int tilesetWidth;
    private Vector<Rectangle> mirrors = null;
    private Vector<Integer> mirrorReflectDirections = null;
    static final int REFLECT_LEFT = 1;
    static final int REFLECT_UP = 2;
    static final int REFLECT_RIGHT = 4;
    static final int REFLECT_DOWN = 8;

    public String getMapName() {
        return mapdat[this.currentMapNum].mapName;
    }

    public static String getMapName(int mapNum) {
        return mapdat[mapNum].mapName;
    }

    public int getMapNum() {
        return this.currentMapNum;
    }

    Stage(int mapNum) throws IOException {
        GameApp.ripPc.exclamationMark = null;
        GameApp.risaPc.exclamationMark = null;
        this.mirrors = new Vector();
        this.mirrorReflectDirections = new Vector();
        this.currentMapNum = mapNum;
        Mapdata currentMap = mapdat[mapNum];
        String fileName = currentMap.getFilename();
        GameApp.scriptRunner.loadMapScript(fileName);
        File mapFile = new File("data/stage/" + fileName.toLowerCase() + ".nxm");
        FileChannel inChan = null;
        FileInputStream inFile = new FileInputStream(mapFile);
        inChan = inFile.getChannel();
        ByteBuffer mapHeadBuf = ByteBuffer.allocate(8);
        mapHeadBuf.order(ByteOrder.LITTLE_ENDIAN);
        inChan.read(mapHeadBuf);
        mapHeadBuf.flip();
        int tag = mapHeadBuf.asIntBuffer().get(0);
        if (tag != 827152464) {
            this.generateDummyMap();
            StrTools.msgBox("Bad stage file header");
            inChan.close();
            inFile.close();
            return;
        }
        this.mapX = mapHeadBuf.asShortBuffer().get(2);
        this.mapY = mapHeadBuf.asShortBuffer().get(3);
        EntityManager.setup2DHash(this.mapX * 20 * 512, this.mapY * 20 * 512);
        this.tileArray = new short[4][this.mapX][this.mapY];
        int i = 0;
        while (i < 4) {
            ByteBuffer tileBuf = ByteBuffer.allocate(this.mapX * this.mapY * 2);
            inChan.read(tileBuf);
            tileBuf.flip();
            tileBuf.order(ByteOrder.LITTLE_ENDIAN);
            int y = 0;
            while (y < this.mapY) {
                int x = 0;
                while (x < this.mapX) {
                    this.tileArray[i][x][y] = (short)(0xFFFF & tileBuf.getShort(y * this.mapX * 2 + x * 2));
                    ++x;
                }
                ++y;
            }
            ++i;
        }
        ByteBuffer lineBuf = ByteBuffer.allocate(4);
        lineBuf.order(ByteOrder.LITTLE_ENDIAN);
        inChan.read(lineBuf);
        int lCount = lineBuf.getInt(0);
        lineBuf = ByteBuffer.allocate(20 * lCount);
        lineBuf.order(ByteOrder.LITTLE_ENDIAN);
        inChan.read(lineBuf);
        lineBuf.flip();
        if (this.lines != null) {
            this.lines.clear();
        }
        this.lines = new HashMap();
        int i2 = 0;
        while (i2 < lCount) {
            Line l = new Line(lineBuf.getInt(), lineBuf.getInt(), lineBuf.getInt(), lineBuf.getInt());
            l.setType(lineBuf.getInt());
            l.setTiles(this.lines, this.mapX, this.mapY);
            ++i2;
        }
        GameApp.gMan.setSheet("data/Stage/prt" + currentMap.getTileset(), (byte)1);
        this.tilesetWidth = GameApp.gMan.getWidth((byte)1) / 20;
        GameApp.gMan.setSheet("data/npc/npc" + currentMap.getNpc1(), (byte)3);
        GameApp.gMan.setSheet("data/npc/npc" + currentMap.getNpc2(), (byte)4);
        this.background = new Background(currentMap.getBG(), currentMap.getScroll(), 0);
        if (this.background2 != null) {
            this.background2.flush();
            this.background2 = null;
        }
        inChan.close();
        inFile.close();
        fileName = currentMap.getFilename();
        File entityFile = new File("data/stage/" + fileName.toLowerCase() + ".pxe");
        inChan = null;
        try {
            inFile = new FileInputStream(entityFile);
        }
        catch (FileNotFoundException e) {
            StrTools.msgBox(String.valueOf(fileName) + ".pxe not found!!");
            return;
        }
        inChan = inFile.getChannel();
        ByteBuffer nxeHeader = ByteBuffer.allocate(4);
        inChan.read(nxeHeader);
        if (!new String(nxeHeader.array()).equals("PXE\u0000")) {
            this.generateDummyMap();
            StrTools.msgBox("Bad stage file header - " + new String(nxeHeader.array()) + " .");
            inChan.close();
            inFile.close();
            return;
        }
        GameApp.entMan.clearEntities();
        GameApp.effectMan.clearEffects();
        ByteBuffer numOfEntBuff = ByteBuffer.allocate(4);
        numOfEntBuff.order(ByteOrder.LITTLE_ENDIAN);
        inChan.read(numOfEntBuff);
        int numOfEntities = numOfEntBuff.getShort(0);
        ByteBuffer entity = ByteBuffer.allocate(12);
        entity.order(ByteOrder.LITTLE_ENDIAN);
        int i3 = 0;
        while (i3 < numOfEntities) {
            inChan.read(entity);
            int xPos = (entity.getShort(0) + 10) * 512;
            int yPos = (entity.getShort(2) + 10) * 512;
            short flagID = entity.getShort(4);
            short eventNum = entity.getShort(6);
            short entType = entity.getShort(8);
            short flags = entity.getShort(10);
            if ((flags & 0x2000) != 0 && !GameApp.scriptFlags.checkFlag(flagID)) {
                System.out.println("entity not shown (show) " + eventNum);
                entity.clear();
            } else if ((flags & 0x4000) != 0 && GameApp.scriptFlags.checkFlag(flagID)) {
                System.out.println("entity not shown (don't show) " + eventNum);
                entity.clear();
            } else {
                GameApp.entMan.addEntity(entType, xPos, yPos, 0, 0, flags, eventNum, 0, flagID);
                entity.clear();
            }
            ++i3;
        }
        inChan.close();
        inFile.close();
        if (GameApp.scriptFlags.checkFlag(2010)) {
            Entity partner = GameApp.entMan.addEntity(34, 0, 0, 0, 0, 0, 0, 0, 0);
            GameApp.partnerPc = (Entity034Partner)partner;
        }
    }

    private void generateDummyMap() {
        int xSize = 32;
        int ySize = 24;
        EntityManager.setup2DHash(xSize * 20 * 512, ySize * 20 * 512);
        this.mapX = xSize;
        this.mapY = ySize;
        this.tileArray = new short[4][this.mapX][this.mapY];
        int i = 0;
        while (i < 4) {
            int x = 0;
            while (x < this.mapX) {
                int y = 0;
                while (y < this.mapY) {
                    this.tileArray[i][x][y] = 0;
                    ++y;
                }
                ++x;
            }
            ++i;
        }
        GameApp.gMan.setSheet("data/stage/prtdefault.png", (byte)1);
        this.lines = new HashMap();
        Line line1 = new Line(0, 88, 64, 88);
        Line line2 = new Line(64, 88, 64, 68);
        Line line3 = new Line(64, 68, 128, 68);
        Line line4 = new Line(64, 60, 128, 60);
        Line line5 = new Line(64, 44, 128, 44);
        Line line6 = new Line(128, 30, 0, 30);
        Line line7 = new Line(0, 0, 0, 96);
        Line line8 = new Line(64, 56, 64, 52);
        Line line9 = new Line(64, 48, 64, 44);
        this.fill(0, 22, 16, 1, 3, (byte)1);
        this.fill(16, 17, 15, 6, 3, (byte)1);
        this.fill(16, 15, 15, 1, 3, (byte)1);
        this.fill(16, 13, 15, 1, 3, (byte)1);
        this.fill(16, 11, 15, 1, 3, (byte)1);
        this.fill(17, 11, 14, 6, 3, (byte)1);
        line1.setTiles(this.lines, this.mapX, this.mapY);
        line2.setTiles(this.lines, this.mapX, this.mapY);
        line3.setTiles(this.lines, this.mapX, this.mapY);
        line4.setTiles(this.lines, this.mapX, this.mapY);
        line5.setTiles(this.lines, this.mapX, this.mapY);
        line6.setTiles(this.lines, this.mapX, this.mapY);
        line7.setTiles(this.lines, this.mapX, this.mapY);
        line8.setTiles(this.lines, this.mapX, this.mapY);
        line9.setTiles(this.lines, this.mapX, this.mapY);
    }

    public void fill(int xStart, int yStart, int xSize, int ySize, int layer, byte type) {
        int x = xStart;
        while (x < xSize + xStart) {
            int y = yStart;
            while (y < ySize + yStart) {
                this.tileArray[layer][x][y] = type;
                ++y;
            }
            ++x;
        }
    }

    public void draw(int layer, Graphics2D g) {
        Point rendCam = GameApp.gMan.getRendCamera();
        int startX = rendCam.x / 20;
        int startY = rendCam.y / 20;
        int endX = startX + 21;
        int endY = startY + 16;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                try {
                    short tileNum = this.tileArray[layer][x][y];
                    if (tileNum != 0) {
                        Rectangle frameRect = new Rectangle();
                        frameRect.x = tileNum % this.tilesetWidth * 20;
                        frameRect.y = tileNum / this.tilesetWidth * 20;
                        frameRect.width = 20;
                        frameRect.height = 20;
                        int xCoord = x * 20 * 512;
                        int yCoord = y * 20 * 512;
                        GameApp.gMan.camBlit(1, frameRect, xCoord, yCoord, g);
                    }
                }
                catch (Exception e) {
                    System.out.println("Tileset drawing error" + x + "," + y + "," + layer);
                }
                ++y;
            }
            ++x;
        }
    }

    public int getTile(int x, int y) {
        return this.tileArray[0][x][y];
    }

    public int getMapX() {
        return this.mapX;
    }

    public int getMapY() {
        return this.mapY;
    }

    public boolean isMirror() {
        return this.mirrors.size() > 0;
    }

    public void setMirror(Rectangle newMirror, int mirrorDir, int mirrorIndex) {
        if (this.mirrors.size() <= mirrorIndex) {
            this.mirrors.add(newMirror);
            this.mirrorReflectDirections.add(mirrorDir);
        } else {
            this.mirrors.set(mirrorIndex, newMirror);
            this.mirrorReflectDirections.set(mirrorIndex, mirrorDir);
        }
    }

    public void setMirrors(Vector<Rectangle> newMirrors, Vector<Integer> newMirrorDirs) {
        this.mirrors = (Vector)newMirrors.clone();
        this.mirrorReflectDirections = (Vector)newMirrorDirs.clone();
    }

    public Vector<Rectangle> getMirrors() {
        return this.mirrors;
    }

    public Vector<Integer> getMirrorDirs() {
        return this.mirrorReflectDirections;
    }

    public boolean isReflected(int x, int y, Rectangle frameRect, int mirrorIndex) {
        int ymin = y;
        int ymax = y;
        Rectangle mirror = this.mirrors.get(mirrorIndex);
        switch (this.mirrorReflectDirections.get(mirrorIndex)) {
            case 2: {
                ymax = 2 * mirror.y - y;
                ymin = ymax - frameRect.height * 512;
            }
        }
        return x + frameRect.width * 512 >= mirror.x && x <= mirror.x + mirror.width && ymax >= mirror.y && ymin <= mirror.y + mirror.height;
    }

    public boolean mirrorLeftClip(int x, int y, int mirrorIndex) {
        Rectangle mirror = this.mirrors.get(mirrorIndex);
        switch (this.mirrorReflectDirections.get(mirrorIndex)) {
            case 2: {
                y = 2 * mirror.y - y;
            }
        }
        return x >= mirror.x && x <= mirror.x + mirror.width && y >= mirror.y && y <= mirror.y + mirror.height;
    }

    private static Mapdata[] initMapdata() {
        FileChannel inChan = null;
        Mapdata[] maps = new Mapdata[]{};
        try {
            FileInputStream inStream = new FileInputStream(new File("data/mrmap.bin"));
            inChan = inStream.getChannel();
            ByteBuffer uBuf = ByteBuffer.allocate(4);
            uBuf.order(ByteOrder.LITTLE_ENDIAN);
            inChan.read(uBuf);
            uBuf.flip();
            int nMap = uBuf.getInt();
            maps = new Mapdata[nMap];
            ByteBuffer dBuf = ByteBuffer.allocate(nMap * 116);
            dBuf.order(ByteOrder.LITTLE_ENDIAN);
            inChan.read(dBuf);
            inChan.close();
            inStream.close();
            dBuf.flip();
            byte[] buf16 = new byte[16];
            byte[] nameBuf = new byte[34];
            int i = 0;
            while (i < nMap) {
                Mapdata m;
                dBuf.get(buf16);
                String tiles = StrTools.CString(buf16);
                dBuf.get(buf16);
                String filen = StrTools.CString(buf16);
                byte scroll = dBuf.get();
                dBuf.get(buf16);
                String bg = StrTools.CString(buf16);
                dBuf.get(buf16);
                String npc1 = StrTools.CString(buf16);
                dBuf.get(buf16);
                String npc2 = StrTools.CString(buf16);
                byte boss = dBuf.get();
                dBuf.get(nameBuf);
                String name = StrTools.CString(nameBuf);
                maps[i] = m = new Mapdata(tiles, filen, scroll, bg, npc1, npc2, boss, name);
                ++i;
            }
        }
        catch (FileNotFoundException err) {
            StrTools.msgBox("mrmap.bin not found!");
        }
        catch (IOException err) {
            StrTools.msgBox("Error reading mapdata!");
        }
        return maps;
    }

    public void setBackground(String name) {
        this.background2 = new Background(name, this.background.bgType, 1);
    }

    public void bgSwap() {
        Background oldBg = this.background;
        this.background = this.background2;
        this.background2 = null;
        this.background.sheet = (byte)21;
        GameApp.gMan.bgSwap();
        oldBg.flush();
    }

    public Rectangle getMirror(int mirrorIndex) {
        return this.mirrors.get(mirrorIndex);
    }

    public int getNumOfMirrors() {
        return this.mirrors.size();
    }

    class Background {
        private String bgName;
        private byte sheet;
        public static final int FIXED = 0;
        public static final int FOLLOW_SLOW = 1;
        public static final int FOLLOW_FOREGROUND = 2;
        public int bgType;
        private Point size;
        private Rectangle frameRect;
        public int alpha = 255;

        Background(String name, int type, int layer) {
            this.bgType = type;
            this.bgName = name;
            this.bgName = this.bgName.replaceAll("[\n\r]", "");
            if (layer != 0) {
                this.sheet = (byte)22;
                GameApp.gMan.setSheet("data/" + this.bgName, this.sheet);
                this.alpha = 1;
                GameApp.gMan.setAlpha(GameApp.gMan.getSheet(this.sheet), 255);
            } else {
                this.sheet = (byte)21;
                GameApp.gMan.setSheet("data/" + this.bgName, this.sheet);
                this.alpha = 255;
                GameApp.gMan.setAlpha(GameApp.gMan.getSheet(this.sheet), 255);
            }
            this.size = GameApp.gMan.getSizeOfImage(this.sheet);
            this.frameRect = new Rectangle(0, 0, this.size.x, this.size.y);
        }

        public void draw(Graphics2D g) {
            Point camera = GameApp.gMan.getRendCamera();
            switch (this.bgType) {
                case 0: {
                    if (this.frameRect.width <= 400) {
                        this.fillScreenDraw(0, 0, g);
                        break;
                    }
                    int xMax = Stage.this.getMapX() * 20 - 400;
                    float xPercent = (float)camera.x / (float)xMax;
                    int yMax = Stage.this.getMapY() * 20 - 300;
                    float yPercent = (float)camera.y / (float)yMax;
                    int xOff = (int)((float)(this.size.x - 400) * xPercent * -1.0f);
                    int yOff = (int)((float)(this.size.y - 300) * yPercent * -1.0f);
                    this.fillScreenDraw(xOff, yOff, g);
                    break;
                }
                case 1: {
                    int xStart = -1 * (camera.x % (2 * this.size.x)) / 2;
                    int yStart = -1 * (camera.y % (2 * this.size.y)) / 2;
                    this.fillScreenDraw(xStart, yStart, g);
                    break;
                }
                case 2: {
                    int xStart = -1 * (camera.x % this.size.x);
                    int yStart = -1 * (camera.y % this.size.y);
                    this.fillScreenDraw(xStart, yStart, g);
                }
            }
        }

        private void fillScreenDraw(int xStart, int yStart, Graphics2D g) {
            int xDraw = xStart;
            while (xDraw < 400) {
                int yDraw = yStart;
                while (yDraw < 300) {
                    if (this.alpha != 255) {
                        GameApp.gMan.alphaBlit(this.sheet, this.frameRect, xDraw, yDraw, g, this.alpha);
                    } else {
                        GameApp.gMan.mainBlit(this.sheet, this.frameRect, xDraw, yDraw, g);
                    }
                    yDraw += this.size.y;
                }
                xDraw += this.size.x;
            }
        }

        public void update() {
        }

        public void flush() {
        }
    }

    static class Mapdata {
        private String tileset;
        private String filename;
        private byte scrollType;
        private String bgName;
        private String npc1;
        private String npc2;
        private byte bossNum;
        private String mapName;

        public byte getScroll() {
            return this.scrollType;
        }

        public String getBG() {
            return this.bgName;
        }

        public String getNpc1() {
            return this.npc1;
        }

        public String getNpc2() {
            return this.npc2;
        }

        public byte getBoss() {
            return this.bossNum;
        }

        public String getName() {
            return this.mapName;
        }

        Mapdata(String ts, String fn, byte scroll, String bg, String n1, String n2, byte boss, String name) {
            this.tileset = ts;
            this.filename = fn;
            this.scrollType = scroll;
            this.bgName = bg;
            this.npc1 = n1;
            this.npc2 = n2;
            this.bossNum = boss;
            this.mapName = name;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getTileset() {
            return this.tileset;
        }
    }
}

