/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import local.rip.engine.GameApp;
import local.rip.engine.GameConfig;
import local.rip.engine.MST_Compiler;
import local.rip.engine.ScriptCommand;
import local.rip.engine.ScriptEvent;
import local.rip.engine.Stage;
import local.rip.engine.StrTools;
import local.rip.entity.Entity;

public class ScriptRunner {
    public Hashtable<Integer, ScriptEvent> globalEvents;
    public Hashtable<Integer, ScriptEvent> mapEvents;
    public MST_Compiler mstCompiler = new MST_Compiler();
    private ScriptEvent currentEvent;
    private int currentEventNumb;
    private ScriptCommand currentCommand;
    private int currentCommandNumb;
    private byte currentCommandID;
    private boolean running = true;
    private String currentText;
    private int textTimer = 0;
    private int waitTimer = 0;
    public int titleTimer = 0;
    int saveScreenTimer = 0;
    int inventoryTimer = 0;
    private static final int textDelay = 4;

    ScriptRunner() {
        this.globalEvents = this.mstCompiler.readScript("data/stage/scripts/global");
        this.mstCompiler.readScript("data/stage/scripts/inventory", this.globalEvents);
    }

    public void loadMapScript(String mapName) {
        if (this.mapEvents != null) {
            this.mapEvents.clear();
        }
        this.mapEvents = this.mstCompiler.readScript("data/stage/scripts/" + mapName.toLowerCase());
    }

    public void update() {
        GameApp.pc.hideExclamationMark();
        int kh = GameApp.key_held;
        int kp = GameApp.key_pressed;
        if ((kh & 0x100) != 0 && (kp & 0x800) != 0 || (kp & 0x100) != 0) {
            // empty if block
        }
        if (this.currentCommandID == 0) {
            this.textTimer = (GameApp.key_held & 0x50) != 0 ? (this.textTimer += 4) : ++this.textTimer;
            if ((GameApp.key_pressed & 0x50) != 0) {
                this.currentCommandID = (byte)45;
            }
            if (this.textTimer >= 4) {
                this.textTimer = 0;
                GameApp.guiMan.addText(this.currentText.substring(0, 1));
                this.currentText = this.currentText.substring(1, this.currentText.length());
                if (this.currentText.length() <= 0) {
                    this.running = true;
                }
            }
        } else if (this.currentCommandID == 45) {
            String[] lines = this.currentText.split("\n");
            int i = 0;
            while (i < lines.length) {
                GameApp.guiMan.addText(lines[i]);
                if (i != lines.length - 1) {
                    GameApp.guiMan.addText("\n");
                }
                ++i;
            }
            this.running = true;
        } else if (this.currentCommandID == 19 || this.currentCommandID == 27 || this.currentCommandID == 61 || this.currentCommandID == 78) {
            if ((GameApp.cgAlpha += 5) > 255) {
                GameApp.cgAlpha = 255;
                GameApp.gMan.cgSwap();
                this.running = true;
            }
        } else if (this.currentCommandID == 75) {
            GameApp.currentMap.background2.alpha += 5;
            if (GameApp.currentMap.background2.alpha > 255) {
                GameApp.currentMap.background2.alpha = 255;
                GameApp.currentMap.bgSwap();
                this.running = true;
            }
        } else if (this.currentCommandID == 20) {
            if ((GameApp.cgAlpha += 5) > 255) {
                GameApp.cgAlpha = 255;
                GameApp.cgState = 0;
                GameApp.gameState |= 0x40;
                this.running = true;
            }
        } else if (this.currentCommandID == 18) {
            GameApp.gameState &= 0xFFFF7FFF;
            if (this.saveScreenTimer == 25) {
                if (GameApp.guiMan.saveScreenLogic()) {
                    --this.saveScreenTimer;
                }
            } else {
                --this.saveScreenTimer;
                if (this.saveScreenTimer <= 0) {
                    this.running = true;
                    GameApp.gameState &= 0xFFFFFFF7;
                }
            }
        } else if (this.currentCommandID == 25) {
            GameApp.loadSave();
        } else if (this.currentCommandID == 26) {
            GameApp.gameState &= 0xFFFF7FFF;
            ++this.titleTimer;
            if (this.titleTimer >= 32) {
                this.titleTimer = 0;
            }
            if (GameApp.guiMan.titleScreenLogic()) {
                this.running = true;
                GameApp.gameState &= 0xFFFFFF7F;
            }
        } else if (this.currentCommandID == 46) {
            --this.inventoryTimer;
            if (this.inventoryTimer < 0) {
                this.inventoryTimer = 0;
                this.running = true;
            }
        } else if (this.currentCommandID == 50) {
            GameApp.gameState &= 0xFFFF7FFF;
            int idleResult = GameApp.guiMan.idleInventoryLogic();
            if (idleResult == 1) {
                this.runEvent(1910);
            } else if (idleResult == 2) {
                this.runEvent(1905);
            } else if (idleResult == 3) {
                this.runEvent(1950);
            } else if (idleResult == -1) {
                this.runEvent(1901);
                GameApp.key_pressed = 0;
            }
        } else if (this.currentCommandID == 83) {
            GameApp.gameState &= 0xFFFF7FFF;
            int idleResult = GameApp.guiMan.idleNotesLogic();
            if (idleResult == -1) {
                this.runEvent(1901);
                GameApp.key_pressed = 0;
            } else if (idleResult == 1) {
                this.runEvent(1950);
            } else if (idleResult == 2) {
                this.runEvent(this.currentEvent.getEventNum() + 1);
            } else if (idleResult == 3) {
                this.runEvent(this.currentEvent.getEventNum() - 1);
            }
        } else if (this.currentCommandID == 81) {
            GameApp.gameState &= 0xFFFF7FFF;
            int idleResult = GameApp.guiMan.idleInventoryLogic();
            if (idleResult == 3) {
                this.runEvent(1950);
            } else if (idleResult >= 4000) {
                this.runEvent(idleResult);
            } else if (idleResult == -1) {
                this.runEvent(1901);
                GameApp.key_pressed = 0;
            }
        } else if (this.currentCommandID == 49) {
            GameApp.gameState &= 0xFFFF7FFF;
            int comboResult = GameApp.guiMan.combineInventoryLogic();
            if (comboResult == -1) {
                GameApp.inventory.resetCombo();
                this.runEvent(1910);
            } else if (comboResult == 2) {
                if (!GameApp.inventory.isValidCombination()) {
                    GameApp.soundPlayer.playSound(14);
                } else {
                    GameApp.inventory.combine();
                    GameApp.soundPlayer.playSound(27);
                    this.runEvent(1910);
                }
            }
        } else if (this.currentCommandID == 23) {
            GameApp.gameState &= 0xFFFF7FFF;
            if (this.saveScreenTimer == 25) {
                if (GameApp.guiMan.loadScreenLogic()) {
                    --this.saveScreenTimer;
                }
            } else {
                --this.saveScreenTimer;
                if (this.saveScreenTimer <= 0) {
                    GameApp.gameState &= 0xFFFFFFEF;
                    this.running = true;
                    if (GameApp.loadedSave == null) {
                        this.runEvent(101);
                    } else {
                        this.runEvent(103);
                    }
                }
            }
        } else if (this.currentCommandID == 9) {
            ++this.waitTimer;
            if (this.waitTimer >= this.currentCommand.paramList.get(0)) {
                this.running = true;
            }
        } else if (this.currentCommandID == 2) {
            this.running = GameApp.guiMan.nodLogic();
            if ((GameApp.gameState & 0x8000) != 0) {
                this.running = true;
            }
        } else if (this.currentCommandID == 36) {
            GameApp.gameState &= 0xFFFF7FFF;
            int choice = GameApp.guiMan.choiceLogic(0, this.currentCommand.paramList.get(0));
            if (choice > -1) {
                GameApp.guiMan.displayChoice = false;
                if (choice == this.currentCommand.paramList.get(0) - 1) {
                    this.running = true;
                } else {
                    this.runEvent(this.currentCommand.paramList.get(1) + choice);
                }
            }
        } else if (this.currentCommandID == 58) {
            GameApp.gameState &= 0xFFFF7FFF;
            int choice = GameApp.guiMan.choiceLogic(1, 3);
            if (choice > -1) {
                GameApp.guiMan.displayChoice = false;
                if (choice == 2) {
                    this.running = true;
                } else {
                    this.runEvent(this.currentCommand.paramList.get(0));
                }
            }
        } else if (this.currentCommandID == 13) {
            if ((GameApp.fadeValue += 8) > 255) {
                GameApp.fadeValue = 255;
                this.running = true;
            }
        } else if (this.currentCommandID == 12 && (GameApp.fadeValue -= 8) < 0) {
            GameApp.fadeValue = 0;
            this.running = true;
        }
        while (this.running) {
            GameApp.guiMan.displayNodButtons = false;
            if (this.currentCommandNumb < 0) {
                this.currentCommandNumb = 0;
            }
            this.currentCommand = this.currentEvent.comList.get(this.currentCommandNumb);
            this.currentCommandID = this.currentCommand.commandID;
            switch (this.currentCommandID) {
                case 75: {
                    GameApp.currentMap.setBackground(this.currentCommand.text);
                    this.running = false;
                    break;
                }
                case 77: {
                    GameApp.guiMan.hideBossHPbar();
                    break;
                }
                case 74: {
                    Vector<Entity> boss = GameApp.entMan.getEntity(this.currentCommand.paramList.get(0));
                    if (boss.size() <= 0) break;
                    GameApp.guiMan.setupBossHPbar(boss.get(0));
                    break;
                }
                case 71: {
                    GameApp.pc.setMaxHP(GameApp.pc.getMaxHP() + this.currentCommand.paramList.get(0));
                    GameApp.pc.setCurrentHP(GameApp.pc.getCurrentHP() + this.currentCommand.paramList.get(0));
                    break;
                }
                case 68: {
                    GameApp.pc.changeWeapon(this.currentCommand.paramList.get(0));
                    break;
                }
                case 63: {
                    GameApp.guiMan.showMapName();
                    break;
                }
                case 64: {
                    GameApp.gameState |= 0x4000;
                    break;
                }
                case 65: {
                    GameApp.gameState &= 0xFFFFBFFF;
                    break;
                }
                case 57: {
                    ArrayList<Integer> vals = this.currentCommand.paramList;
                    Rectangle mirror = new Rectangle(vals.get(1) * 512, vals.get(2) * 512, vals.get(3) * 512, vals.get(4) * 512);
                    GameApp.currentMap.setMirror(mirror, vals.get(5), vals.get(0));
                    break;
                }
                case 10: {
                    GameApp.guiMan.clearText();
                    break;
                }
                case 42: {
                    GameApp.gameState |= 0x1000;
                    break;
                }
                case 43: {
                    GameApp.gameState &= 0xFFFFEFFF;
                    break;
                }
                case 44: {
                    GameApp.pc.heal(this.currentCommand.paramList.get(0));
                    break;
                }
                case 1: {
                    this.running = false;
                    GameApp.gameState &= 0xFFFF7FFF;
                    GameApp.pc.setState(0);
                    GameApp.guiMan.closeTextBox();
                    GameApp.gameState &= 0xFFFFEEFD;
                    GameApp.gameState |= 1;
                    break;
                }
                case 4: {
                    GameApp.musicPlayer.play(this.currentCommand.paramList.get(0));
                    break;
                }
                case 8: {
                    if (GameApp.musicPlayer.isPaused()) break;
                    GameApp.musicPlayer.pauseResume();
                    break;
                }
                case 67: {
                    if (!GameApp.musicPlayer.isPaused()) break;
                    GameApp.musicPlayer.pauseResume();
                    break;
                }
                case 7: {
                    this.runEvent(this.currentCommand.paramList.get(0));
                    this.currentCommandNumb = -1;
                    break;
                }
                case 69: {
                    GameApp.inventory.weaponBooks += this.currentCommand.paramList.get(0).intValue();
                    break;
                }
                case 70: {
                    GameApp.guiMan.addText(Integer.toString(GameApp.inventory.weaponBooks));
                    break;
                }
                case 0: 
                case 45: {
                    this.running = false;
                    try {
                        this.currentText = new String(this.currentCommand.text.getBytes("JIS"), "JIS");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 9: {
                    this.running = false;
                    this.waitTimer = 0;
                    break;
                }
                case 2: {
                    this.running = false;
                    break;
                }
                case 81: {
                    GameApp.guiMan.notesVisible = true;
                    GameApp.guiMan.populateNotesList();
                    this.running = false;
                    break;
                }
                case 82: {
                    GameApp.guiMan.notesPages = this.currentCommand.paramList.get(0);
                    break;
                }
                case 83: {
                    this.running = false;
                    break;
                }
                case 50: {
                    GameApp.inventory.idleInventory();
                    this.running = false;
                    break;
                }
                case 49: {
                    GameApp.inventory.comboInventory();
                    this.running = false;
                    break;
                }
                case 3: {
                    GameApp.guiMan.openTextBox();
                    break;
                }
                case 21: {
                    GameApp.guiMan.openCustomTextBox(this.currentCommand.paramList.get(0), this.currentCommand.paramList.get(1), this.currentCommand.paramList.get(2));
                    break;
                }
                case 85: {
                    GameApp.guiMan.setTextBoxColor(new Color(this.currentCommand.paramList.get(0), this.currentCommand.paramList.get(1), this.currentCommand.paramList.get(2), this.currentCommand.paramList.get(3)));
                    break;
                }
                case 22: {
                    GameApp.guiMan.closeTextBox();
                    break;
                }
                case 6: {
                    GameApp.gameState &= 0xFFFFFFFE;
                    break;
                }
                case 11: {
                    try {
                        GameApp.currentMap = new Stage(this.currentCommand.paramList.get(0));
                        GameApp.pc.move(this.currentCommand.paramList.get(1) * 512, this.currentCommand.paramList.get(2) * 512);
                        GameApp.gMan.cameraUpdateInstant();
                        GameApp.gMan.cameraUpdate();
                        GameApp.gMan.updateRendCamera();
                        GameApp.pc.setState(0);
                        this.runEvent(this.currentCommand.paramList.get(3));
                        this.currentCommandNumb = -1;
                    }
                    catch (IOException e) {
                        StrTools.msgBox("Couldn't load new map");
                        e.printStackTrace();
                    }
                    break;
                }
                case 12: {
                    this.running = false;
                    break;
                }
                case 13: {
                    this.running = false;
                    break;
                }
                case 15: {
                    GameApp.scriptFlags.setFlag(this.currentCommand.paramList.get(0));
                    break;
                }
                case 16: {
                    GameApp.scriptFlags.unsetFlag(this.currentCommand.paramList.get(0));
                    break;
                }
                case 52: {
                    GameApp.pc.useItem(GameApp.inventory.getSelectedItem());
                    break;
                }
                case 72: {
                    if (GameApp.pc.itemBeingUsed == this.currentCommand.paramList.get(0)) {
                        System.out.println("itemjump taken: " + this.currentCommand.paramList.get(0));
                        this.runEvent(this.currentCommand.paramList.get(1));
                        break;
                    }
                    System.out.println("itemjump not taken: " + this.currentCommand.paramList.get(0));
                    break;
                }
                case 17: {
                    if (GameApp.scriptFlags.checkFlag(this.currentCommand.paramList.get(0))) {
                        this.runEvent(this.currentCommand.paramList.get(1));
                        System.out.println("flagjump taken: " + this.currentCommand.paramList.get(0));
                        break;
                    }
                    System.out.println("flagjump not taken: " + this.currentCommand.paramList.get(0));
                    break;
                }
                case 62: {
                    if (!GameApp.scriptFlags.checkFlag(this.currentCommand.paramList.get(0))) {
                        this.runEvent(this.currentCommand.paramList.get(1));
                        System.out.println("flagnotjump taken: " + this.currentCommand.paramList.get(0));
                        break;
                    }
                    System.out.println("flagnotjump not taken: " + this.currentCommand.paramList.get(0));
                    break;
                }
                case 18: {
                    this.running = false;
                    this.saveScreenTimer = 50;
                    GameApp.gameState |= 8;
                    GameApp.drawSaveIcon();
                    break;
                }
                case 23: {
                    GameApp.loadedSave = null;
                    this.running = false;
                    this.saveScreenTimer = 50;
                    GameApp.gameState |= 0x10;
                    break;
                }
                case 46: {
                    this.running = false;
                    this.inventoryTimer = 25;
                    GameApp.gameState |= 0x2000;
                    GameApp.inventory.selectedItem = 0;
                    GameApp.guiMan.openInventory();
                    break;
                }
                case 51: {
                    GameApp.gameState &= 0xFFFFDFFF;
                    break;
                }
                case 47: {
                    this.runEvent(GameApp.inventory.getSelectedItem() + 2000);
                    break;
                }
                case 48: {
                    this.runEvent(GameApp.inventory.getSelectedItem() + 3000);
                    break;
                }
                case 25: {
                    this.runEvent(1);
                    GameApp.loadSave();
                    break;
                }
                case 37: {
                    GameApp.gMan.loadFacePic(this.currentCommand.text);
                    GameApp.guiMan.showFacePic1 = true;
                    GameApp.guiMan.showFacePic2 = false;
                    break;
                }
                case 38: {
                    GameApp.gMan.loadFacePic(this.currentCommand.text);
                    GameApp.guiMan.showFacePic2 = true;
                    GameApp.guiMan.showFacePic1 = false;
                    break;
                }
                case 56: {
                    GameApp.guiMan.showFacePic2 = false;
                    GameApp.guiMan.showFacePic1 = false;
                    break;
                }
                case 79: {
                    GameApp.gMan.setSmallShake(this.currentCommand.paramList.get(0));
                    break;
                }
                case 61: {
                    this.running = false;
                    GameApp.gMan.loadCG(this.currentCommand.text);
                    if ((GameApp.cgState & 2) == 0) {
                        GameApp.cgState |= 3;
                    }
                    GameApp.cgAlpha = 1;
                    GameApp.cgState |= 8;
                    break;
                }
                case 27: {
                    this.running = false;
                    GameApp.gMan.loadCG(this.currentCommand.text);
                    if ((GameApp.cgState & 2) == 0) {
                        GameApp.cgState |= 3;
                    }
                    GameApp.cgAlpha = 1;
                    break;
                }
                case 19: {
                    this.running = false;
                    GameApp.gMan.loadCG(this.currentCommand.text);
                    if ((GameApp.cgState & 2) == 0) {
                        GameApp.cgState |= 3;
                    }
                    GameApp.cgAlpha = 1;
                    GameApp.gameState &= 0xFFFFFFBF;
                    break;
                }
                case 78: {
                    this.running = false;
                    GameApp.gMan.loadCG(this.currentCommand.text);
                    if ((GameApp.cgState & 2) == 0) {
                        GameApp.cgState |= 3;
                    }
                    GameApp.cgAlpha = 244;
                    GameApp.gameState &= 0xFFFFFFBF;
                    break;
                }
                case 20: {
                    this.running = false;
                    GameApp.cgState |= 4;
                    GameApp.cgAlpha = 1;
                    GameApp.gMan.endCG();
                    break;
                }
                case 30: {
                    this.running = false;
                    GameApp.cgState |= 4;
                    GameApp.cgAlpha = 255;
                    this.currentCommandID = (byte)20;
                    GameApp.gMan.endCG();
                    break;
                }
                case 24: {
                    Vector<Entity> V = GameApp.entMan.getEntity(this.currentCommand.paramList.get(0));
                    if (V.isEmpty()) break;
                    GameApp.gMan.setCameraTarget(V.get(0));
                    GameApp.gMan.setCameraSpeed(this.currentCommand.paramList.get(1));
                    break;
                }
                case 31: {
                    GameApp.gMan.setCameraTarget(GameApp.pc);
                    GameApp.gMan.setCameraSpeed(this.currentCommand.paramList.get(0));
                    break;
                }
                case 26: {
                    this.running = false;
                    GameApp.gameState |= 0x80;
                    break;
                }
                case 80: {
                    GameApp.startTitleScreen();
                    break;
                }
                case 28: {
                    GameApp.gameState |= 0x20;
                    break;
                }
                case 29: {
                    GameApp.gameState &= 0xFFFFFFDF;
                    if (GameApp.pc.exclamationMark == null) break;
                    GameApp.pc.exclamationMark.hide();
                    break;
                }
                case 32: {
                    GameApp.gameState |= 0x100;
                    break;
                }
                case 33: {
                    GameApp.entMan.deleteEntities(this.currentCommand.paramList.get(0));
                    break;
                }
                case 34: {
                    GameApp.soundPlayer.playSound(this.currentCommand.paramList.get(0));
                    break;
                }
                case 5: {
                    GameApp.pc.move(this.currentCommand.paramList.get(0) * 512, this.currentCommand.paramList.get(1) * 512);
                    break;
                }
                case 76: {
                    GameApp.entMan.moveEntities(this.currentCommand.paramList.get(0), this.currentCommand.paramList.get(1) * 512, this.currentCommand.paramList.get(2) * 512);
                    break;
                }
                case 35: {
                    GameApp.entMan.animateEntities(this.currentCommand.paramList.get(0), this.currentCommand.paramList.get(1));
                    break;
                }
                case 59: {
                    GameApp.pc.setState(this.currentCommand.paramList.get(0));
                    break;
                }
                case 60: {
                    GameApp.pc.direction = this.currentCommand.paramList.get(0);
                    break;
                }
                case 53: {
                    GameApp.entMan.changeEntitiesDirection(this.currentCommand.paramList.get(0), this.currentCommand.paramList.get(1));
                    break;
                }
                case 84: {
                    GameApp.entMan.changeEntitiesFlags(this.currentCommand.paramList.get(0), this.currentCommand.paramList.get(1));
                    break;
                }
                case 66: {
                    GameApp.entMan.addEntity(this.currentCommand.paramList.get(0), this.currentCommand.paramList.get(3) * 512, this.currentCommand.paramList.get(4) * 512, 0, 0, this.currentCommand.paramList.get(2), this.currentCommand.paramList.get(1), 0, 0);
                    break;
                }
                case 41: {
                    GameApp.entMan.changeEntities(this.currentCommand.paramList.get(0), this.currentCommand.paramList.get(1));
                    break;
                }
                case 36: {
                    GameApp.guiMan.choiceIndex = 0;
                    this.running = false;
                    GameApp.guiMan.displayChoice = true;
                    break;
                }
                case 58: {
                    GameApp.guiMan.choiceIndex = 1;
                    this.running = false;
                    GameApp.guiMan.displayChoice = true;
                    break;
                }
                case 39: {
                    GameApp.guiMan.addText(GameConfig.getKeyNameFromIDNumb(this.currentCommand.paramList.get(0)));
                    break;
                }
                case 40: {
                    GameApp.pc.xVel = 0;
                    break;
                }
                case 54: {
                    GameApp.inventory.addItem(this.currentCommand.paramList.get(0));
                    break;
                }
                case 73: {
                    GameApp.inventory.removeItem(this.currentCommand.paramList.get(0));
                    break;
                }
                case 55: {
                    GameApp.guiMan.itemIcon = this.currentCommand.paramList.get(0);
                    break;
                }
                default: {
                    System.out.println("Unimplemented Command: " + this.currentCommandID);
                }
            }
            ++this.currentCommandNumb;
        }
    }

    public boolean runEvent(int eventNumb) {
        if (eventNumb == 0) {
            eventNumb = 9999;
        }
        if (this.globalEvents.containsKey(eventNumb)) {
            this.running = true;
            GameApp.gameState |= 2;
            this.currentCommandNumb = -1;
            this.currentCommandID = (byte)-1;
            this.currentEventNumb = eventNumb;
            this.currentEvent = this.globalEvents.get(eventNumb);
            System.out.println("Running Global Event: " + eventNumb);
            return true;
        }
        if (this.mapEvents.containsKey(eventNumb)) {
            this.running = true;
            GameApp.gameState |= 2;
            this.currentCommandNumb = -1;
            this.currentCommandID = (byte)-1;
            this.currentEventNumb = eventNumb;
            this.currentEvent = this.mapEvents.get(eventNumb);
            System.out.println("Running Event: " + eventNumb);
            return true;
        }
        StrTools.msgBox("Could not find Event: " + eventNumb);
        GameApp.gameState &= 0xFFFFFFFD;
        GameApp.gameShutdown();
        return false;
    }
}

