/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import local.rip.engine.ScriptCommand;

public class ScriptEvent {
    public ArrayList<ScriptCommand> comList = new ArrayList();
    private short eventNum;

    ScriptEvent(File lastFile, short event, String commands) {
        byte lastCommandID;
        String[] comChunks;
        this.eventNum = event;
        String[] stringArray = comChunks = commands.split("<");
        int n = comChunks.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() > 2) {
                String[] chunks2 = s.split(">", 2);
                this.comList.add(new ScriptCommand(lastFile, chunks2[0], chunks2.length > 1 ? chunks2[1] : "jellybeans"));
            }
            ++n2;
        }
        if (this.comList.size() > 0 && (lastCommandID = this.comList.get((int)(this.comList.size() - 1)).commandID) != 1 && lastCommandID != 7 && lastCommandID != 11) {
            System.out.println("Warning: Event " + event + " does not terminate properly");
        }
    }

    ScriptEvent(short event) {
        this.eventNum = event;
    }

    public int calcSize() {
        int s = 4;
        for (ScriptCommand com : this.comList) {
            s += com.calcSize();
        }
        return s;
    }

    public ByteBuffer toBuf() {
        ByteBuffer retVal = ByteBuffer.allocate(this.calcSize());
        retVal.order(ByteOrder.LITTLE_ENDIAN);
        retVal.putShort(this.eventNum);
        retVal.putShort((short)this.comList.size());
        for (ScriptCommand com : this.comList) {
            retVal.put(com.toBuf());
        }
        retVal.flip();
        return retVal;
    }

    public String toString() {
        String returnString = "#" + this.eventNum + "\n";
        for (ScriptCommand c : this.comList) {
            returnString = String.valueOf(returnString) + c.toString();
        }
        return returnString;
    }

    public int getEventNum() {
        return this.eventNum;
    }
}

