/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class ScriptCommand {
    public static final byte TEXT = 0;
    public static final byte END = 1;
    public static final byte NOD = 2;
    public static final byte OPENTEXTBOX = 3;
    public static final byte CHANGEMUSIC = 4;
    public static final byte MOVEPLAYER = 5;
    public static final byte KEYLOCK = 6;
    public static final byte EVENT = 7;
    public static final byte STOPMUSIC = 8;
    public static final byte WAIT = 9;
    public static final byte CLEARTEXT = 10;
    public static final byte CHANGEMAP = 11;
    public static final byte FADEIN = 12;
    public static final byte FADEOUT = 13;
    public static final byte GAMELOCK = 14;
    public static final byte SETFLAG = 15;
    public static final byte UNSETFLAG = 16;
    public static final byte FLAGJUMP = 17;
    public static final byte SAVE = 18;
    public static final byte SHOW_CG = 19;
    public static final byte END_CG = 20;
    public static final byte OPENCUSTOMTEXTBOX = 21;
    public static final byte CLOSETEXTBOX = 22;
    public static final byte LOADSAVESCREEN = 23;
    public static final byte FOCUSONENTITY = 24;
    public static final byte LOADSAVE = 25;
    public static final byte TITLE = 26;
    public static final byte SHOW_CG_MAP = 27;
    public static final byte SHOW_PLAYER = 28;
    public static final byte HIDE_PLAYER = 29;
    public static final byte END_CG_INSTANT = 30;
    public static final byte FOCUS_ON_PLAYER = 31;
    public static final byte PAUSE = 32;
    public static final byte DELETE_ENTITY = 33;
    public static final byte PLAY_SOUND = 34;
    public static final byte ANIMATE_ENTITY = 35;
    public static final byte CHOICE = 36;
    public static final byte FACEPIC_1 = 37;
    public static final byte FACEPIC_2 = 38;
    public static final byte KEY_NAME = 39;
    public static final byte STOP_PLAYER = 40;
    public static final byte CHANGE_ENTITY = 41;
    public static final byte SHOW_HUD = 42;
    public static final byte HIDE_HUD = 43;
    public static final byte HEAL_PLAYER = 44;
    public static final byte FAST_TEXT = 45;
    public static final byte OPEN_INVENTORY = 46;
    public static final byte ITEM_NAME = 47;
    public static final byte EXAMINE_ITEM = 48;
    public static final byte COMBINE_ITEM = 49;
    public static final byte IDLE_INVENTORY = 50;
    public static final byte CLOSE_INVENTORY = 51;
    public static final byte USE_ITEM = 52;
    public static final byte ENTITY_DIRECTION = 53;
    public static final byte ADD_ITEM = 54;
    public static final byte ITEM_ICON = 55;
    public static final byte NO_FACEPIC = 56;
    public static final byte SET_MIRROR = 57;
    public static final byte YES_NO = 58;
    public static final byte ANIMATE_PLAYER = 59;
    public static final byte PLAYER_DIRECTION = 60;
    public static final byte SHOW_CG_GAME_OVERLAY = 61;
    public static final byte FLAG_NOT_JUMP = 62;
    public static final byte MAP_NAME = 63;
    public static final byte SHOW_ONLY_PLAYER = 64;
    public static final byte SHOW_MAP = 65;
    public static final byte ADD_ENTITY = 66;
    public static final byte RESUME_MUSIC = 67;
    public static final byte CHANGE_WEAPON = 68;
    public static final byte ADD_BOOKS = 69;
    public static final byte NUM_OF_BOOKS = 70;
    public static final byte MAX_LIFE_PLUS = 71;
    public static final byte ITEM_USED_JUMP = 72;
    public static final byte REMOVE_ITEM = 73;
    public static final byte LOAD_BOSS = 74;
    public static final byte CHANGE_BG = 75;
    public static final byte MOVE_ENTITY = 76;
    public static final byte END_BOSS = 77;
    public static final byte SHOW_CG_INSTANT = 78;
    public static final byte SHAKE_SCREEN = 79;
    public static final byte START_TITLE_SCREEN = 80;
    public static final byte LIST_NOTES = 81;
    public static final byte NUMBER_OF_PAGES = 82;
    public static final byte IDLE_NOTES = 83;
    public static final byte ENTITY_FLAGS = 84;
    public static final byte TEXTBOX_COLOR = 85;
    public static final byte[] commandsThatUseText;
    public static final int[] paramLens;
    public byte commandID;
    public ArrayList<Integer> paramList = new ArrayList();
    String text;

    static {
        byte[] byArray = new byte[9];
        byArray[1] = 19;
        byArray[2] = 27;
        byArray[3] = 37;
        byArray[4] = 38;
        byArray[5] = 45;
        byArray[6] = 61;
        byArray[7] = 75;
        byArray[8] = 78;
        commandsThatUseText = byArray;
        int[] nArray = new int[86];
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[7] = 1;
        nArray[9] = 1;
        nArray[11] = 4;
        nArray[15] = 1;
        nArray[16] = 1;
        nArray[17] = 2;
        nArray[21] = 3;
        nArray[24] = 2;
        nArray[31] = 1;
        nArray[33] = 1;
        nArray[34] = 1;
        nArray[35] = 2;
        nArray[36] = 2;
        nArray[39] = 1;
        nArray[41] = 2;
        nArray[44] = 1;
        nArray[53] = 2;
        nArray[54] = 1;
        nArray[55] = 1;
        nArray[57] = 6;
        nArray[58] = 1;
        nArray[59] = 1;
        nArray[60] = 1;
        nArray[62] = 2;
        nArray[66] = 5;
        nArray[68] = 1;
        nArray[69] = 1;
        nArray[71] = 1;
        nArray[72] = 2;
        nArray[73] = 1;
        nArray[74] = 1;
        nArray[76] = 3;
        nArray[79] = 1;
        nArray[82] = 1;
        nArray[84] = 2;
        nArray[85] = 4;
        paramLens = nArray;
    }

    ScriptCommand(byte commID) {
        this.commandID = commID;
    }

    ScriptCommand(File lastFile, String tagName, String parameters) {
        tagName = tagName.toLowerCase();
        if (tagName.equals("end")) {
            this.commandID = 1;
        } else if (tagName.equals("text")) {
            this.commandID = 0;
        } else if (tagName.equals("nod")) {
            this.commandID = (byte)2;
        } else if (tagName.equals("opentextbox")) {
            this.commandID = (byte)3;
        } else if (tagName.equals("moveplayer")) {
            this.commandID = (byte)5;
        } else if (tagName.equals("changemusic")) {
            this.commandID = (byte)4;
        } else if (tagName.equals("keylock")) {
            this.commandID = (byte)6;
        } else if (tagName.equals("event")) {
            this.commandID = (byte)7;
        } else if (tagName.equals("stopmusic")) {
            this.commandID = (byte)8;
        } else if (tagName.equals("wait")) {
            this.commandID = (byte)9;
        } else if (tagName.equals("cleartext")) {
            this.commandID = (byte)10;
        } else if (tagName.equals("changemap")) {
            this.commandID = (byte)11;
        } else if (tagName.equals("fadein")) {
            this.commandID = (byte)12;
        } else if (tagName.equals("fadeout")) {
            this.commandID = (byte)13;
        } else if (tagName.equals("gamelock")) {
            this.commandID = (byte)14;
        } else if (tagName.equals("setflag")) {
            this.commandID = (byte)15;
        } else if (tagName.equals("unsetflag")) {
            this.commandID = (byte)16;
        } else if (tagName.equals("flagjump")) {
            this.commandID = (byte)17;
        } else if (tagName.equals("save")) {
            this.commandID = (byte)18;
        } else if (tagName.equals("showcg")) {
            this.commandID = (byte)19;
        } else if (tagName.equals("endcg")) {
            this.commandID = (byte)20;
        } else if (tagName.equals("opencustomtextbox")) {
            this.commandID = (byte)21;
        } else if (tagName.equals("closetextbox")) {
            this.commandID = (byte)22;
        } else if (tagName.equals("loadsavescreen")) {
            this.commandID = (byte)23;
        } else if (tagName.equals("focusonentity")) {
            this.commandID = (byte)24;
        } else if (tagName.equals("loadsave")) {
            this.commandID = (byte)25;
        } else if (tagName.equals("title")) {
            this.commandID = (byte)26;
        } else if (tagName.equals("showcgmap")) {
            this.commandID = (byte)27;
        } else if (tagName.equals("showplayer")) {
            this.commandID = (byte)28;
        } else if (tagName.equals("hideplayer")) {
            this.commandID = (byte)29;
        } else if (tagName.equals("endcginstant")) {
            this.commandID = (byte)30;
        } else if (tagName.equals("focusonplayer")) {
            this.commandID = (byte)31;
        } else if (tagName.equals("pause")) {
            this.commandID = (byte)32;
        } else if (tagName.equals("deleteentity")) {
            this.commandID = (byte)33;
        } else if (tagName.equals("playsound")) {
            this.commandID = (byte)34;
        } else if (tagName.equals("animateentity")) {
            this.commandID = (byte)35;
        } else if (tagName.equals("choice")) {
            this.commandID = (byte)36;
        } else if (tagName.equals("facepic1")) {
            this.commandID = (byte)37;
        } else if (tagName.equals("facepic2")) {
            this.commandID = (byte)38;
        } else if (tagName.equals("keyname")) {
            this.commandID = (byte)39;
        } else if (tagName.equals("stopplayer")) {
            this.commandID = (byte)40;
        } else if (tagName.equals("changeentity")) {
            this.commandID = (byte)41;
        } else if (tagName.equals("showhud")) {
            this.commandID = (byte)42;
        } else if (tagName.equals("hidehud")) {
            this.commandID = (byte)43;
        } else if (tagName.equals("healplayer")) {
            this.commandID = (byte)44;
        } else if (tagName.equals("fasttext")) {
            this.commandID = (byte)45;
        } else if (tagName.equals("openinventory")) {
            this.commandID = (byte)46;
        } else if (tagName.equals("itemname")) {
            this.commandID = (byte)47;
        } else if (tagName.equals("examineitem")) {
            this.commandID = (byte)48;
        } else if (tagName.equals("combineitem")) {
            this.commandID = (byte)49;
        } else if (tagName.equals("idleinventory")) {
            this.commandID = (byte)50;
        } else if (tagName.equals("closeinventory")) {
            this.commandID = (byte)51;
        } else if (tagName.equals("useitem")) {
            this.commandID = (byte)52;
        } else if (tagName.equals("entitydirection")) {
            this.commandID = (byte)53;
        } else if (tagName.equals("additem")) {
            this.commandID = (byte)54;
        } else if (tagName.equals("itemicon")) {
            this.commandID = (byte)55;
        } else if (tagName.equals("nofacepic")) {
            this.commandID = (byte)56;
        } else if (tagName.equals("setmirror")) {
            this.commandID = (byte)57;
        } else if (tagName.equals("yesno")) {
            this.commandID = (byte)58;
        } else if (tagName.equals("animateplayer")) {
            this.commandID = (byte)59;
        } else if (tagName.equals("playerdirection")) {
            this.commandID = (byte)60;
        } else if (tagName.equals("showcggameoverlay")) {
            this.commandID = (byte)61;
        } else if (tagName.equals("flagnotjump")) {
            this.commandID = (byte)62;
        } else if (tagName.equals("mapname")) {
            this.commandID = (byte)63;
        } else if (tagName.equals("showonlyplayer")) {
            this.commandID = (byte)64;
        } else if (tagName.equals("showmap")) {
            this.commandID = (byte)65;
        } else if (tagName.equals("addentity")) {
            this.commandID = (byte)66;
        } else if (tagName.equals("resumemusic")) {
            this.commandID = (byte)67;
        } else if (tagName.equals("changeweapon")) {
            this.commandID = (byte)68;
        } else if (tagName.equals("addbooks")) {
            this.commandID = (byte)69;
        } else if (tagName.equals("numberofbooks")) {
            this.commandID = (byte)70;
        } else if (tagName.equals("maxlifeplus")) {
            this.commandID = (byte)71;
        } else if (tagName.equals("itemusedjump")) {
            this.commandID = (byte)72;
        } else if (tagName.equals("removeitem")) {
            this.commandID = (byte)73;
        } else if (tagName.equals("loadboss")) {
            this.commandID = (byte)74;
        } else if (tagName.equals("changebg")) {
            this.commandID = (byte)75;
        } else if (tagName.equals("moveentity")) {
            this.commandID = (byte)76;
        } else if (tagName.equals("endboss")) {
            this.commandID = (byte)77;
        } else if (tagName.equals("showcginstant")) {
            this.commandID = (byte)78;
        } else if (tagName.equals("shakescreen")) {
            this.commandID = (byte)79;
        } else if (tagName.equals("starttitlescreen")) {
            this.commandID = (byte)80;
        } else if (tagName.equals("listnotes")) {
            this.commandID = (byte)81;
        } else if (tagName.equals("numberofpages")) {
            this.commandID = (byte)82;
        } else if (tagName.equals("idlenotes")) {
            this.commandID = (byte)83;
        } else if (tagName.equals("entityflags")) {
            this.commandID = (byte)84;
        } else if (tagName.equals("textboxcolor")) {
            this.commandID = (byte)85;
        } else {
            System.out.println("Bad Command: " + tagName);
            this.commandID = (byte)-1;
            this.text = "";
            return;
        }
        if (this.isInByteArray(commandsThatUseText, this.commandID)) {
            this.text = parameters;
            this.text = this.text.replaceAll("&gt;", ">");
            this.text = this.text.replaceAll("&lt;", "<");
            try {
                this.paramList.add(this.text.getBytes("JIS").length);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            String[] split = parameters.split(",");
            int i = 0;
            while (i < paramLens[this.commandID]) {
                int current = -1;
                try {
                    split[i] = split[i].replaceAll("\\s+", "");
                    current = split[i].length() > 2 && split[i].substring(0, 2).equals("0x") ? Integer.parseInt(split[i].substring(2), 16) : Integer.parseInt(split[i]);
                }
                catch (Exception err) {
                    System.err.println("Malformatted command: " + tagName + parameters);
                    System.err.println("in: " + lastFile);
                }
                this.paramList.add(current);
                ++i;
            }
            this.text = "";
        }
    }

    public int calcSize() {
        try {
            return this.text.getBytes("JIS").length + this.paramList.size() * 4 + 1;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public ByteBuffer toBuf() {
        ByteBuffer retVal = ByteBuffer.allocate(this.calcSize());
        retVal.order(ByteOrder.LITTLE_ENDIAN);
        retVal.put(this.commandID);
        for (int i : this.paramList) {
            retVal.putInt(i);
        }
        if (!this.text.equals("")) {
            try {
                retVal.put(this.text.getBytes("JIS"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        retVal.flip();
        return retVal;
    }

    public String toString() {
        String returnString = String.valueOf(this.commandID) + ":";
        for (Integer i : this.paramList) {
            returnString = String.valueOf(returnString) + i + ",";
        }
        if (this.text != null) {
            returnString = String.valueOf(returnString) + this.text;
        }
        returnString = String.valueOf(returnString) + "\n";
        return returnString;
    }

    public boolean isInByteArray(byte[] array, byte b) {
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte x = byArray[n2];
            if (b == x) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

