/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import local.rip.engine.GameApp;
import local.rip.engine.RipPC;
import local.rip.engine.RisaPC;
import local.rip.engine.SaveFile;

public class SaveManager {
    public void save(int saveNumber) {
        byte currentPlayer = 0;
        if (GameApp.pc instanceof RipPC) {
            currentPlayer = 1;
        } else if (GameApp.pc instanceof RisaPC) {
            currentPlayer = 2;
        }
        if (GameApp.saves[saveNumber] == null) {
            GameApp.saves[saveNumber] = new SaveFile(GameApp.ripPc, GameApp.risaPc, currentPlayer, GameApp.musicPlayer.getCurrentSongNum(), GameApp.currentMap.getMapNum(), saveNumber + 1, GameApp.scriptFlags.clone(), (Vector)GameApp.inventory.getItems().clone(), (Vector)GameApp.inventory.getNotes().clone(), GameApp.inventory.weaponBooks);
        } else {
            GameApp.saves[saveNumber].overwriteSave(GameApp.ripPc, GameApp.risaPc, currentPlayer, GameApp.musicPlayer.getCurrentSongNum(), GameApp.currentMap.getMapNum(), saveNumber + 1, GameApp.scriptFlags.clone(), (Vector)GameApp.inventory.getItems().clone(), (Vector)GameApp.inventory.getNotes().clone(), GameApp.inventory.weaponBooks);
        }
        this.writeSave(GameApp.saves[saveNumber]);
    }

    public static String getSaveDirectory() {
        String path;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            path = System.getenv("APPDATA");
        } else if (os.equals("Linux")) {
            path = System.getenv("XDG_CONFIG_HOME");
            if (path == null) {
                path = String.valueOf(System.getenv("HOME")) + "/.config";
            }
        } else if (os.equals("Mac OS X")) {
            path = String.valueOf(System.getenv("HOME")) + "/Library/Application Support";
        } else {
            return new String();
        }
        String directory = new String(String.valueOf(path) + File.separator + "rip" + File.separator);
        File makeDirs = new File(directory);
        makeDirs.mkdirs();
        return directory;
    }

    public boolean writeSave(SaveFile s) {
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(SaveManager.getSaveDirectory()) + "mst_" + s.getSaveNumber() + ".sav");
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(s);
            oos.close();
            fout.close();
            System.out.println("SaveFile Written");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public SaveFile loadSave(int saveNum) {
        SaveFile s = null;
        try {
            FileInputStream fin = new FileInputStream(String.valueOf(SaveManager.getSaveDirectory()) + "mst_" + saveNum + ".sav");
            ObjectInputStream ois = new ObjectInputStream(fin);
            s = (SaveFile)ois.readObject();
            ois.close();
            fin.close();
            System.out.println("SaveFile Loaded");
        }
        catch (FileNotFoundException e) {
            System.out.println("SaveFile Not Found: " + saveNum);
            s = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            s = null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            s = null;
        }
        return s;
    }
}

