/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import javax.imageio.ImageIO;
import local.rip.engine.Flags;
import local.rip.engine.GameApp;
import local.rip.engine.RipPC;
import local.rip.engine.RisaPC;
import local.rip.engine.SavedPlayer;

public class SaveFile
implements Serializable {
    private static final long serialVersionUID = -512551544102460101L;
    static final byte RipPlayer = 1;
    static final byte RisaPlayer = 2;
    private byte currentPlayerType;
    private SavedPlayer ripPc;
    private SavedPlayer risaPc;
    private int songID;
    private int mapNum;
    private int saveNumber = 1;
    private Flags flags;
    private Vector<Integer> items;
    private Vector<Integer> notes;
    private int weaponBooks;
    private Vector<Rectangle> mirrors;
    private boolean hasMirror;
    private Vector<Integer> mirrorDirs;
    private Date d;
    private BufferedImage saveIcon;

    public SaveFile(RipPC rip, RisaPC risa, byte playerType, int song, int currentMapNum, int saveNum, Flags f, Vector<Integer> items, Vector<Integer> notes, int weapBooks) {
        this.overwriteSave(rip, risa, playerType, song, currentMapNum, saveNum, f, items, notes, weapBooks);
    }

    public void overwriteSave(RipPC rip, RisaPC risa, byte playerType, int song, int currentMapNum, int saveNum, Flags f, Vector<Integer> items, Vector<Integer> notes, int weapBooks) {
        this.ripPc = new SavedPlayer(rip);
        this.risaPc = new SavedPlayer(risa);
        this.currentPlayerType = playerType;
        this.songID = song;
        this.mapNum = currentMapNum;
        this.saveNumber = saveNum;
        this.flags = f;
        this.saveIcon = new BufferedImage(48, 48, 5);
        this.items = items;
        this.notes = notes;
        this.weaponBooks = weapBooks;
        this.mirrors = GameApp.currentMap.getMirrors();
        this.hasMirror = this.mirrors.size() > 0;
        this.mirrorDirs = GameApp.currentMap.getMirrorDirs();
        this.d = new Date();
        Graphics2D g = (Graphics2D)this.saveIcon.getGraphics();
        GameApp.gMan.copySaveIcon(g);
    }

    public int getSaveNumber() {
        return this.saveNumber;
    }

    public RipPC getRip() {
        return this.ripPc.makeRip();
    }

    public RisaPC getRisa() {
        return this.risaPc.makeRisa();
    }

    public byte getCurrentPlayerType() {
        return this.currentPlayerType;
    }

    public int getPlayerCurrentHP() {
        return this.ripPc.currentHP;
    }

    public int getPlayerMaxHP() {
        return this.ripPc.maxHP;
    }

    public int getMapNum() {
        return this.mapNum;
    }

    public int getSongID() {
        return this.songID;
    }

    public Vector<Integer> getItems() {
        return (Vector)this.items.clone();
    }

    public Vector<Integer> getNotes() {
        return (Vector)this.notes.clone();
    }

    public int getBooks() {
        return this.weaponBooks;
    }

    public Flags getFlags() {
        return this.flags.clone();
    }

    public BufferedImage getIcon() {
        return this.saveIcon;
    }

    public Date getDate() {
        return this.d;
    }

    public boolean hasMirror() {
        return this.hasMirror;
    }

    public Vector<Rectangle> getMirrors() {
        return this.mirrors;
    }

    public Vector<Integer> getMirrorDirs() {
        return this.mirrorDirs;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(-512551544102460101L);
        out.writeObject(this.ripPc);
        out.writeObject(this.risaPc);
        out.writeByte(this.currentPlayerType);
        out.writeInt(this.songID);
        out.writeInt(this.mapNum);
        out.writeInt(this.saveNumber);
        out.writeObject(this.flags);
        out.writeObject(this.items);
        out.writeObject(this.notes);
        out.writeInt(this.weaponBooks);
        out.writeObject(this.mirrors);
        out.writeBoolean(this.hasMirror);
        out.writeObject(this.mirrorDirs);
        out.writeObject(this.d);
        ImageIO.write((RenderedImage)this.saveIcon, "png", out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            long version = in.readLong();
            if (version != -512551544102460101L) {
                throw new IOException("Bad Save, wrong version.");
            }
            this.ripPc = (SavedPlayer)in.readObject();
            this.risaPc = (SavedPlayer)in.readObject();
            this.currentPlayerType = in.readByte();
            this.songID = in.readInt();
            this.mapNum = in.readInt();
            this.saveNumber = in.readInt();
            this.flags = (Flags)in.readObject();
            this.items = (Vector)in.readObject();
            this.notes = (Vector)in.readObject();
            this.weaponBooks = in.readInt();
            this.mirrors = (Vector)in.readObject();
            this.hasMirror = in.readBoolean();
            this.mirrorDirs = (Vector)in.readObject();
            this.d = (Date)in.readObject();
            this.saveIcon = ImageIO.read(in);
        }
        catch (Exception e) {
            System.out.println("Error loading save");
            throw new IOException("Error loading save");
        }
    }
}

