/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import local.rip.effect.Effect005ExclamationMark;
import local.rip.engine.GameApp;
import local.rip.engine.Player;
import local.rip.engine.Weapon;

public class RisaPC
extends Player {
    private static final int MAX_WALK_SPEED = 1064;
    private static final int WALK_ACCEL = 100;
    private static final int AIR_ACCEL = 60;
    private static final int MAX_RUN_SPEED = 1950;
    private static final int RUN_ACCEL = 100;
    public static final int JUMP_SPEED = 3000;
    private static final int BACKDASH_SPEED = 2300;
    private int chargeTimer = 0;
    private int airGraceTimer = 0;
    private boolean axeCharged = false;

    RisaPC() {
        this.currentHP = 5;
        this.maxHP = 10;
        this.xPos = 0;
        this.yPos = 0;
        this.xVel = 0;
        this.yVel = 0;
        this.friction = 90;
        this.gravity = 170;
        this.state = 0;
        this.collision = 0;
        this.frameX = 0;
        this.frameY = 0;
        this.frameTimer = 0;
        this.scrTimer = 0;
        this.displayOffsetX = 13824;
        this.displayOffsetY = 17408;
        this.direction = 4;
        this.frameRect = new Rectangle(0, 0, 54, 60);
        this.hitRect = new Rectangle(-5, -24, 10, 50);
        this.weight = 0;
        this.weapon = new Weapon(2, this);
    }

    @Override
    public void update() {
        ++this.chargeTimer;
        if (this.chargeTimer > 3) {
            this.chargeTimer = 0;
        }
        if (this.dBox != null) {
            this.dBox.moveRelative(this.xPos - this.xOld, this.yPos - this.yOld);
        }
        if ((GameApp.gameState & 1) != 0) {
            this.kp = GameApp.getKeyPress();
            this.kh = GameApp.getKeyHeld();
        } else {
            this.kp = 0;
            this.kh = 0;
        }
        if ((this.kp & 0x200) != 0 && (GameApp.gameState & 0x2002) == 0) {
            GameApp.scriptRunner.runEvent(1900);
        }
        this.direction &= 0xFFFFFFFD;
        this.direction &= 0xFFFFFFF7;
        if (this.interactablePresent && !GameApp.isScriptRunning()) {
            if (this.exclamationMark == null) {
                this.exclamationMark = new Effect005ExclamationMark(5, 0, 0, 0, 0, 0);
                GameApp.effectMan.addEffect(this.exclamationMark);
                this.exclamationMark.setParent(this);
            } else {
                this.exclamationMark.show();
            }
        } else if (this.exclamationMark != null) {
            this.exclamationMark.hide();
        }
        switch (this.state) {
            case 0: {
                this.idle();
                break;
            }
            case 1: {
                this.walking();
                break;
            }
            case 50: {
                this.animatedWalking();
                break;
            }
            case 3: {
                this.air(false);
                break;
            }
            case 2: {
                this.air(true);
                break;
            }
            case 6: {
                this.turn();
                break;
            }
            case 4: {
                this.jump(false, false);
                break;
            }
            case 7: {
                this.jump(true, false);
                break;
            }
            case 5: {
                this.running();
                break;
            }
            case 51: {
                this.animatedRunning();
                break;
            }
            case 18: {
                this.investigate();
                break;
            }
            case 8: {
                this.use(0);
                break;
            }
            case 13: {
                this.use(2);
                break;
            }
            case 14: {
                this.use(8);
                break;
            }
            case 19: {
                this.jump(false, true);
                break;
            }
            case 20: {
                this.backdash();
                break;
            }
            case 15: {
                this.hurt();
                break;
            }
            case 16: {
                this.corpse();
                break;
            }
            case 21: {
                this.sit();
                break;
            }
            case 22: {
                this.swap();
                break;
            }
            default: {
                System.out.println("Bad PC state: " + this.state);
            }
        }
        this.airGraceTimer = (this.collision & 8) == 0 ? ++this.airGraceTimer : 0;
        if (this.invincibilityTimer > 0) {
            --this.invincibilityTimer;
        }
        this.frameRect.x = this.frameX * this.frameRect.width;
        this.frameRect.y = this.frameY * this.frameRect.height;
        if (this.xVel > 4000) {
            this.xVel = 4000;
        }
        if (this.xVel < -4000) {
            this.xVel = -4000;
        }
        if (this.yVel > 4000) {
            this.yVel = 4000;
        }
        if (this.yVel < -4000) {
            this.yVel = -4000;
        }
        this.xOld = this.xPos;
        this.yOld = this.yPos;
        this.xOldVel = this.xVel;
        this.yOldVel = this.yVel;
        this.movement();
        this.tileCollision(5);
    }

    @Override
    public void setState(int newState) {
        this.displayOffsetY = 17408;
        if (this.state == 16) {
            return;
        }
        if (newState == 8 && this.weapon.type == 0) {
            return;
        }
        this.state = newState;
        this.frameTimer = 0;
        this.frameIndex = 0;
        this.scrTimer = 0;
        this.axeCharged = false;
    }

    private void corpse() {
        this.frameX = 8;
        this.frameY = 5;
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        this.friction();
        this.gravity();
    }

    private void hurt() {
        this.frameX = 8;
        this.frameY = 4;
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        if ((this.collision & 8) != 0) {
            if (this.currentHP <= 0) {
                this.setState(16);
                if ((this.direction & 1) == 0) {
                    this.direction |= 1;
                    this.direction &= 0xFFFFFFFB;
                } else {
                    this.direction |= 4;
                    this.direction &= 0xFFFFFFFE;
                }
            } else {
                this.setState(0);
            }
        } else if (this.invincibilityTimer <= 0 && this.currentHP > 0) {
            this.setState(0);
        }
        this.gravity();
    }

    private void backdash() {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[4] = 2;
        int[] frameArray = nArray;
        this.frameX = 14;
        this.frameY = frameArray[this.frameIndex];
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        ++this.frameTimer;
        if (this.frameTimer > 4) {
            ++this.frameIndex;
            this.frameTimer = 0;
            if (this.frameIndex > 4) {
                this.setState(0);
            }
        }
        if ((this.kh & 2) != 0) {
            this.direction |= 2;
        }
        if ((this.kh & 8) != 0) {
            this.direction |= 8;
        }
        if ((this.collision & 8) != 0) {
            this.friction();
        } else {
            this.setState(3);
        }
        this.gravity();
    }

    private void use(int useDirection) {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 2;
        int[] frameArray = nArray;
        int[] frameWait = new int[]{3, 3, 3, 4, 6};
        this.frameY = frameArray[this.frameIndex];
        this.frameX = 10;
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        if (useDirection == 2) {
            this.frameY += 3;
        } else if (useDirection == 8) {
            this.frameX += 2;
        }
        if ((this.kh & 2) != 0) {
            this.direction |= 2;
        }
        if ((this.kh & 8) != 0) {
            this.direction |= 8;
        }
        this.weapon.use(useDirection);
        ++this.frameTimer;
        if (this.frameTimer > frameWait[this.frameIndex]) {
            this.frameTimer = 0;
            ++this.frameIndex;
        }
        if (this.frameIndex > 4) {
            this.setState(0);
        } else if (this.frameIndex == 1 && this.frameTimer == 0) {
            GameApp.soundPlayer.playSound(32);
            int knifeDir = useDirection;
            knifeDir = (this.direction & 1) != 0 ? (knifeDir |= 1) : (knifeDir |= 4);
            GameApp.entMan.addEntity(17, this.xPos, this.yPos + 2560, 0, 0, 0, 0, knifeDir, 0);
        } else if (this.frameIndex >= 3) {
            if ((this.kp & 0x40) != 0) {
                if ((this.kh & 2) != 0) {
                    this.setState(13);
                } else if ((this.kh & 8) != 0 && (this.collision & 8) == 0) {
                    this.setState(14);
                } else {
                    this.setState(8);
                }
            }
        } else if (this.frameIndex == 4) {
            if ((this.kh & 4) != 0) {
                this.direction |= 4;
                this.direction &= 0xFFFFFFFE;
                this.setState(1);
            } else if ((this.kh & 1) != 0) {
                this.direction |= 1;
                this.direction &= 0xFFFFFFFB;
                this.setState(1);
            }
        }
        this.gravity();
        if ((this.collision & 8) != 0) {
            this.friction();
        }
    }

    private void investigate() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] frameArray = nArray;
        int[] frameWait = new int[]{8, 8, 8, 8};
        if (this.frameIndex > 3) {
            this.frameIndex = 0;
        }
        this.frameY = frameArray[this.frameIndex];
        this.frameX = 8;
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        ++this.frameTimer;
        if (this.frameTimer > frameWait[this.frameIndex]) {
            this.frameTimer = 0;
            ++this.frameIndex;
        }
        this.gravity();
        this.friction();
        this.friction();
    }

    private void idle() {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[5] = 1;
        nArray[6] = 4;
        nArray[7] = 5;
        int[] frameArray = nArray;
        int[] frameWait = new int[]{8, 8, 8, 8, 8, 8, 8, 8};
        if (this.frameIndex > 7) {
            this.frameIndex = 0;
        }
        this.frameY = frameArray[this.frameIndex];
        this.frameX = 0;
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        ++this.frameTimer;
        if (this.frameTimer > frameWait[this.frameIndex]) {
            this.frameTimer = 0;
            ++this.frameIndex;
        }
        if ((this.kh & 2) != 0) {
            this.direction |= 2;
        } else if ((this.kh & 8) != 0) {
            this.direction |= 8;
            if ((this.kp & 0x100) != 0) {
                int ySwap;
                int xSwap;
                this.setState(22);
                GameApp.soundPlayer.playSound(40);
                if (GameApp.partnerPc != null) {
                    xSwap = (this.xPos + GameApp.partnerPc.xPos) / 2;
                    ySwap = (this.yPos + GameApp.partnerPc.yPos) / 2;
                    GameApp.partnerPc.hidePartner();
                } else {
                    xSwap = this.xPos;
                    ySwap = this.yPos;
                }
                if ((this.direction & 1) != 0) {
                    GameApp.effectMan.addEffect(3, xSwap, ySwap, 0, 0, 0);
                } else {
                    GameApp.effectMan.addEffect(3, xSwap, ySwap, 0, 0, 1);
                }
                return;
            }
        }
        if ((this.kp & 0x100) != 0 && this.interactablePresent) {
            GameApp.scriptRunner.runEvent(this.interactableEntity.eventNumb);
            this.setState(18);
        }
        if ((this.kh & 4) != 0 && (this.kh & 1) == 0) {
            if ((this.direction & 1) != 0) {
                this.setState(6);
                this.frameTimer = 0;
            } else {
                this.state = 1;
            }
            this.direction |= 4;
            this.direction &= 0xFFFFFFFE;
        } else if ((this.kh & 1) != 0) {
            if ((this.direction & 4) != 0) {
                this.setState(6);
                this.frameTimer = 0;
            } else {
                this.state = 1;
            }
            this.direction |= 1;
            this.direction &= 0xFFFFFFFB;
        }
        if (this.airGraceTimer > 1) {
            this.state = this.yVel < 0 ? 2 : 3;
        } else if ((this.kp & 0x10) != 0) {
            this.setState(4);
        }
        if ((this.kp & 0x40) != 0) {
            if ((this.kh & 2) != 0) {
                this.setState(13);
            } else {
                this.setState(8);
            }
        }
        this.gravity();
        this.friction();
        this.weapon.idle();
    }

    private void jump(boolean isRunning, boolean isBackdash) {
        this.xPos -= this.xVel / 2;
        this.frameX = 6;
        this.frameY = 0;
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        if (isRunning) {
            if ((this.kh & 4) != 0 && (this.kh & 1) == 0) {
                if (this.xVel < 1950) {
                    this.xVel += 100 + this.friction;
                }
            } else if ((this.kh & 1) != 0 && this.xVel > -1950) {
                this.xVel -= 100 + this.friction;
            }
        }
        ++this.scrTimer;
        if ((this.kh & 2) != 0) {
            this.direction |= 2;
        }
        if ((this.kh & 8) != 0) {
            this.direction |= 8;
        }
        if (this.scrTimer > 2) {
            if (isBackdash) {
                GameApp.soundPlayer.playSound(24);
                this.xVel = (this.direction & 1) != 0 ? 2300 : -2300;
                this.setState(20);
                this.scrTimer = 0;
            } else {
                GameApp.soundPlayer.playSound(10);
                isRunning = Math.abs(this.xVel) > 1164;
                if (!isRunning) {
                    if (this.xVel > 1064) {
                        this.xVel = 1064;
                    }
                    if (this.xVel < -1064) {
                        this.xVel = -1064;
                    }
                    this.yVel = -3000;
                } else {
                    if (this.xVel > 1950) {
                        this.xVel = 1950;
                    }
                    if (this.xVel < -1950) {
                        this.xVel = -1950;
                    }
                    this.yVel = -2500;
                }
                this.setState(2);
                this.scrTimer = 0;
            }
        }
    }

    private void air(boolean goingUp) {
        int[] frameWait = new int[]{6, 6, 6};
        ++this.frameTimer;
        if (this.frameIndex > 2) {
            this.frameIndex = 1;
        }
        this.frameY = this.frameIndex;
        if (!goingUp) {
            this.frameY += 2;
        }
        this.frameX = 6;
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        if (this.frameTimer > frameWait[this.frameIndex]) {
            this.frameTimer = 0;
            ++this.frameIndex;
        }
        if ((this.kh & 4) != 0 && (this.kh & 1) == 0) {
            if (this.xVel < 1064) {
                this.xVel += 60;
            }
            if ((this.direction & 1) != 0) {
                this.frameTimer = 0;
            }
            this.direction |= 4;
            this.direction &= 0xFFFFFFFE;
        } else if ((this.kh & 1) != 0) {
            if (this.xVel > -1064) {
                this.xVel -= 60;
            }
            if ((this.direction & 4) != 0) {
                this.frameTimer = 0;
            }
            this.direction |= 1;
            this.direction &= 0xFFFFFFFB;
        }
        this.state = this.yVel < 0 ? 2 : 3;
        if ((this.collision & 8) != 0) {
            this.state = this.xVel >= -1264 && this.xVel <= 1264 ? 1 : 5;
            if (this.yOldVel >= 800) {
                this.playStepSound();
            }
            this.frameTimer = 0;
        }
        if ((this.kh & 2) != 0) {
            this.direction |= 2;
        }
        if ((this.kh & 8) != 0) {
            this.direction |= 8;
        }
        if ((this.kp & 0x40) != 0) {
            if ((this.kh & 2) != 0) {
                this.setState(13);
            } else if ((this.kh & 8) != 0) {
                this.setState(14);
            } else {
                this.setState(8);
            }
        }
        this.gravity();
        this.weapon.idle();
    }

    private void walking() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] frameArray = nArray;
        this.frameX = 2;
        ++this.frameTimer;
        if (this.frameTimer > 7) {
            this.frameTimer = 0;
            ++this.frameIndex;
        }
        if (this.frameIndex > 3) {
            this.frameIndex = 0;
        }
        if (this.frameIndex % 2 == 0 && this.frameTimer == 0) {
            this.playStepSound();
        }
        this.frameY = frameArray[this.frameIndex];
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        if ((this.kh & 0x100) != 0 && this.interactablePresent) {
            GameApp.scriptRunner.runEvent(this.interactableEntity.eventNumb);
            this.setState(18);
        }
        if ((this.kh & 0x800) != 0) {
            this.setState(5);
        }
        if ((this.kh & 4) != 0 && (this.kh & 1) == 0) {
            this.xVel = this.xVel < 1064 ? (this.xVel += 100 + this.friction) : 1064;
            if ((this.direction & 1) != 0) {
                this.setState(6);
                this.frameTimer = 0;
            }
            this.direction |= 4;
            this.direction &= 0xFFFFFFFE;
        } else if ((this.kh & 1) != 0 && (this.kh & 4) == 0) {
            this.xVel = this.xVel > -1064 ? (this.xVel -= 100 + this.friction) : -1064;
            if ((this.direction & 4) != 0) {
                this.setState(6);
                this.frameTimer = 0;
            }
            this.direction |= 1;
            this.direction &= 0xFFFFFFFB;
        } else {
            this.state = 0;
        }
        if ((this.kh & 2) != 0) {
            this.direction |= 2;
        } else if ((this.kh & 8) != 0) {
            this.direction |= 8;
        }
        if (this.airGraceTimer > 1) {
            this.state = this.yVel < 0 ? 2 : 3;
        } else if ((this.kp & 0x10) != 0) {
            this.state = 4;
        }
        this.gravity();
        if ((this.kp & 0x40) != 0) {
            if ((this.kh & 2) != 0) {
                this.setState(13);
            } else {
                this.setState(8);
            }
        }
        this.friction();
        this.weapon.idle();
    }

    private void animatedWalking() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] frameArray = nArray;
        this.frameX = 2;
        ++this.frameTimer;
        if (this.frameTimer > 7) {
            this.frameTimer = 0;
            ++this.frameIndex;
        }
        if (this.frameIndex > 3) {
            this.frameIndex = 0;
        }
        if (this.frameIndex % 2 == 0 && this.frameTimer == 0) {
            this.playStepSound();
        }
        this.frameY = frameArray[this.frameIndex];
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        if ((this.direction & 4) != 0) {
            if (this.xVel < 1064) {
                this.xVel += 100 + this.friction;
            }
            if ((this.direction & 1) != 0) {
                this.setState(6);
                this.frameTimer = 0;
            }
        } else {
            if (this.xVel > -1064) {
                this.xVel -= 100 + this.friction;
            }
            if ((this.direction & 4) != 0) {
                this.setState(6);
                this.frameTimer = 0;
            }
        }
        if ((this.collision & 8) == 0) {
            this.state = this.yVel < 0 ? 2 : 3;
        } else {
            this.gravity();
        }
        this.friction();
        this.weapon.idle();
    }

    private void running() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] frameArray = nArray;
        this.frameX = 4;
        ++this.frameTimer;
        if (this.frameTimer > 6) {
            this.frameTimer = 0;
            ++this.frameIndex;
        }
        if (this.frameIndex > 3) {
            this.frameIndex = 0;
        }
        if (this.frameIndex % 2 == 0 && this.frameTimer == 0) {
            this.playStepSound();
        }
        this.frameY = frameArray[this.frameIndex];
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        if ((this.kh & 0x800) == 0) {
            this.setState(1);
        }
        if ((this.kh & 4) != 0 && (this.kh & 1) == 0) {
            if (this.xVel < 1950) {
                this.xVel += 100 + this.friction;
            }
            if ((this.direction & 1) != 0) {
                this.setState(6);
                this.frameTimer = 0;
            }
            this.direction |= 4;
            this.direction &= 0xFFFFFFFE;
        } else if ((this.kh & 1) != 0) {
            if (this.xVel > -1950) {
                this.xVel -= 100 + this.friction;
            }
            if ((this.direction & 4) != 0) {
                this.setState(6);
                this.frameTimer = 0;
            }
            this.direction |= 1;
            this.direction &= 0xFFFFFFFB;
        } else {
            this.state = 0;
        }
        if ((this.kh & 2) != 0) {
            this.direction |= 2;
        } else if ((this.kh & 8) != 0) {
            this.direction |= 8;
        }
        if ((this.kh & 0x100) != 0 && this.interactablePresent) {
            GameApp.scriptRunner.runEvent(this.interactableEntity.eventNumb);
            this.setState(18);
        }
        if (this.airGraceTimer > 1) {
            if ((this.equipFlags & 4) != 0) {
                this.state = this.yVel < 0 ? 2 : 3;
                if ((this.kp & 0x10) != 0) {
                    this.state = 7;
                }
            } else {
                this.state = this.yVel < 0 ? 2 : 3;
            }
        } else if ((this.kp & 0x10) != 0) {
            this.state = 7;
        }
        this.gravity();
        if ((this.kp & 0x40) != 0) {
            if ((this.kh & 2) != 0) {
                this.setState(13);
            } else {
                this.setState(8);
            }
        }
        this.friction();
        this.weapon.idle();
    }

    private void animatedRunning() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] frameArray = nArray;
        this.frameX = 4;
        ++this.frameTimer;
        if (this.frameTimer > 6) {
            this.frameTimer = 0;
            ++this.frameIndex;
        }
        if (this.frameIndex > 3) {
            this.frameIndex = 0;
        }
        if (this.frameIndex % 2 == 0 && this.frameTimer == 0) {
            this.playStepSound();
        }
        this.frameY = frameArray[this.frameIndex];
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        if ((this.direction & 1) == 0) {
            if (this.xVel < 1950) {
                this.xVel += 100 + this.friction;
            }
            this.direction |= 4;
            this.direction &= 0xFFFFFFFE;
        } else {
            if (this.xVel > -1950) {
                this.xVel -= 100 + this.friction;
            }
            this.direction |= 1;
            this.direction &= 0xFFFFFFFB;
        }
        this.gravity();
        this.friction();
        this.weapon.idle();
    }

    private void turn() {
        if ((this.kh & 4) != 0 && (this.kh & 1) == 0) {
            if (this.xVel < 1064) {
                this.xVel += 100 + this.friction;
            }
            this.direction |= 4;
            this.direction &= 0xFFFFFFFE;
        } else if ((this.kh & 1) != 0) {
            if (this.xVel > -1064) {
                this.xVel -= 100 + this.friction;
            }
            this.direction |= 1;
            this.direction &= 0xFFFFFFFB;
        }
        if ((this.kh & 2) != 0) {
            this.direction |= 2;
        }
        if ((this.kh & 8) != 0) {
            this.direction |= 8;
        }
        if ((this.collision & 8) != 0 && (this.kp & 0x10) != 0) {
            this.state = 4;
        }
        this.frameX = 6;
        this.frameY = 5;
        ++this.frameTimer;
        if (this.frameTimer > 5) {
            this.state = (this.kh & 4) == 0 && (this.kh & 1) == 0 ? 0 : 1;
            if ((this.collision & 8) == 0) {
                this.state = this.yVel < 0 ? 2 : 3;
            }
        }
        this.friction();
        if ((this.collision & 8) != 0) {
            this.gravity();
        }
        if ((this.kp & 0x40) != 0) {
            this.setState(8);
        }
    }

    private void sit() {
        this.displayOffsetY = 16896;
        this.frameX = 12;
        this.frameY = 5;
        if ((this.direction & 1) == 0) {
            ++this.frameX;
        }
        this.gravity();
        this.friction();
    }

    private void swap() {
        ++this.frameTimer;
        if (this.frameTimer > 2) {
            GameApp.ripPc.xPos = this.xPos;
            GameApp.ripPc.yPos = this.yPos;
            GameApp.ripPc.xVel = this.xVel;
            GameApp.ripPc.yVel = this.yVel;
            GameApp.ripPc.direction = this.direction;
            GameApp.ripPc.invincibilityTimer = this.invincibilityTimer;
            GameApp.ripPc.setState(0);
            GameApp.pc = GameApp.ripPc;
            GameApp.gMan.setCameraTarget(GameApp.pc);
            if (GameApp.partnerPc != null) {
                GameApp.partnerPc.risaPartner();
            }
            if (this.exclamationMark != null) {
                this.exclamationMark.hide();
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.invincibilityTimer % 5 == 2 || this.state == 22) {
            return;
        }
        GameApp.gMan.camBlit(17, this.frameRect, this.rendX - this.displayOffsetX, this.rendY - this.displayOffsetY, g);
        if (GameApp.currentMap.isMirror()) {
            int numOfMirrors = GameApp.currentMap.getNumOfMirrors();
            int i = 0;
            while (i < numOfMirrors) {
                if (GameApp.currentMap.isReflected(this.rendX - this.displayOffsetX, this.rendY - this.displayOffsetY, this.frameRect, i)) {
                    int reflectY = GameApp.currentMap.getMirror((int)i).y;
                    int reflectDispY = this.frameRect.height * 512 - this.displayOffsetY;
                    GameApp.gMan.reflectCamBlit(17, this.frameRect, this.rendX - this.displayOffsetX, 2 * reflectY - this.rendY - reflectDispY, g, i);
                }
                ++i;
            }
        }
        if (this.state == 8 || this.state == 13 || this.state == 14 || this.state == 10) {
            this.weapon.draw(g);
        }
    }
}

