/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Vector;
import local.rip.effect.Effect005ExclamationMark;
import local.rip.engine.DamageBox;
import local.rip.engine.GameApp;
import local.rip.engine.Line;
import local.rip.engine.NumObj;
import local.rip.engine.Physical;
import local.rip.engine.Stage;
import local.rip.engine.Weapon;
import local.rip.entity.Entity;
import local.rip.entity.Entity031SwarmBlob;

public class Player
extends Physical {
    private static final int FRAME_ROWS = 5;
    public static final int IDLE = 0;
    public static final int WALKING = 1;
    static final int AIRUP = 2;
    static final int AIRDOWN = 3;
    static final int JUMP = 4;
    public static final int RUNNING = 5;
    static final int TURN = 6;
    static final int RUNJUMP = 7;
    public static final int USE = 8;
    public static final int USE2 = 9;
    static final int GUARD = 10;
    static final int CLIFFHANG = 12;
    public static final int USE_UP = 13;
    public static final int USE_DOWN = 14;
    static final int HURT = 15;
    static final int CORPSE = 16;
    static final int PUSHING = 17;
    public static final int INVESTIGATE = 18;
    static final int BACKJUMP = 19;
    static final int BACKDASH = 20;
    static final int SIT = 21;
    public static final int SWAP = 22;
    static final int ANIMATED_WALKING = 50;
    static final int ANIMATED_RUNNING = 51;
    static final int HAND_CHALK = 1;
    static final int GRIP_SHOES = 2;
    static final int LEVITATION_BOOTS = 4;
    static final int WATER_BOOTS = 8;
    static final int FLOAT_STONE = 16;
    static final int CRASH_STONE = 32;
    static final byte STONE_BLUE = 1;
    static final byte STONE_RED = 2;
    static final byte STONE_YELLOW = 3;
    static final byte STONE_PURPLE = 4;
    static final byte STONE_GREEN = 5;
    static final byte STONE_ORANGE = 6;
    static final byte DEAD = 1;
    private static final int LBOOTS_MAX_TIME = 40;
    private int lbootsTimer = 0;
    private boolean lbootsJump = true;
    public int state;
    private int playerFlags = 0;
    protected int kp;
    public int kh;
    protected int frameX;
    int frameY;
    protected int frameTimer;
    protected int frameIndex;
    protected int scrTimer;
    protected DamageBox dBox;
    private int gfxNum;
    protected Rectangle frameRect;
    private ArrayList<Weapon> weaponList;
    public Weapon weapon;
    byte equippedWeapon;
    public int equipFlags = 0;
    private byte stoneSlot1 = 0;
    private byte stoneSlot2 = 0;
    private Entity dagger;
    protected int invincibilityTimer;
    public boolean interactablePresent = false;
    public Entity interactableEntity;
    public Effect005ExclamationMark exclamationMark;
    public int itemBeingUsed = -1;
    protected int xOldVel;
    protected int yOldVel;

    private void switchWeapon() {
        int i = this.weaponList.indexOf(this.weapon);
        byte oldWeap = this.weapon.type;
        if (++i >= this.weaponList.size()) {
            i = 0;
        }
        this.weapon = this.weaponList.get(i);
        this.equippedWeapon = this.weapon.type;
        GameApp.guiMan.switchWeap(this.equippedWeapon, oldWeap);
    }

    Player() {
    }

    public void useItem(int itemNum) {
        if (this.interactablePresent && (this.interactableEntity.entityFlags & 0x1000) != 0) {
            this.itemBeingUsed = itemNum;
            GameApp.scriptRunner.runEvent(this.interactableEntity.eventNumb + 10);
            return;
        }
        GameApp.scriptRunner.runEvent(1920);
    }

    public void playStepSound() {
        switch (this.lineType) {
            case 2: {
                GameApp.soundPlayer.playSound(17);
                break;
            }
            case 3: {
                GameApp.soundPlayer.playSound(18);
                int x = this.xPos;
                int y = this.yPos + (this.hitRect.y + this.hitRect.height) * 512;
                int i = 0;
                while (i < 6) {
                    GameApp.effectMan.addEffect(4, x, y, GameApp.randomInt(-300, 300), GameApp.randomInt(-200, 200) - 600, 0);
                    ++i;
                }
                break;
            }
            case 5: {
                GameApp.soundPlayer.playSound(22);
                break;
            }
            default: {
                GameApp.soundPlayer.playSound(16);
            }
        }
    }

    public void hideExclamationMark() {
        if (this.exclamationMark != null) {
            this.exclamationMark.hide();
        }
    }

    @Override
    public void doDamage(int damage) {
        if (GameApp.scriptFlags.checkFlag(2005)) {
            damage = (damage + 1) / 2;
        }
        if (this.damageNumb == null || !this.damageNumb.active) {
            this.damageNumb = NumObj.addNumb(damage, this, 9216);
        } else {
            this.damageNumb.addNumber(damage);
        }
        this.state = 15;
        this.currentHP -= damage;
        if (this.currentHP <= 0) {
            this.playerFlags |= 1;
            GameApp.soundPlayer.playSound(8, 4);
            GameApp.scriptRunner.runEvent(20);
        } else {
            GameApp.soundPlayer.playSound(7, 4);
            this.invincibilityTimer = 100;
        }
    }

    public void draw(Graphics2D g) {
        if (this.invincibilityTimer % 5 == 2) {
            return;
        }
        GameApp.gMan.camBlit(0, this.frameRect, this.rendX - this.displayOffsetX, this.rendY - this.displayOffsetY, g);
    }

    @Override
    public void gravity() {
        this.yVel = (this.kh & 0x10) != 0 && this.yVel < 0 ? (this.yVel += this.gravity / 2) : (this.yVel += this.gravity);
    }

    public void move(int x, int y) {
        this.xVel = 0;
        this.yVel = 0;
        this.xPos = x;
        this.yPos = y;
    }

    public void update() {
        if (this.dBox != null) {
            this.dBox.moveRelative(this.xPos - this.xOld, this.yPos - this.yOld);
        }
        if ((GameApp.gameState & 1) != 0) {
            this.kp = GameApp.getKeyPress();
            this.kh = GameApp.getKeyHeld();
        } else {
            this.kp = 0;
            this.kh = 0;
        }
        if ((this.kp & 0x10000) != 0) {
            GameApp.scriptRunner.runEvent(32);
        }
        if ((this.kp & 0x20000) != 0) {
            GameApp.musicPlayer.play(0);
        }
        if ((this.kp & 0x40000) != 0) {
            GameApp.musicPlayer.play(1);
        }
        if ((this.kp & 0x80000) != 0) {
            GameApp.musicPlayer.play(2);
        }
        if ((this.kp & 0x100000) != 0) {
            GameApp.musicPlayer.play(3);
        }
        this.direction &= 0xFFFFFFFD;
        this.direction &= 0xFFFFFFF7;
        switch (this.state) {
            case 0: {
                this.idle();
                break;
            }
            case 1: {
                this.walking();
                break;
            }
            case 4: {
                this.jump();
                break;
            }
            case 2: {
                this.airUp();
                break;
            }
            case 3: {
                this.airDown();
                break;
            }
            case 5: {
                this.running();
                break;
            }
            case 6: {
                this.turn();
                break;
            }
            case 7: {
                this.runningJump();
                break;
            }
            case 8: {
                this.use();
                break;
            }
            case 9: {
                this.use2();
                break;
            }
            case 10: {
                this.guard();
                break;
            }
            case 12: {
                this.cliffhang();
                break;
            }
            case 13: {
                this.use();
                break;
            }
            case 14: {
                this.use();
                break;
            }
            case 15: {
                this.hurt();
                break;
            }
            case 16: {
                this.corpse();
                break;
            }
            case 17: {
                this.pushing();
            }
        }
        if (this.invincibilityTimer > 0) {
            --this.invincibilityTimer;
        }
        this.frameRect.x = this.getFrameX() * 32;
        this.frameRect.y = this.frameY * 40;
        if (this.xVel > 4000) {
            this.xVel = 4000;
        }
        if (this.xVel < -4000) {
            this.xVel = -4000;
        }
        if (this.yVel > 4000) {
            this.yVel = 4000;
        }
        if (this.yVel < -4000) {
            this.yVel = -4000;
        }
        this.xOld = this.xPos;
        this.yOld = this.yPos;
        this.movement();
        this.tileCollision(2);
    }

    private void pushing() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] frameArray = nArray;
        this.frameX = 9;
        ++this.frameTimer;
        if (this.frameTimer > 8) {
            this.frameTimer = 0;
            ++this.frameIndex;
        }
        if (this.frameIndex > 3) {
            this.frameIndex = 0;
        }
        this.frameY = frameArray[this.frameIndex];
        if ((this.direction & 1) != 0) {
            this.xVel = -400;
            if ((this.kh & 1) == 0) {
                this.setState(0);
                this.xVel = 0;
            }
        } else {
            this.frameY += 5;
            this.xVel = 400;
            if ((this.kh & 4) == 0) {
                this.setState(0);
                this.xVel = 0;
            }
        }
        if (this.frameIndex % 2 == 1 && this.frameTimer == 0 && (this.equipFlags & 2) != 0) {
            GameApp.effectMan.addEffect(1, this.xPos, this.yPos + 8192, 0, 0, 1);
        }
        if ((this.collision & 8) == 0) {
            this.state = 2;
        } else if ((this.kp & 0x10) != 0) {
            this.state = 4;
            this.lbootsJump = false;
            this.xVel = 0;
        }
        this.gravity();
    }

    private void corpse() {
        this.frameX = 8;
        this.frameY = 4;
        this.weapon.renderOff = true;
        if ((this.direction & 1) == 0) {
            this.frameY += 5;
        }
        this.gravity();
        this.friction();
    }

    private void hurt() {
        this.frameX = 4;
        this.frameY = 4;
        if ((this.direction & 1) == 0) {
            this.frameY += 5;
        }
        if (this.invincibilityTimer <= 0 && (this.playerFlags & 1) == 0) {
            this.setState(3);
        }
        if ((this.collision & 8) != 0) {
            if ((this.playerFlags & 1) != 0) {
                this.setState(16);
            } else {
                this.setState(0);
            }
        }
        this.gravity();
    }

    private void cliffhang() {
        this.frameX = 3;
        this.frameY = 4;
        ++this.frameTimer;
        if (this.frameTimer > 18) {
            this.frameTimer = 0;
            GameApp.effectMan.addEffect(1, this.xPos, this.yPos - 2048, 0, 0, 0);
        }
        if ((this.direction & 1) == 0) {
            this.frameY += 5;
            this.hitRect.width = 10;
            this.hitRect.x = -6;
        } else {
            this.hitRect.width = 10;
            this.hitRect.x = -4;
        }
        if ((this.kp & 0x10) != 0) {
            this.hitRect.x = -6;
            this.hitRect.width = 12;
            if ((this.kh & 8) != 0) {
                this.yPos += 1024;
                this.xPos = (this.direction & 1) == 0 ? (this.xPos -= 2048) : (this.xPos += 2048);
                this.state = 3;
                return;
            }
            this.yVel = -3200;
            this.state = 2;
        }
    }

    private void guard() {
    }

    private void turn() {
    }

    public void setState(int newState) {
        if (this.state == 16) {
            return;
        }
        this.state = newState;
        this.frameTimer = 0;
        this.frameIndex = 0;
    }

    private void use() {
    }

    private void use2() {
    }

    private void useBroadSword() {
    }

    private void idle() {
    }

    private void walking() {
    }

    private void running() {
    }

    private void jump() {
    }

    private void runningJump() {
    }

    private void airUp() {
    }

    private void airDown() {
    }

    @Override
    public void tileCollision(int size) {
        Line line;
        this.collision = 0;
        Stage map = GameApp.currentMap;
        int testX = this.xPos / 10240;
        int testY = this.yPos / 10240;
        Vector<Line> collLines = new Vector<Line>(0);
        int maxTestRange = size + 1;
        int i = 1 - size;
        while (i < maxTestRange) {
            int j = 1 - size;
            while (j < maxTestRange) {
                Vector<Line> testLines = map.lines.get((testY + i) * map.getMapX() + testX + j);
                if (testLines != null) {
                    int k = 0;
                    while (k < testLines.size()) {
                        line = testLines.get(k);
                        if (!collLines.contains(line)) {
                            if (line.getSlope() == 0) {
                                collLines.add(0, line);
                            } else {
                                collLines.add(line);
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < collLines.size()) {
            line = (Line)collLines.get(i);
            switch (line.getType()) {
                case 6: {
                    break;
                }
                default: {
                    line.collision(this);
                }
            }
            ++i;
        }
    }

    @Override
    public void damageCollision(DamageBox d) {
        if (this.invincibilityTimer > 0 || (this.playerFlags & 1) != 0 || GameApp.isScriptRunning()) {
            return;
        }
        if (this.hitRect.height <= 0 || this.hitRect.width <= 0) {
            return;
        }
        if (d.xPos + (d.hitRect.x + d.hitRect.width) * 512 + 256 < this.xPos + this.hitRect.x * 512) {
            return;
        }
        if (d.xPos + d.hitRect.x * 512 - 256 > this.xPos + (this.hitRect.x + this.hitRect.width) * 512) {
            return;
        }
        if (d.yPos + (d.hitRect.y + d.hitRect.height) * 512 < this.yPos + this.hitRect.y * 512) {
            return;
        }
        if (d.yPos + d.hitRect.y * 512 > this.yPos + (this.hitRect.y + this.hitRect.height) * 512) {
            return;
        }
        if (this.state == 10 && this.weapon.type != 0) {
            GameApp.soundPlayer.playSound(4);
            if (this.xPos < d.xPos) {
                if ((this.direction & 4) != 0) {
                    if (d.owner != null) {
                        this.xVel += d.owner.xVel - 500;
                        if (d.owner.xVel < 0) {
                            d.owner.xVel /= 2;
                        }
                        d.owner.xVel += 1500;
                    } else {
                        this.xVel -= 500;
                    }
                    if (this.xVel < -1600) {
                        this.xVel = -1600;
                    } else if (this.xVel > 0) {
                        this.xVel = 0;
                    }
                    return;
                }
            } else if ((this.direction & 1) != 0) {
                if (d.owner != null) {
                    if (d.owner.xVel > 0) {
                        d.owner.xVel /= 2;
                    }
                    this.xVel += d.owner.xVel + 500;
                    d.owner.xVel -= 1500;
                } else {
                    this.xVel += 500;
                }
                if (this.xVel > 1600) {
                    this.xVel = 1600;
                } else if (this.xVel < 0) {
                    this.xVel = 0;
                }
                return;
            }
        }
        this.collision = 0;
        --d.hitsLeft;
        this.doDamage(d.damage);
        int testDirection = d.direction;
        if (testDirection == 0) {
            testDirection = this.xPos > d.xPos ? 4 : 1;
        }
        if ((testDirection & 4) != 0) {
            this.direction |= 1;
            this.direction &= 0xFFFFFFFB;
            this.xVel = 400 * d.weight;
            this.yVel = -1000 * d.weight;
        } else if ((testDirection & 1) != 0) {
            this.direction |= 4;
            this.direction &= 0xFFFFFFFE;
            this.xVel = -400 * d.weight;
            this.yVel = -1000 * d.weight;
        } else {
            this.yVel = (testDirection & 2) != 0 ? -500 * d.weight : (this.yVel += 100 * d.weight);
        }
        if (d.owner != null && d.owner instanceof Entity031SwarmBlob) {
            GameApp.scriptFlags.setFlag(39);
        }
    }

    public ArrayList<Weapon> getWeaponList() {
        return this.weaponList;
    }

    public void changeWeapon(int newWeap) {
        this.weapon = new Weapon((byte)newWeap, this);
    }

    public int getFrameX() {
        return this.frameX;
    }

    public int getFrameY() {
        return this.frameY;
    }
}

