/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Rectangle;
import java.util.Vector;
import local.rip.engine.DamageBox;
import local.rip.engine.GameApp;
import local.rip.engine.Line;
import local.rip.engine.NumObj;
import local.rip.engine.Stage;

public class Physical {
    protected int rendX;
    protected int rendY;
    public int xPos;
    public int yPos;
    protected int xOld;
    protected int yOld;
    protected int displayOffsetX;
    protected int displayOffsetY;
    public int xVel;
    public int yVel;
    protected int yMaxVel = 4000;
    protected static final int LEFT_COLL = 1;
    protected static final int UP_COLL = 2;
    protected static final int RIGHT_COLL = 4;
    protected static final int DOWN_COLL = 8;
    public static final int LEFT_DIR = 1;
    public static final int UP_DIR = 2;
    public static final int RIGHT_DIR = 4;
    public static final int DOWN_DIR = 8;
    public int collision = 0;
    public int direction;
    public Rectangle hitRect;
    protected int friction = 50;
    protected int gravity = 170;
    protected NumObj damageNumb;
    protected int maxHP;
    protected int currentHP;
    protected int hurtSound = 5;
    public byte lineType = 1;
    public int weight = 3;

    public void updateRendCoords() {
        this.rendX = this.xPos;
        this.rendY = this.yPos;
    }

    public int getMaxHP() {
        return this.maxHP;
    }

    public void setMaxHP(int maxHP) {
        this.maxHP = maxHP;
    }

    public int getCurrentHP() {
        return this.currentHP;
    }

    public void setCurrentHP(int currentHP) {
        this.currentHP = currentHP;
    }

    public void heal(int healthUp) {
        this.currentHP += healthUp;
        if (this.currentHP > this.maxHP) {
            this.currentHP = this.maxHP;
        }
    }

    public void doDamage(int damage) {
        if (this.damageNumb == null || !this.damageNumb.active) {
            this.damageNumb = NumObj.addNumb(damage, this, 16384);
        } else {
            this.damageNumb.addNumber(damage);
        }
        GameApp.soundPlayer.playSound(this.hurtSound, 4);
        this.currentHP -= damage;
    }

    public void friction() {
        this.xVel = this.xVel > this.friction ? (this.xVel -= this.friction) : (this.xVel < -this.friction ? (this.xVel += this.friction) : 0);
    }

    public void gravity() {
        this.yVel += this.gravity;
        if (this.yVel > this.yMaxVel) {
            this.yVel = this.yMaxVel;
        }
    }

    public void movement() {
        this.xOld = this.xPos;
        this.yOld = this.yPos;
        this.xPos += this.xVel;
        this.yPos += this.yVel;
    }

    public void tileCollision(int size) {
        this.collision = 0;
        Stage map = GameApp.currentMap;
        int testX = this.xPos / 10240;
        int testY = this.yPos / 10240;
        Vector<Line> collLines = new Vector<Line>(0);
        int maxTestRange = size + 1;
        int i = 1 - size;
        while (i < maxTestRange) {
            int j = 0;
            while (j < 2) {
                Vector<Line> testLines = map.lines.get((testY + i) * map.getMapX() + testX + j);
                if (testLines != null) {
                    int k = 0;
                    while (k < testLines.size()) {
                        Line line = testLines.get(k);
                        if (!collLines.contains(line)) {
                            if (line.getSlope() == 0) {
                                collLines.add(0, line);
                            } else {
                                collLines.add(line);
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < collLines.size()) {
            ((Line)collLines.get(i)).collision(this);
            ++i;
        }
    }

    public void damageCollision(DamageBox d) {
        if (this.hitRect.height <= 0 || this.hitRect.width <= 0) {
            return;
        }
        if (d.xPos + (d.hitRect.x + d.hitRect.width) * 512 < this.xPos + this.hitRect.x * 512) {
            return;
        }
        if (d.xPos + d.hitRect.x * 512 > this.xPos + (this.hitRect.x + this.hitRect.width) * 512) {
            return;
        }
        if (d.yPos + (d.hitRect.y + d.hitRect.height) * 512 < this.yPos + this.hitRect.y * 512) {
            return;
        }
        if (d.yPos + d.hitRect.y * 512 > this.yPos + (this.hitRect.y + this.hitRect.height) * 512) {
            return;
        }
        if (!d.isHitThisFrame()) {
            --d.hitsLeft;
            d.setHitThisFrame(true);
        }
        this.doDamage(d.damage);
        int testDirection = d.direction;
        if ((testDirection & 4) != 0) {
            if (this.xVel < 0) {
                this.xVel = 0;
            }
            if (this.yVel > 0) {
                this.yVel = 0;
            }
            this.xVel += (10 - this.weight) * 25 * d.weight;
            this.yVel -= (10 - this.weight) * 50 * d.weight;
        } else if ((testDirection & 1) != 0) {
            if (this.xVel > 0) {
                this.xVel = 0;
            }
            if (this.yVel > 0) {
                this.yVel = 0;
            }
            this.xVel -= (10 - this.weight) * 25 * d.weight;
            this.yVel -= (10 - this.weight) * 50 * d.weight;
        } else {
            if (this.yVel > 0) {
                this.yVel = 0;
            }
            this.yVel -= (10 - this.weight) * 50 * d.weight;
        }
    }
}

