/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class OggPlayer {
    static boolean threadPlaying = false;
    private OggClip ogg;
    public int visibleVolume = 100;
    private float volume = 0.9f;
    private int currentSong = -1;
    static final String musicFolder = "data/music/";
    static final String[] musiclist;

    static {
        String[] stringArray = new String[18];
        stringArray[0] = "0.ogg";
        stringArray[2] = "pureheart.ogg";
        stringArray[4] = "lakesidelull2.ogg";
        stringArray[6] = "ironworksloop.ogg";
        stringArray[7] = "ironworksintro.ogg";
        stringArray[8] = "insideloop.ogg";
        stringArray[9] = "insideintro.ogg";
        stringArray[10] = "icerainrevfinal.ogg";
        stringArray[12] = "wind.ogg";
        stringArray[14] = "esplanadeloop.ogg";
        stringArray[15] = "esplanadeintro.ogg";
        stringArray[16] = "unluckyrabbitloop.ogg";
        stringArray[17] = "unluckyrabbitintro.ogg";
        musiclist = stringArray;
    }

    public OggPlayer(int songNumb) {
        try {
            this.ogg = new OggClip(musicFolder + musiclist[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void play(int songNumb) {
        if (songNumb == this.currentSong) {
            return;
        }
        this.currentSong = songNumb;
        this.ogg.stop();
        this.ogg.close();
        if (this.currentSong == -1) {
            return;
        }
        this.loadSongs(songNumb);
        this.ogg.loop();
        this.ogg.setGain(this.volume);
    }

    public void pauseResume() {
        if (this.ogg.isPaused()) {
            this.ogg.resume();
        } else {
            this.ogg.pause();
        }
    }

    public void stop() {
        this.ogg.stop();
    }

    public boolean isPaused() {
        return this.ogg.isPaused();
    }

    public void setVolume() {
        int x = 100 - this.visibleVolume;
        this.volume = (float)((double)(1000000 - x * x * x) / 1111111.1111);
        this.ogg.setGain(this.volume);
    }

    private void loadSongs(int songNumb) {
        String[] songs = this.getSongs(songNumb);
        if (songs[1] == null) {
            try {
                this.ogg.changeSongs(musicFolder + songs[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.ogg.changeSongs(musicFolder + songs[0], musicFolder + songs[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String[] getSongs(int songNumb) {
        return new String[]{musiclist[2 * songNumb], musiclist[2 * songNumb + 1]};
    }

    public int getCurrentSongNum() {
        return this.currentSong;
    }

    private class OggClip {
        private final int BUFSIZE = 8192;
        private int convsize = 16384;
        private byte[] convbuffer = new byte[this.convsize];
        private SyncState oy;
        private StreamState os;
        private Page og;
        private Packet op;
        private Info vi;
        private Comment vc;
        private DspState vd;
        private Block vb;
        private SourceDataLine outputLine;
        private int rate;
        private int channels;
        private BufferedInputStream bitStream = null;
        private BufferedInputStream bitStreamIntro = null;
        private byte[] buffer = null;
        private int bytes = 0;
        private Thread player = null;
        private float balance;
        private float gain = -1.0f;
        private boolean paused;
        private float oldGain;

        public OggClip(String ref, String ref2) throws IOException {
            File f = new File(ref);
            FileInputStream in = new FileInputStream(f);
            File f2 = new File(ref2);
            FileInputStream in2 = new FileInputStream(f2);
            try {
                this.init(in, in2);
            }
            catch (IOException e) {
                throw new IOException("Couldn't find: " + ref);
            }
        }

        public OggClip(String ref) throws IOException {
            File f = new File(ref);
            FileInputStream in = new FileInputStream(f);
            try {
                this.init(in, null);
            }
            catch (IOException e) {
                throw new IOException("Couldn't find: " + ref);
            }
        }

        public OggClip(InputStream in) throws IOException {
            this.init(in, null);
        }

        public void changeSongs(String ref, String ref2) throws IOException {
            File f = new File(ref);
            FileInputStream in = new FileInputStream(f);
            File f2 = new File(ref2);
            FileInputStream in2 = new FileInputStream(f2);
            try {
                this.init(in, in2);
            }
            catch (IOException e) {
                throw new IOException("Couldn't find: " + ref);
            }
        }

        public void changeSongs(String ref) throws IOException {
            File f = new File(ref);
            FileInputStream in = new FileInputStream(f);
            try {
                this.init(in, null);
            }
            catch (IOException e) {
                throw new IOException("Couldn't find: " + ref);
            }
        }

        public void setDefaultGain() {
            this.setGain(-1.0f);
        }

        public void setGain(float gain) {
            if (gain != -1.0f && (gain < 0.0f || gain > 1.0f)) {
                throw new IllegalArgumentException("Volume must be between 0.0 and 1.0");
            }
            this.gain = gain;
            if (this.outputLine == null) {
                return;
            }
            try {
                FloatControl control = (FloatControl)this.outputLine.getControl(FloatControl.Type.MASTER_GAIN);
                if (gain == -1.0f) {
                    control.setValue(0.0f);
                } else {
                    float max = control.getMaximum();
                    float min = control.getMinimum();
                    float range = max - min;
                    control.setValue(min + range * gain);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }

        public void setBalance(float balance) {
            this.balance = balance;
            if (this.outputLine == null) {
                return;
            }
            try {
                FloatControl control = (FloatControl)this.outputLine.getControl(FloatControl.Type.BALANCE);
                control.setValue(balance);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkState() {
            while (this.paused && this.player != null) {
                Thread thread = this.player;
                synchronized (thread) {
                    if (this.player != null) {
                        try {
                            this.player.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.stopped();
        }

        public void pause() {
            this.paused = true;
            this.oldGain = this.gain;
            this.setGain(0.0f);
        }

        public boolean isPaused() {
            return this.paused;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            if (!this.paused) {
                this.play();
                return;
            }
            this.paused = false;
            Thread thread = this.player;
            synchronized (thread) {
                if (this.player != null) {
                    this.player.notify();
                }
            }
            this.setGain(this.oldGain);
        }

        public boolean stopped() {
            return this.player == null || !this.player.isAlive();
        }

        private void init(InputStream in, InputStream inIntro) throws IOException {
            if (in == null) {
                throw new IOException("Couldn't find input source");
            }
            this.bitStream = new BufferedInputStream(in);
            this.bitStream.mark(Integer.MAX_VALUE);
            if (inIntro != null) {
                this.bitStreamIntro = new BufferedInputStream(inIntro);
                this.bitStreamIntro.mark(Integer.MAX_VALUE);
            } else {
                this.bitStreamIntro = null;
            }
        }

        public void play() {
            this.stop();
            try {
                this.bitStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.player = new Thread(){

                @Override
                public void run() {
                    try {
                        while (threadPlaying) {
                            Thread.sleep(30L);
                        }
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    threadPlaying = true;
                    try {
                        OggClip.this.playStream(Thread.currentThread(), OggClip.this.bitStream);
                    }
                    catch (InternalException e) {
                        e.printStackTrace();
                    }
                    try {
                        OggClip.this.bitStream.reset();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    threadPlaying = false;
                }
            };
            this.player.setDaemon(true);
            this.player.start();
        }

        public void loop() {
            this.stop();
            try {
                if (this.bitStreamIntro != null) {
                    this.bitStreamIntro.reset();
                }
                this.bitStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.player = new Thread(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            this.player.setDaemon(true);
            this.player.start();
        }

        public void stop() {
            if (this.stopped()) {
                return;
            }
            this.setGain(0.0f);
            this.player = null;
        }

        public void close() {
            try {
                if (this.bitStream != null) {
                    this.bitStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void initJavaSound(int channels, int rate) {
            try {
                AudioFormat audioFormat = new AudioFormat(rate, 16, channels, true, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
                if (!AudioSystem.isLineSupported(info)) {
                    throw new Exception("Line " + info + " not supported.");
                }
                try {
                    this.outputLine = (SourceDataLine)AudioSystem.getLine(info);
                    this.outputLine.open(audioFormat);
                }
                catch (LineUnavailableException ex) {
                    throw new Exception("Unable to open the sourceDataLine: " + ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("Illegal Argument: " + ex);
                }
                this.rate = rate;
                this.channels = channels;
                this.setBalance(this.balance);
                this.setGain(this.gain);
            }
            catch (Exception ee) {
                System.out.println(ee);
            }
        }

        private SourceDataLine getOutputLine(int channels, int rate) {
            if (this.outputLine == null || this.rate != rate || this.channels != channels) {
                if (this.outputLine != null) {
                    this.outputLine.drain();
                    this.outputLine.stop();
                    this.outputLine.close();
                }
                this.initJavaSound(channels, rate);
                this.outputLine.start();
            }
            return this.outputLine;
        }

        private void initJOrbis() {
            this.oy = new SyncState();
            this.os = new StreamState();
            this.og = new Page();
            this.op = new Packet();
            this.vi = new Info();
            this.vc = new Comment();
            this.vd = new DspState();
            this.vb = new Block(this.vd);
            this.buffer = null;
            this.bytes = 0;
            this.oy.init();
        }

        /*
         * Unable to fully structure code
         */
        private boolean playStream(Thread me, BufferedInputStream bitStream) throws InternalException {
            chained = false;
            this.initJOrbis();
            while (true) {
                block33: {
                    if (this.checkState()) {
                        return true;
                    }
                    eos = false;
                    index = this.oy.buffer(8192);
                    this.buffer = this.oy.data;
                    try {
                        this.bytes = bitStream.read(this.buffer, index, 8192);
                    }
                    catch (Exception e) {
                        throw new InternalException(e);
                    }
                    this.oy.wrote(this.bytes);
                    if (chained) {
                        chained = false;
                    } else {
                        x = this.oy.pageout(this.og);
                        if (x != 1) {
                            if (this.bytes < 8192) break;
                            this.os.clear();
                            this.vb.clear();
                            this.vd.clear();
                            this.vi.clear();
                            this.oy.clear();
                            System.out.println("Input does not appear to be an Ogg bitstream.  Reloading bitstream...");
                            return false;
                        }
                    }
                    this.os.init(this.og.serialno());
                    this.os.reset();
                    this.vi.init();
                    this.vc.init();
                    if (this.os.pagein(this.og) < 0) {
                        throw new InternalException("Error reading first page of Ogg bitstream data.");
                    }
                    if (this.os.packetout(this.op) != 1) {
                        throw new InternalException("Error reading initial header packet.");
                    }
                    if (this.vi.synthesis_headerin(this.vc, this.op) < 0) {
                        throw new InternalException("This Ogg bitstream does not contain Vorbis audio data.");
                    }
                    i = 0;
                    break block33;
                    while (!this.checkState() && (result = this.oy.pageout(this.og)) != 0) {
                        if (result == 1) {
                            this.os.pagein(this.og);
                            while (i < 2) {
                                result = this.os.packetout(this.op);
                                if (result == 0) break;
                                if (result == -1) {
                                    throw new InternalException("Corrupt secondary header.  Exiting.");
                                }
                                this.vi.synthesis_headerin(this.vc, this.op);
                                ++i;
                            }
                        }
lbl57:
                        // 5 sources

                        ** while (i >= 2)
lbl58:
                        // 1 sources

                    }
lbl59:
                    // 2 sources

                    index = this.oy.buffer(8192);
                    this.buffer = this.oy.data;
                    try {
                        this.bytes = bitStream.read(this.buffer, index, 8192);
                    }
                    catch (Exception e) {
                        throw new InternalException(e);
                    }
                    if (this.bytes == 0 && i < 2) {
                        throw new InternalException("End of file before finding all Vorbis headers!");
                    }
                    this.oy.wrote(this.bytes);
                }
                if (i < 2) ** GOTO lbl57
                this.convsize = 8192 / this.vi.channels;
                this.vd.synthesis_init(this.vi);
                this.vb.init(this.vd);
                _pcmf = new float[1][][];
                _index = new int[this.vi.channels];
                this.getOutputLine(this.vi.channels, this.vi.rate);
                ** GOTO lbl152
                {
                    block34: {
                        block35: {
                            if (this.player != me) {
                                return true;
                            }
                            result = this.oy.pageout(this.og);
                            if (result == 0) ** GOTO lbl139
                            if (result == -1) break block34;
                            this.os.pagein(this.og);
                            if (this.og.granulepos() != 0L) break block35;
                            chained = true;
                            eos = true;
                            ** GOTO lbl139
                        }
                        block11: while (true) {
                            if (this.checkState()) {
                                return true;
                            }
                            result = this.os.packetout(this.op);
                            if (result == 0) break;
                            if (result == -1) continue;
                            if (this.vb.synthesis(this.op) == 0) {
                                this.vd.synthesis_blockin(this.vb);
                            }
                            while (true) {
                                if ((samples = this.vd.synthesis_pcmout(_pcmf, _index)) <= 0) continue block11;
                                if (!this.checkState()) ** break;
                                continue block11;
                                pcmf = _pcmf[0];
                                bout = samples < this.convsize ? samples : this.convsize;
                                i = 0;
                                while (i < this.vi.channels) {
                                    ptr = i * 2;
                                    mono = _index[i];
                                    j = 0;
                                    while (j < bout) {
                                        val = (int)((double)pcmf[i][mono + j] * 32767.0);
                                        if (val > 32767) {
                                            val = 32767;
                                        }
                                        if (val < -32768) {
                                            val = -32768;
                                        }
                                        if (val < 0) {
                                            val |= 32768;
                                        }
                                        this.convbuffer[ptr] = (byte)val;
                                        this.convbuffer[ptr + 1] = (byte)(val >>> 8);
                                        ptr += 2 * this.vi.channels;
                                        if (this.checkState()) break;
                                        ++j;
                                    }
                                    ++i;
                                }
                                this.outputLine.write(this.convbuffer, 0, 2 * this.vi.channels * bout);
                                this.vd.synthesis_read(bout);
                            }
                            break;
                        }
                        if (this.og.eos() != 0) {
                            eos = true;
                        }
                    }
                    do {
                        if (!eos) continue block10;
lbl139:
                        // 3 sources

                        if (eos) continue;
                        index = this.oy.buffer(8192);
                        this.buffer = this.oy.data;
                        try {
                            this.bytes = bitStream.read(this.buffer, index, 8192);
                        }
                        catch (Exception e) {
                            throw new InternalException(e);
                        }
                        if (this.bytes == -1) break block10;
                        this.oy.wrote(this.bytes);
                        if (this.bytes != 0) continue;
                        eos = true;
lbl152:
                        // 4 sources

                    } while (!eos);
                }
                this.os.clear();
                this.vb.clear();
                this.vd.clear();
                this.vi.clear();
            }
            this.oy.clear();
            return true;
        }

        static /* synthetic */ BufferedInputStream access$2(OggClip oggClip) {
            return oggClip.bitStreamIntro;
        }

        static /* synthetic */ void access$3(OggClip oggClip, Thread thread) {
            oggClip.player = thread;
        }

        static /* synthetic */ Thread access$4(OggClip oggClip) {
            return oggClip.player;
        }

        private class InternalException
        extends Exception {
            private static final long serialVersionUID = -4629645608084271297L;

            public InternalException(Exception e) {
                super(e);
            }

            public InternalException(String msg) {
                super(msg);
            }
        }
    }
}

