/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import local.rip.engine.GameApp;
import local.rip.engine.Physical;

public class NumObj {
    static final int NUMBOF_NUMBOBJS = 10;
    int xPos;
    int yPos;
    int yOffset;
    int value;
    int timer;
    Physical owner;
    int rectBottomSub;
    int rectTopSub;
    int flash;
    int flashTimer;
    public boolean active;
    static ArrayList<NumObj> numObjArray;

    public NumObj(int val, Physical own, int yOff) {
        this.value = val;
        this.owner = own;
        this.xPos = this.owner.xPos;
        this.yPos = this.owner.yPos;
        this.yOffset = yOff;
        this.rectBottomSub = 16;
        this.rectTopSub = 0;
        this.timer = 0;
        this.active = true;
    }

    public void setNumObj(int val, Physical own, int yOff) {
        this.value = val;
        this.owner = own;
        this.xPos = this.owner.xPos;
        this.yPos = this.owner.yPos;
        this.yOffset = yOff;
        this.rectBottomSub = 16;
        this.rectTopSub = 0;
        this.timer = 0;
        this.active = true;
    }

    public static void initialize() {
        numObjArray = new ArrayList(10);
    }

    public static NumObj addNumb(int val, Physical own, int yOff) {
        NumObj N = new NumObj(val, own, yOff);
        numObjArray.add(N);
        return N;
    }

    public static void drawNumbObjs(Graphics2D g) {
        for (NumObj drawN : numObjArray) {
            if (!drawN.active) continue;
            drawN.draw(g);
        }
    }

    public static void updateNumbObjs() {
        ArrayList<NumObj> inactives = new ArrayList<NumObj>();
        for (NumObj drawN : numObjArray) {
            if (drawN.active) {
                drawN.update();
                continue;
            }
            inactives.add(drawN);
        }
        numObjArray.removeAll(inactives);
    }

    private void update() {
        ++this.timer;
        ++this.flashTimer;
        this.xPos = this.owner.xPos;
        if (this.flashTimer >= 8) {
            this.flashTimer = 0;
            this.flash ^= 1;
        }
        if (this.timer < 8) {
            this.rectTopSub = 0;
            this.rectBottomSub = 16 - this.timer * 2;
            this.yPos = this.owner.yPos - this.yOffset - 8192;
        } else if (this.timer < 50) {
            this.rectBottomSub = 0;
            this.rectTopSub = 0;
            this.yPos = this.owner.yPos - this.yOffset - 8192;
        } else if (this.timer < 82) {
            this.rectTopSub = this.timer - 50 >> 1;
            this.yPos = this.owner.yPos - this.yOffset - 8192;
        } else {
            this.active = false;
        }
    }

    public void addNumber(int val) {
        this.value += val;
        if (this.timer > 8) {
            this.timer = 8;
        }
    }

    private void draw(Graphics2D g) {
        int xOff = 0;
        int yRender = this.yPos + this.rectBottomSub * 512;
        Rectangle numRect = new Rectangle(120, 88 + this.rectTopSub + this.flash * 16, 12, 16 - this.rectBottomSub - this.rectTopSub);
        int digits = 1;
        int lNum = this.value;
        boolean drawnMinusSign = false;
        while (digits != 0) {
            int n;
            if (lNum >= 10000 || digits == 5) {
                n = lNum / 10000;
                lNum %= 10000;
                digits = 4;
            } else if (lNum >= 1000 || digits == 4) {
                n = lNum / 1000;
                lNum %= 1000;
                digits = 3;
            } else if (lNum >= 100 || digits == 3) {
                n = lNum / 100;
                lNum %= 100;
                digits = 2;
            } else if (lNum >= 10 || digits == 2) {
                n = lNum / 10;
                lNum %= 10;
                digits = 1;
            } else {
                n = lNum;
                lNum = 0;
                digits = 0;
            }
            if (!drawnMinusSign) {
                xOff = (digits + 2) * -6 * 512;
                GameApp.gMan.camBlit(11, numRect, this.xPos + xOff, yRender, g);
                drawnMinusSign = true;
                xOff += 6144;
            }
            numRect.x = n * 12;
            numRect.y = 88 + this.flash * 16 + this.rectTopSub;
            GameApp.gMan.camBlit(11, numRect, this.xPos + xOff, yRender, g);
            xOff += 6144;
        }
    }

    public static void drawNumb(int x, int y, int digits, int value, Graphics2D g) {
        int xOff = 0;
        int yRender = y;
        Rectangle numRect = new Rectangle(0, 88, 12, 16);
        int lNum = value;
        while (digits != 0) {
            int n;
            if (lNum >= 10000 || digits == 5) {
                n = lNum / 10000;
                lNum %= 10000;
                digits = 4;
            } else if (lNum >= 1000 || digits == 4) {
                n = lNum / 1000;
                lNum %= 1000;
                digits = 3;
            } else if (lNum >= 100 || digits == 3) {
                n = lNum / 100;
                lNum %= 100;
                digits = 2;
            } else if (lNum >= 10 || digits == 2) {
                n = lNum / 10;
                lNum %= 10;
                digits = 1;
            } else {
                n = lNum;
                lNum = 0;
                digits = 0;
            }
            numRect.x = n * 12;
            numRect.y = 72;
            GameApp.gMan.mainBlit(11, numRect, x + xOff, yRender, g);
            xOff += 12;
        }
    }
}

