/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import local.rip.engine.GameApp;

class MusicClipOld {
    static final String musicFolder = "data/music/";
    static boolean playing = false;
    static boolean paused = false;
    static boolean stop = false;
    Thread oggThread;
    private Clip clip1;
    private Clip clip2;
    FloatControl gainControl1;
    FloatControl gainControl2;
    File song;
    File intro;

    MusicClipOld() {
    }

    public void stop() {
        if (this.clip1 != null) {
            this.clip1.stop();
            this.clip1.close();
        }
        if (this.clip2 != null) {
            this.clip2.stop();
            this.clip2.close();
        }
        this.clip1 = null;
        this.clip2 = null;
        playing = false;
        stop = true;
    }

    public void setVolume(int visibleVolume) {
        float newValue = (float)((double)(visibleVolume - 112) / 3.0);
        if (visibleVolume == 0) {
            newValue = -80.0f;
        }
        if (this.gainControl1 != null) {
            this.gainControl1.setValue(newValue);
        }
        if (this.gainControl2 != null) {
            this.gainControl2.setValue(newValue);
        }
    }

    public void play(String filePath1, String filePath2) {
        paused = false;
        this.song = new File(musicFolder + filePath1);
        this.intro = null;
        if (filePath2 != null) {
            this.intro = new File(musicFolder + filePath2);
        }
        this.oggThread = new Thread(){

            @Override
            public void run() {
                while (playing) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                playing = true;
                stop = false;
                try {
                    MusicClipOld.this.clip1 = AudioSystem.getClip();
                    MusicClipOld.this.clip2 = AudioSystem.getClip();
                }
                catch (LineUnavailableException e1) {
                    e1.printStackTrace();
                }
                try {
                    AudioInputStream in = AudioSystem.getAudioInputStream(MusicClipOld.this.song);
                    AudioInputStream in2 = null;
                    if (MusicClipOld.this.intro != null) {
                        in2 = AudioSystem.getAudioInputStream(MusicClipOld.this.intro);
                    }
                    AudioFormat outFormat = MusicClipOld.this.getOutFormat(in.getFormat());
                    MusicClipOld.this.clip1.open(AudioSystem.getAudioInputStream(outFormat, in));
                    MusicClipOld.this.gainControl1 = (FloatControl)MusicClipOld.this.clip1.getControl(FloatControl.Type.MASTER_GAIN);
                    if (in2 != null) {
                        AudioFormat outFormat2 = MusicClipOld.this.getOutFormat(in2.getFormat());
                        MusicClipOld.this.clip2.open(AudioSystem.getAudioInputStream(outFormat2, in2));
                        MusicClipOld.this.gainControl2 = (FloatControl)MusicClipOld.this.clip2.getControl(FloatControl.Type.MASTER_GAIN);
                        GameApp.musicPlayer.setVolume();
                        MusicClipOld.this.clip2.setFramePosition(0);
                        long secs = MusicClipOld.this.clip2.getMicrosecondLength() / 1000L;
                        MusicClipOld.this.clip2.loop(0);
                        MusicClipOld.this.clip2.start();
                        Thread.sleep(secs - 1L);
                    }
                    GameApp.musicPlayer.setVolume();
                    if (MusicClipOld.this.oggThread == Thread.currentThread() && MusicClipOld.this.clip1 != null) {
                        MusicClipOld.this.clip1.setFramePosition(0);
                        if (MusicClipOld.this.clip1 != null) {
                            MusicClipOld.this.clip1.loop(-1);
                        }
                        if (MusicClipOld.this.clip1 != null) {
                            MusicClipOld.this.clip1.start();
                        }
                    }
                    in.close();
                    if (in2 != null) {
                        in2.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.oggThread.start();
    }

    private AudioFormat getOutFormat(AudioFormat inFormat) {
        int ch = inFormat.getChannels();
        float rate = inFormat.getSampleRate();
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, ch, ch * 2, rate, false);
    }

    private void stream(AudioInputStream in, SourceDataLine line) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (n != -1) {
            if (stop) {
                return;
            }
            if (!paused) {
                line.write(buffer, 0, n);
            } else {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            n = in.read(buffer, 0, buffer.length);
        }
    }
}

