/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Scanner;
import local.rip.engine.ScriptCommand;
import local.rip.engine.ScriptEvent;
import local.rip.engine.StrTools;

public class MST_Compiler {
    private static final byte MST_VERSION = 2;
    private static final String scriptDirectory = "data/stage/scripts/";
    private File lastFile = null;

    public void compileScript(String scriptName) {
        File scriptFile = new File("data/stage/scripts//" + scriptName + ".txt");
        this.compileScript(scriptFile);
    }

    public void compileScript(File scriptFile) {
        this.lastFile = scriptFile;
        ArrayList<ScriptEvent> eventList = new ArrayList<ScriptEvent>();
        try {
            Scanner sc = new Scanner(scriptFile);
            short eveNum = -1;
            String commandContents = "";
            while (sc.hasNextLine()) {
                String currentLine = sc.nextLine();
                if (currentLine.contains("//")) {
                    currentLine = currentLine.substring(0, currentLine.indexOf("//"));
                }
                if (currentLine.startsWith("#")) {
                    String s1 = currentLine.replaceAll("[^1234567890]", "");
                    if (eveNum != -1) {
                        eventList.add(new ScriptEvent(this.lastFile, eveNum, commandContents));
                    }
                    eveNum = (short)Integer.parseInt(s1);
                    commandContents = "";
                    continue;
                }
                commandContents = String.valueOf(commandContents) + currentLine + "\n";
            }
            eventList.add(new ScriptEvent(this.lastFile, eveNum, commandContents));
            sc.close();
            File outFile = new File("data/stage/scripts//" + scriptFile.getName().split(".txt", 0)[0] + ".mst");
            try {
                FileOutputStream oStream = new FileOutputStream(outFile);
                FileChannel chan = oStream.getChannel();
                ByteBuffer headerBuf = ByteBuffer.allocate(4);
                headerBuf.order(ByteOrder.LITTLE_ENDIAN);
                headerBuf.put("MST".getBytes());
                headerBuf.put((byte)2);
                headerBuf.flip();
                chan.write(headerBuf);
                for (ScriptEvent event : eventList) {
                    chan.write(event.toBuf());
                }
                chan.close();
                oStream.close();
            }
            catch (IOException err) {
                err.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            StrTools.msgBox("Script IO error: " + scriptFile.getName());
        }
    }

    public Hashtable<Integer, ScriptEvent> readScript(String scriptName) {
        Hashtable<Integer, ScriptEvent> eventTable = new Hashtable<Integer, ScriptEvent>();
        this.readScript(scriptName, eventTable);
        return eventTable;
    }

    public void readScript(String scriptName, Hashtable<Integer, ScriptEvent> eventTable) {
        File scriptFile;
        this.lastFile = scriptFile = new File(String.valueOf(scriptName) + ".mst");
        if (!this.lastFile.canRead()) {
            StrTools.msgBox("Can't open " + scriptName + ".mst");
        }
        int scriptLength = (int)this.lastFile.length();
        int readPosition = 0;
        byte[] loadedBytes = new byte[4];
        try {
            FileInputStream is = new FileInputStream(this.lastFile);
            ((InputStream)is).read(loadedBytes, 0, 4);
            String header = new String(loadedBytes);
            if (!header.substring(0, 3).toLowerCase().equals("mst")) {
                StrTools.msgBox(String.valueOf(scriptName) + ".mst is not a proper MST file");
                ((InputStream)is).close();
                return;
            }
            readPosition += 4;
            while (readPosition < scriptLength) {
                int bytesRead = this.readEvent(eventTable, is);
                readPosition += bytesRead;
            }
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int readEvent(Hashtable<Integer, ScriptEvent> eventTable, InputStream is) {
        int bytesRead = 0;
        byte[] loadedBytes = new byte[2];
        try {
            is.read(loadedBytes, 0, 2);
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.put(loadedBytes);
            short eventNum = bb.getShort(0);
            is.read(loadedBytes, 0, 2);
            bb.clear();
            bb.put(loadedBytes);
            int numOfEvents = bb.getShort(0);
            bytesRead += 4;
            ScriptEvent event = new ScriptEvent(eventNum);
            int i = 0;
            while (i < numOfEvents) {
                bytesRead += this.readCommand(event, is);
                ++i;
            }
            eventTable.put(Integer.valueOf(eventNum), event);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytesRead;
    }

    private int readCommand(ScriptEvent event, InputStream is) {
        int bytesRead = 0;
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        byte[] loadedBytes = new byte[4];
        try {
            is.read(loadedBytes, 0, 1);
            byte commandID = loadedBytes[0];
            ScriptCommand comm = new ScriptCommand(commandID);
            switch (commandID) {
                case 0: 
                case 19: 
                case 27: 
                case 37: 
                case 38: 
                case 45: 
                case 61: 
                case 75: 
                case 78: {
                    bb.clear();
                    is.read(loadedBytes, 0, 4);
                    bytesRead += 4;
                    bb.put(loadedBytes);
                    int textLength = bb.getInt(0);
                    comm.paramList.add(textLength);
                    byte[] text = new byte[textLength];
                    is.read(text, 0, textLength);
                    bytesRead += textLength;
                    comm.text = new String(text);
                    break;
                }
                default: {
                    int numbOfParams = ScriptCommand.paramLens[commandID];
                    int i = 0;
                    while (i < numbOfParams) {
                        bb.clear();
                        is.read(loadedBytes, 0, 4);
                        bb.put(loadedBytes);
                        comm.paramList.add(bb.getInt(0));
                        bytesRead += 4;
                        ++i;
                    }
                    break block1;
                }
            }
            event.comList.add(comm);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytesRead;
    }

    public static void main(String[] args) {
        System.out.println("Name of script file for compiling: ");
        MST_Compiler m = new MST_Compiler();
        BufferedReader dataIn = new BufferedReader(new InputStreamReader(System.in));
        try {
            String fileName = dataIn.readLine();
            if (fileName.equals("all")) {
                File[] files;
                File[] fileArray = files = new File(scriptDirectory).listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().split("\\.")[1].toLowerCase().equals("txt")) {
                        m.compileScript(f);
                        System.out.println("compiled " + f.getName());
                    }
                    ++n2;
                }
            } else {
                m.compileScript(fileName);
            }
            System.out.println("SUCCESS");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

