/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.util.HashMap;
import java.util.Vector;
import local.rip.engine.Physical;
import local.rip.engine.Player;

public class Line {
    short x1;
    short x2;
    short y1;
    short y2;
    public static final byte TYPE_SOLID = 1;
    public static final byte TYPE_GRASS = 2;
    public static final byte TYPE_SPLASH = 3;
    public static final byte TYPE_METAL = 4;
    public static final byte TYPE_SAND = 5;
    public static final byte TYPE_ENEMY = 6;
    private byte lineSlope;
    private byte lineType;
    public static final byte FLOOR = 0;
    public static final byte ROOF = 1;
    public static final byte LEFTWALL = 2;
    public static final byte RIGHTWALL = 3;
    static final int LEFT_COLL = 1;
    static final int UP_COLL = 2;
    static final int RIGHT_COLL = 4;
    static final int DOWN_COLL = 8;
    static final int SCALE = 512;

    public Line(int newX1, int newY1, int newX2, int newY2) {
        this.x1 = (short)newX1;
        this.x2 = (short)newX2;
        this.y1 = (short)newY1;
        this.y2 = (short)newY2;
        this.classification();
    }

    public void classification() {
        float slope;
        this.lineSlope = this.x1 - this.x2 == 0 ? (this.y2 - this.y1 > 0 ? (byte)2 : (byte)3) : ((double)(slope = (float)(this.y2 - this.y1) / (float)(this.x2 - this.x1)) <= 1.5 && (double)slope >= -1.5 ? (this.x2 - this.x1 > 0 ? (byte)0 : 1) : (this.y2 - this.y1 > 0 ? (byte)2 : (byte)3));
    }

    public void collision(Physical thing) {
        switch (this.lineSlope) {
            case 0: {
                if (thing.xPos + thing.hitRect.x * 512 / 2 >= this.x2 * 512 || thing.xPos + (thing.hitRect.x + thing.hitRect.width) * 512 / 2 <= this.x1 * 512) break;
                float slope = (float)(this.y2 - this.y1) / (float)(this.x2 - this.x1);
                int testY = (int)((float)(thing.xPos - this.x1 * 512) * slope + (float)(this.y1 * 512));
                int maxY = Math.max(this.y1, this.y2) * 512;
                int minY = Math.min(this.y1, this.y2) * 512;
                if (testY > maxY) {
                    testY = maxY;
                }
                if (testY < minY) {
                    testY = minY;
                }
                if (thing.yPos + (thing.hitRect.y + thing.hitRect.height) * 512 <= testY || (float)(thing.yPos + (thing.hitRect.y + thing.hitRect.height * 2 / 3) * 512 - thing.yVel) - Math.abs(slope * (float)thing.xVel) > (float)testY || thing.yVel <= (int)((float)thing.xVel * slope) - 0) break;
                thing.yPos = testY - (thing.hitRect.y + thing.hitRect.height) * 512;
                thing.yVel = (int)((float)thing.xVel * slope) + 200;
                thing.collision |= 8;
                thing.lineType = this.lineType;
                break;
            }
            case 1: {
                float slope;
                int testY;
                if (thing.xPos + thing.hitRect.x * 512 / 2 >= this.x1 * 512 || thing.xPos + (thing.hitRect.x + thing.hitRect.width) * 512 / 2 <= this.x2 * 512 || thing.yPos + thing.hitRect.y * 512 >= (testY = (int)((float)(thing.xPos - this.x1 * 512) * (slope = (float)(this.y2 - this.y1) / (float)(this.x2 - this.x1)) + (float)(this.y1 * 512))) || thing.yPos - thing.yVel < testY || thing.yVel >= (int)((float)thing.xVel * slope) + 400) break;
                thing.yPos = testY - thing.hitRect.y * 512;
                thing.yVel = (int)((float)thing.xVel * slope);
                thing.collision |= 2;
                thing.lineType = this.lineType;
                break;
            }
            case 2: {
                int testXOld;
                int testX;
                if (thing.yPos + thing.hitRect.y * 512 >= this.y2 * 512 || thing.yPos + (thing.hitRect.y + thing.hitRect.height) * 512 <= this.y1 * 512) break;
                float slope = (float)(this.x2 - this.x1) / (float)(this.y2 - this.y1);
                if (slope < 0.0f || thing.yPos > this.y2 * 512) {
                    testX = (int)((float)(thing.yPos + thing.hitRect.y * 512 - this.y1 * 512) * slope + (float)(this.x1 * 512));
                    testXOld = (int)((float)(thing.yOld + thing.hitRect.y * 512 - this.y1 * 512) * slope + (float)(this.x1 * 512));
                } else {
                    testX = (int)((float)(thing.yPos + (thing.hitRect.y + thing.hitRect.height) * 512 - this.y1 * 512) * slope + (float)(this.x1 * 512));
                    testXOld = (int)((float)(thing.yOld + (thing.hitRect.y + thing.hitRect.height) * 512 - this.y1 * 512) * slope + (float)(this.x1 * 512));
                }
                if (thing.xPos + thing.hitRect.x * 512 >= testX || thing.xOld < testXOld || thing.xVel >= (int)((float)thing.yVel * slope + 400.0f)) break;
                thing.xPos = testX - thing.hitRect.x * 512;
                thing.xVel = (int)((float)thing.yVel * slope) / 2;
                thing.collision |= 1;
                thing.lineType = this.lineType;
                break;
            }
            case 3: {
                int testXOld;
                int testX;
                if (thing.yPos + thing.hitRect.y * 512 >= this.y1 * 512 || thing.yPos + (thing.hitRect.y + thing.hitRect.height) * 512 <= this.y2 * 512) break;
                float slope = (float)(this.x2 - this.x1) / (float)(this.y2 - this.y1);
                if (slope > 0.0f || thing.yPos > this.y1 * 512) {
                    testX = (int)((float)(thing.yPos + thing.hitRect.y * 512 - this.y1 * 512) * slope + (float)(this.x1 * 512));
                    testXOld = (int)((float)(thing.yOld + thing.hitRect.y * 512 - this.y1 * 512) * slope + (float)(this.x1 * 512));
                } else {
                    testX = (int)((float)(thing.yPos + (thing.hitRect.y + thing.hitRect.height) * 512 - this.y1 * 512) * slope + (float)(this.x1 * 512));
                    testXOld = (int)((float)(thing.yOld + (thing.hitRect.y + thing.hitRect.height) * 512 - this.y1 * 512) * slope + (float)(this.x1 * 512));
                }
                if (thing.xPos + (thing.hitRect.x + thing.hitRect.width) * 512 <= testX || thing.xOld > testXOld || thing.xVel <= (int)((float)thing.yVel * slope - 400.0f)) break;
                thing.xPos = testX - (thing.hitRect.x + thing.hitRect.width) * 512;
                thing.xVel = (int)((float)thing.yVel * slope) / 2;
                thing.collision |= 4;
                thing.lineType = this.lineType;
            }
        }
    }

    public void setTiles(HashMap<Integer, Vector<Line>> mappy, int mapX, int mapY) {
        if (this.abs(this.x2 - this.x1) >= this.abs(this.y2 - this.y1)) {
            short yStart;
            short yEnd;
            short xStart;
            int xEnd;
            float slope = (float)(this.y2 - this.y1) / (float)(this.x2 - this.x1);
            if (this.x2 > this.x1) {
                xEnd = this.x2 + 10;
                xStart = this.x1;
                yEnd = this.y2;
                yStart = this.y1;
            } else {
                xEnd = this.x1 + 10;
                xStart = this.x2;
                yEnd = this.y1;
                yStart = this.y2;
            }
            int lastX = xStart / 20;
            int lastY = yStart / 20;
            this.putInMap(lastY * mapX + lastX, mappy);
            int i = xStart + 1;
            while (i % 20 != 0) {
                ++i;
            }
            while (i <= xEnd) {
                int testX = i / 20;
                int testY = (int)((float)(i - xStart) * slope + (float)yStart) / 20;
                this.putInMap(testY * mapX + testX, mappy);
                if (testY != lastY) {
                    this.putInMap(testY * mapX + (testX - 1), mappy);
                }
                lastY = testY;
                lastX = testX;
                i += 20;
            }
        } else {
            short yStart;
            int yEnd;
            short xStart;
            int xEnd;
            float slope = (float)(this.x2 - this.x1) / (float)(this.y2 - this.y1);
            if (this.y2 > this.y1) {
                xEnd = this.x2 + 10;
                xStart = this.x1;
                yEnd = this.y2 + 10;
                yStart = this.y1;
            } else {
                xEnd = this.x1 + 10;
                xStart = this.x2;
                yEnd = this.y1 + 10;
                yStart = this.y2;
            }
            int lastX = xStart / 20;
            int lastY = yStart / 20;
            this.putInMap(lastY * mapX + lastX, mappy);
            int i = yStart + 1;
            while (i % 20 != 0) {
                ++i;
            }
            while (i <= yEnd) {
                int testY = i / 20;
                int testX = (int)((float)(i - yStart) * slope + (float)xStart) / 20;
                this.putInMap(testY * mapX + testX, mappy);
                if (testX != lastX) {
                    this.putInMap((testY - 1) * mapX + testX, mappy);
                }
                lastY = testY;
                lastX = testX;
                i += 20;
            }
        }
    }

    private void putInMap(int index, HashMap<Integer, Vector<Line>> map) {
        if (map.containsKey(index)) {
            map.get(index).add(this);
        } else {
            Vector<Line> lines = new Vector<Line>(0);
            lines.add(this);
            map.put(index, lines);
        }
    }

    private int abs(int x) {
        if (x < 0) {
            return -x;
        }
        return x;
    }

    public boolean cliffhang(Player pc) {
        if (this.lineSlope != 0 || pc.xPos > this.x1 * 512 && pc.xPos < this.x2 * 512) {
            return false;
        }
        if (pc.xPos + (pc.hitRect.width + pc.hitRect.x) * 512 + 800 > this.x1 * 512 && pc.xPos < this.x1 * 512) {
            if (pc.yPos + pc.hitRect.y * 512 + 1024 < this.y1 * 512 && pc.yPos > this.y1 * 512 && (pc.direction & 4) != 0) {
                pc.yPos = this.y1 * 512 + 1024;
                pc.xPos = this.x1 * 512 - (pc.hitRect.width + pc.hitRect.x) * 512 + 1024;
                pc.yVel = 0;
                pc.xVel = 0;
                return true;
            }
        } else if (pc.xPos + pc.hitRect.x * 512 - 800 < this.x2 * 512 && pc.xPos > this.x2 * 512 && pc.yPos + pc.hitRect.y * 512 + 1024 < this.y2 * 512 && pc.yPos > this.y2 * 512 && (pc.direction & 1) != 0) {
            pc.yPos = this.y2 * 512 + 1024;
            pc.xPos = this.x2 * 512 - pc.hitRect.x * 512 - 1024;
            pc.yVel = 0;
            pc.xVel = 0;
            return true;
        }
        return false;
    }

    public void setType(int val) {
        this.lineType = (byte)val;
    }

    public byte getType() {
        return this.lineType;
    }

    public byte getSlope() {
        return this.lineSlope;
    }
}

