/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Vector;
import local.rip.engine.GameApp;

public class Inventory {
    public static final int MIN_ITEMS = 7;
    Vector<Integer> items;
    Vector<Integer> notes;
    int weaponBooks = 0;
    int selectedItem = 0;
    int combinationSelection = -1;

    public Inventory() {
        this.items = new Vector();
        this.notes = new Vector();
        int i = 0;
        while (i < 7) {
            this.items.add(0);
            ++i;
        }
    }

    public Inventory(Vector<Integer> oldItems, Vector<Integer> oldNotes) {
        this.items = oldItems;
        this.notes = oldNotes;
    }

    public Vector<Integer> getItems() {
        return new Vector<Integer>(this.items);
    }

    public Vector<Integer> getNotes() {
        return new Vector<Integer>(this.notes);
    }

    public boolean isValidCombination() {
        return this.isValidCombination(this.items.get(this.selectedItem), this.items.get(this.combinationSelection));
    }

    public boolean isValidCombination(int item1, int item2) {
        if (item1 > item2) {
            int temp = item1;
            item1 = item2;
            item2 = temp;
        }
        int combination = item1 << 16 | item2;
        switch (combination) {
            case 65538: {
                return true;
            }
            case 720908: {
                return true;
            }
        }
        return false;
    }

    public void combine() {
        this.combine(this.items.get(this.selectedItem), this.items.get(this.combinationSelection));
    }

    public void combine(int item1, int item2) {
        if (item1 > item2) {
            int temp = item1;
            item1 = item2;
            item2 = temp;
        }
        int combination = item1 << 16 | item2;
        switch (combination) {
            case 65538: {
                GameApp.scriptFlags.unsetFlag(2003);
                GameApp.scriptFlags.setFlag(2004);
                this.removeItem(item1);
                this.removeItem(item2);
                this.addItem(3);
                this.selectedItem = this.items.indexOf(3);
                this.combinationSelection = -1;
                break;
            }
            case 720908: {
                this.removeItem(item1);
                this.removeItem(item2);
                this.addItem(13);
                this.selectedItem = this.items.indexOf(13);
                this.combinationSelection = -1;
            }
        }
    }

    public void drawItems(Graphics2D g, int xOff, int yOff) {
        int index = this.selectedItem - 4;
        while (index < 0) {
            index += this.items.size();
        }
        xOff -= 40;
        int i = 0;
        while (i < 9) {
            this.drawItem(g, xOff, yOff, index);
            if (++index >= this.items.size()) {
                index = 0;
            }
            xOff += 60;
            ++i;
        }
    }

    public void drawItem(Graphics2D g, int x, int y, int index) {
        Rectangle frameRect = new Rectangle();
        int itemType = this.items.get(index);
        frameRect.x = itemType % 10 * 40;
        frameRect.y = itemType / 10 * 40;
        frameRect.width = 40;
        frameRect.height = 40;
        if ((index == this.selectedItem || index == this.combinationSelection) && GameApp.guiMan.inventoryYIndex == 1) {
            g.setColor(new Color(60, 60, 80, 200));
            g.fillRect(x - 20, y, 40, 40);
        }
        GameApp.gMan.mainBlit(5, frameRect, x - 20, y, g);
    }

    public void nextItem() {
        ++this.selectedItem;
        if (this.selectedItem >= this.items.size()) {
            this.selectedItem = 0;
        }
    }

    public void lastItem() {
        --this.selectedItem;
        if (this.selectedItem < 0) {
            this.selectedItem = this.items.size() - 1;
        }
    }

    public int getSelectedItem() {
        return this.items.get(this.selectedItem);
    }

    public void addItem(int newItem) {
        if (this.items.contains(newItem) && newItem != 0) {
            return;
        }
        if (this.items.size() == 7) {
            int i = 0;
            while (i < 7) {
                if (this.items.get(i) == 0) {
                    this.items.set(i, newItem);
                    return;
                }
                ++i;
            }
        }
        this.items.add(newItem);
    }

    public void removeItem(int takenItem) {
        this.items.removeElement(takenItem);
        while (this.items.size() < 7) {
            this.items.add(0);
        }
    }

    public void idleInventory() {
        if (this.selectedItem >= this.items.size()) {
            this.selectedItem = this.items.size() - 1;
        }
        this.combinationSelection = -1;
    }

    public void comboInventory() {
        this.combinationSelection = this.selectedItem;
    }

    public void resetCombo() {
        this.selectedItem = this.combinationSelection;
        this.combinationSelection = -1;
    }
}

