/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import local.rip.engine.GameApp;
import local.rip.engine.Physical;
import local.rip.engine.Player;

public class GraphicsManager {
    private final int NUM_BMP = 23;
    public static final int GFX_SCALE = 512;
    private int smallShakeTimer = 0;
    public static final byte BMP_RIP = 0;
    public static final byte BMP_MAP_TILESET = 1;
    public static final byte BMP_EFFECT = 2;
    public static final byte BMP_ENTITY1 = 3;
    public static final byte BMP_ENTITY2 = 4;
    public static final byte BMP_ITEM = 5;
    public static final byte BMP_AXE = 6;
    public static final byte BMP_FACEPIC = 7;
    public static final byte BMP_STANDARD = 8;
    public static final byte BMP_WEAPICON = 9;
    public static final byte BMP_GUEST = 10;
    public static final byte BMP_GUI = 11;
    public static final byte BMP_ZIP = 12;
    public static final byte BMP_SAVE_ICON_TEMP = 13;
    public static final byte BMP_CG_1 = 14;
    public static final byte BMP_CG_2 = 15;
    public static final byte BMP_CHLOE = 16;
    public static final byte BMP_RISA = 17;
    public static final byte BMP_JAY = 18;
    public static final byte BMP_LUCA = 19;
    public static final byte BMP_KNIFE = 20;
    public static final byte BMP_BG_1 = 21;
    public static final byte BMP_BG_2 = 22;
    private Physical focusTarget = null;
    private Point camFocus = new Point(0, 0);
    private Point camera = new Point(0, 0);
    private Point focusOffset = new Point(0, 0);
    private Point rendCamera = new Point(0, 0);
    private int focusSpeed = 13;
    private static BufferedImage[] gfxArray;

    GraphicsManager() {
        gfxArray = new BufferedImage[23];
        GraphicsManager.gfxArray[13] = new BufferedImage(48, 48, 6);
        GraphicsManager.gfxArray[14] = new BufferedImage(800, 600, 6);
        this.loadImage((byte)0, "data/char/rip-char");
        this.loadImage((byte)2, "data/effects");
        this.loadImage((byte)11, "data/gui");
        this.loadImage((byte)5, "data/items");
        this.loadImage((byte)6, "data/rip-axe");
        this.loadImage((byte)20, "data/risa-knife");
        this.loadImage((byte)8, "data/npc/npc-standard");
        this.loadImage((byte)16, "data/char/chloe-char");
        this.loadImage((byte)17, "data/char/risa-char");
        this.loadImage((byte)18, "data/char/jay-char");
        this.loadImage((byte)19, "data/char/luca-char");
        this.loadImage((byte)12, "data/char/zip-char");
        this.loadImage((byte)10, "data/npc/npc-guest");
    }

    public void setSheet(String filename, byte sheetType) {
        if (gfxArray[sheetType] != null) {
            gfxArray[sheetType].flush();
        }
        this.loadImage(sheetType, filename);
    }

    public BufferedImage getSheet(byte sheetType) {
        return gfxArray[sheetType];
    }

    public void alphaBlit(int gfxNum, Rectangle frameRect, int xPixel, int yPixel, Graphics2D g, int alpha) {
        double alphaVal = (double)alpha / 255.0;
        Composite oldComp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, (float)alphaVal));
        g.drawImage(gfxArray[gfxNum], xPixel, yPixel, xPixel + frameRect.width, yPixel + frameRect.height, frameRect.x, frameRect.y, frameRect.x + frameRect.width, frameRect.y + frameRect.height, null);
        g.setComposite(oldComp);
    }

    public void alphaCamBlit(int gfxNum, Rectangle frameRect, int xPixel, int yPixel, Graphics2D g, int alpha) {
        double alphaVal = (double)alpha / 255.0;
        Composite oldComp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, (float)alphaVal));
        this.camBlit(gfxNum, frameRect, xPixel, yPixel, g);
        g.setComposite(oldComp);
    }

    public void alphaCGBlit(int gfxNum, Rectangle frameRect, Graphics2D g, int alpha) {
        double alphaVal = (double)alpha / 255.0;
        Composite oldComp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, (float)alphaVal));
        g.drawImage(gfxArray[gfxNum], 0, 0, 800, 600, frameRect.x, frameRect.y, frameRect.x + frameRect.width, frameRect.y + frameRect.height, null);
        g.setComposite(oldComp);
    }

    public void mainBlit(int gfxNum, Rectangle frameRect, int xPixel, int yPixel, Graphics2D g) {
        g.drawImage(gfxArray[gfxNum], xPixel, yPixel, xPixel + frameRect.width, yPixel + frameRect.height, frameRect.x, frameRect.y, frameRect.x + frameRect.width, frameRect.y + frameRect.height, null);
    }

    public void camBlit(int gfxNum, Rectangle frameRect, int xCoord, int yCoord, Graphics2D g) {
        int xPixel = xCoord / 512 - this.rendCamera.x;
        int yPixel = yCoord / 512 - this.rendCamera.y;
        if (xPixel > 400 || yPixel > 300 || xPixel + frameRect.width < 0 || yPixel + frameRect.height < 0) {
            return;
        }
        this.mainBlit(gfxNum, frameRect, xPixel, yPixel, g);
    }

    public void reflectCamBlit(int gfxNum, Rectangle frameRect, int xCoord, int yCoord, Graphics2D g, int mirrorIndex) {
        Rectangle copyRect = (Rectangle)frameRect.clone();
        Rectangle mirror = GameApp.currentMap.getMirror(mirrorIndex);
        int diff = mirror.x - xCoord;
        if (diff > 0) {
            xCoord = mirror.x;
            copyRect.x += diff / 512;
            copyRect.width -= diff / 512;
        }
        if ((diff = mirror.x + mirror.width - (xCoord + copyRect.width * 512)) < 0) {
            copyRect.width += diff / 512;
        }
        if ((diff = mirror.y - yCoord) > 0) {
            yCoord = mirror.y;
            copyRect.height -= diff / 512;
        }
        if ((diff = mirror.y + mirror.height - (yCoord + copyRect.height * 512)) < 0) {
            copyRect.y -= diff / 512;
            copyRect.height += diff / 512;
        }
        int xPixel = xCoord / 512 - this.rendCamera.x;
        int yPixel = yCoord / 512 - this.rendCamera.y;
        if (xPixel > 400 || yPixel > 300 || xPixel + copyRect.width < 0 || yPixel + copyRect.height < 0) {
            return;
        }
        g.drawImage(gfxArray[gfxNum], xPixel, yPixel + copyRect.height, xPixel + copyRect.width, yPixel, copyRect.x, copyRect.y, copyRect.x + copyRect.width, copyRect.y + copyRect.height, null);
    }

    public void reflectAlphaBlit(int gfxNum, Rectangle frameRect, int xCoord, int yCoord, Graphics2D g, int alpha, int mirrorIndex) {
        double alphaVal = (double)alpha / 255.0;
        Composite oldComp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, (float)alphaVal));
        this.reflectCamBlit(gfxNum, frameRect, xCoord, yCoord, g, mirrorIndex);
        g.setComposite(oldComp);
    }

    public void cameraUpdate() {
        if (this.focusTarget == null) {
            return;
        }
        Point focus = new Point(this.focusTarget.xPos, this.focusTarget.yPos);
        if (this.focusTarget instanceof Player) {
            if ((this.focusTarget.direction & 1) != 0) {
                this.focusOffset.x -= 2048;
                if (this.focusOffset.x < -10240) {
                    this.focusOffset.x = -10240;
                }
            } else if ((this.focusTarget.direction & 4) != 0) {
                this.focusOffset.x += 2048;
                if (this.focusOffset.x > 10240) {
                    this.focusOffset.x = 10240;
                }
            }
            if ((this.focusTarget.direction & 2) != 0) {
                this.focusOffset.y -= 4096;
                if (this.focusOffset.y < -23040) {
                    this.focusOffset.y = -23040;
                }
            } else if ((this.focusTarget.direction & 8) != 0) {
                this.focusOffset.y += 4096;
                if (this.focusOffset.y > 28160) {
                    this.focusOffset.y = 28160;
                }
            } else {
                this.focusOffset.y = 0;
            }
            focus.y -= 12800;
            focus.x += this.focusOffset.x;
            focus.y += this.focusOffset.y;
        } else {
            this.focusOffset.x = 0;
            this.focusOffset.y = 0;
        }
        this.camFocus.x = focus.x - 102400;
        this.camFocus.y = focus.y - 76800;
        int minX = 5120;
        int minY = 5120;
        int maxX = (GameApp.currentMap.getMapX() * 20 - 400) * 512 - minX;
        int maxY = (GameApp.currentMap.getMapY() * 20 - 300) * 512 - minY;
        if (this.camFocus.x > maxX) {
            this.camFocus.x = maxX;
        }
        if (this.camFocus.y > maxY) {
            this.camFocus.y = maxY;
        }
        if (this.camFocus.x < minX) {
            this.camFocus.x = minX;
        }
        if (this.camFocus.y < minY) {
            this.camFocus.y = minY;
        }
        this.camera.x += (this.camFocus.x - this.camera.x) / this.focusSpeed;
        this.camera.y += (this.camFocus.y - this.camera.y) / this.focusSpeed;
        if (this.camera.x > maxX) {
            this.camera.x = maxX;
        }
        if (this.camera.y > maxY) {
            this.camera.y = maxY;
        }
        if (this.camera.x < minX) {
            this.camera.x = minX;
        }
        if (this.camera.y < minY) {
            this.camera.y = minY;
        }
        if (this.smallShakeTimer > 0) {
            --this.smallShakeTimer;
            this.camera.x += GameApp.randomInt(-1, 1) * 512;
            this.camera.y += GameApp.randomInt(-1, 1) * 512;
        }
    }

    public void setSmallShake(int time) {
        if (this.smallShakeTimer < time) {
            this.smallShakeTimer = time;
        }
    }

    public void cameraUpdateInstant() {
        int x = this.focusSpeed;
        this.focusSpeed = 1;
        this.cameraUpdate();
        this.focusSpeed = x;
    }

    public void setCameraTarget(Physical P) {
        this.focusTarget = P;
    }

    public void updateRendCamera() {
        this.rendCamera.x = this.camera.x / 512;
        this.rendCamera.y = this.camera.y / 512;
    }

    public Point getSizeOfImage(int bmp_index) {
        return new Point(gfxArray[bmp_index].getWidth(), gfxArray[bmp_index].getHeight());
    }

    public Point getRendCamera() {
        return new Point(this.rendCamera);
    }

    public int getWidth(byte bmp) {
        return gfxArray[bmp].getWidth();
    }

    public int getHeight(byte bmp) {
        return gfxArray[bmp].getHeight();
    }

    public void moveCamera(int x, int y) {
        this.camera.x = x;
        this.camera.y = y;
    }

    public void copySaveIcon(Graphics2D g) {
        g.drawImage(gfxArray[13], 0, 0, 48, 48, 0, 0, 48, 48, null);
    }

    public void loadCG(String cgName) {
        this.loadImage((byte)15, "data/cgs/" + cgName);
    }

    public void loadFacePic(String facePicName) {
        this.loadImage((byte)7, "data/portraits/" + facePicName);
    }

    public void loadImage(byte bitmap, String fName) {
        BufferedImage temp = GraphicsManager.loadImage(fName);
        GraphicsManager.gfxArray[bitmap] = GameApp.graphConfig.createCompatibleImage(temp.getWidth(), temp.getHeight(), 3);
        Graphics tempG = gfxArray[bitmap].getGraphics();
        tempG.drawImage(temp, 0, 0, temp.getWidth(), temp.getHeight(), 0, 0, temp.getWidth(), temp.getHeight(), null);
        tempG.dispose();
        temp.flush();
        gfxArray[bitmap].setAccelerationPriority(1.0f);
    }

    public static BufferedImage loadImage(String fName) {
        try {
            fName = fName.replaceAll("[\n\r]", "");
            fName = fName.toLowerCase();
            return ImageIO.read(new File(String.valueOf(fName) + ".rpg"));
        }
        catch (IOException e) {
            try {
                return ImageIO.read(new File(String.valueOf(fName) + ".png"));
            }
            catch (IOException e2) {
                System.out.println("Couldn't find Image: " + fName);
                e2.printStackTrace();
                return null;
            }
        }
    }

    public void cgSwap() {
        BufferedImage oldCG = gfxArray[14];
        GraphicsManager.gfxArray[14] = gfxArray[15];
        GraphicsManager.gfxArray[15] = null;
        oldCG.flush();
    }

    public void bgSwap() {
        BufferedImage oldBG = gfxArray[21];
        GraphicsManager.gfxArray[21] = gfxArray[22];
        GraphicsManager.gfxArray[22] = null;
        oldBG.flush();
        this.setAlpha(gfxArray[21], 255);
    }

    public void setAlpha(BufferedImage image, int alpha) {
        if (alpha < 0 || alpha > 255) {
            System.out.println("Bad Alpha Value: " + alpha);
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int pixel = image.getRGB(x, y);
                if ((pixel & 0xFF000000) != 0) {
                    pixel = alpha << 24 | pixel & 0xFFFFFF;
                    image.setRGB(x, y, pixel);
                }
                ++y;
            }
            ++x;
        }
    }

    public void endCG() {
        GraphicsManager.gfxArray[15] = GameApp.tempScreen;
    }

    public void drawCGs(Graphics2D g) {
        BufferedImage cg1 = gfxArray[14];
        BufferedImage cg2 = gfxArray[15];
        if (this.smallShakeTimer <= 0) {
            g.drawImage(cg1, 0, 0, 800, 600, 0, 0, cg1.getWidth(), cg1.getHeight(), null);
        } else {
            int x = GameApp.randomInt(-3, 3);
            int y = GameApp.randomInt(-3, 3);
            g.drawImage(cg1, x, y, 800 + x, 600 + y, 0, 0, cg1.getWidth(), cg1.getHeight(), null);
        }
        if (cg2 != null) {
            this.alphaCGBlit(15, new Rectangle(0, 0, cg2.getWidth(), cg2.getHeight()), g, GameApp.cgAlpha);
        }
    }

    public void setCameraSpeed(Integer speed) {
        this.focusSpeed = speed;
    }
}

