/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import local.rip.engine.ConfigFile;
import local.rip.engine.GameApp;
import local.rip.engine.SaveManager;
import local.rip.engine.SoundPlayer;

public class GameConfig {
    private static ConfigFile config;
    private static int[] keyIDNumbs;
    private static int[] keyAssignments;
    private static String[] keyNames;

    static {
        keyIDNumbs = new int[]{16, 64, 256, 1, 2, 4, 8, 512, 2048};
        keyAssignments = new int[53];
        keyNames = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "NUMPAD 0", "NUMPAD 1", "NUMPAD 2", "NUMPAD 3", "NUMPAD 4", "NUMPAD 5", "NUMPAD 6", "NUMPAD 7", "NUMPAD 8", "NUMPAD 9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "LEFT", "UP", "RIGHT", "DOWN", "SHIFT", "CONTROL", "SPACEBAR"};
    }

    public static void clearAllKeys() {
        int i = 0;
        while (i < keyAssignments.length) {
            GameConfig.keyAssignments[i] = 0;
            ++i;
        }
    }

    public static String getKeyName(int key) {
        int i = 0;
        while (i < keyNames.length) {
            if (keyAssignments[i] == key) {
                if (i < keyNames.length) {
                    return keyNames[i];
                }
                return "INVALID KEY";
            }
            ++i;
        }
        return "NO KEY";
    }

    public static String getKeyNameFromIDNumb(int id) {
        if (id < keyIDNumbs.length) {
            return GameConfig.getKeyName(keyIDNumbs[id]);
        }
        return "INVALID KEY ID";
    }

    public static void assignKey(int VK_type, int KEY_type) {
        int i = 0;
        while (i < keyAssignments.length) {
            int n = i++;
            keyAssignments[n] = keyAssignments[n] & ~KEY_type;
        }
        int x = GameConfig.getKeyAssignIndex(VK_type);
        if (x < 0) {
            System.out.println("INVALID KEY SET: " + VK_type);
            return;
        }
        GameConfig.keyAssignments[x] = KEY_type;
    }

    public static int getKeyAssigned(int VK_type) {
        int x = GameConfig.getKeyAssignIndex(VK_type);
        if (x < 0) {
            return 0;
        }
        return keyAssignments[x];
    }

    public static int getKeyAssignIndex(int VK_type) {
        if (VK_type >= 48 && VK_type <= 57) {
            return VK_type - 48;
        }
        if (VK_type >= 96 && VK_type <= 105) {
            return VK_type - 96 + 10;
        }
        if (VK_type >= 65 && VK_type <= 90) {
            return VK_type - 65 + 20;
        }
        if (VK_type >= 37 && VK_type <= 40) {
            return VK_type - 37 + 46;
        }
        if (VK_type >= 16 && VK_type <= 17) {
            return VK_type - 16 + 50;
        }
        if (VK_type == 32) {
            return 52;
        }
        return -1;
    }

    public static boolean loadConfigFile() {
        try {
            FileInputStream fin = new FileInputStream(String.valueOf(SaveManager.getSaveDirectory()) + "config.dat");
            ObjectInputStream ois = new ObjectInputStream(fin);
            config = (ConfigFile)ois.readObject();
            ois.close();
            fin.close();
            System.out.println("Config Loaded");
            return true;
        }
        catch (FileNotFoundException e) {
            System.out.println("Config Not Found");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void saveConfigFile() {
        config = new ConfigFile(keyAssignments, GameApp.musicPlayer.visibleVolume, (int)SoundPlayer.volume);
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(SaveManager.getSaveDirectory()) + "config.dat");
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(config);
            oos.close();
            fout.close();
            System.out.println("Config Saved");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void doConfig() {
        if (GameConfig.loadConfigFile()) {
            keyAssignments = config.getKeys();
            GameApp.musicPlayer.visibleVolume = config.getBgmVolume();
            GameApp.musicPlayer.setVolume();
            SoundPlayer.volume = config.getSfxVolume();
        } else {
            GameConfig.assignDefaultKeys();
        }
    }

    public static void assignDefaultKeys() {
        GameConfig.assignKey(37, 1);
        GameConfig.assignKey(39, 4);
        GameConfig.assignKey(38, 2);
        GameConfig.assignKey(40, 8);
        GameConfig.assignKey(16, 2048);
        GameConfig.assignKey(90, 16);
        GameConfig.assignKey(88, 64);
        GameConfig.assignKey(83, 128);
        GameConfig.assignKey(32, 256);
        GameConfig.assignKey(65, 512);
        GameConfig.assignKey(48, 65536);
        GameConfig.assignKey(49, 131072);
        GameConfig.assignKey(50, 262144);
        GameConfig.assignKey(51, 524288);
        GameConfig.assignKey(52, 0x100000);
        GameConfig.assignKey(53, 0x200000);
    }
}

