/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import local.rip.effect.EffectManager;
import local.rip.engine.Flags;
import local.rip.engine.GUI;
import local.rip.engine.GameConfig;
import local.rip.engine.GraphicsManager;
import local.rip.engine.Inventory;
import local.rip.engine.MusicPlayer;
import local.rip.engine.NumObj;
import local.rip.engine.OptionDialog;
import local.rip.engine.Player;
import local.rip.engine.RipPC;
import local.rip.engine.RisaPC;
import local.rip.engine.SaveFile;
import local.rip.engine.SaveManager;
import local.rip.engine.ScriptRunner;
import local.rip.engine.SoundPlayer;
import local.rip.engine.Stage;
import local.rip.entity.Entity034Partner;
import local.rip.entity.EntityManager;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.DirectAndRawInputEnvironmentPlugin;

public class GameApp
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int[] versionNumber;
    private static final String PREF_FULLSCREEN_DEVICE = "fullscreen_device_pref";
    private static boolean ENABLE_FULLSCREEN;
    private static boolean FULLSCREEN_MODE;
    private static boolean isScreenScaled;
    private static boolean isProportionalScaled;
    private static DisplayMode defaultDM;
    static Random rand;
    public static final int CANVAS_WIDTH = 400;
    public static final int CANVAS_HEIGHT = 300;
    static int window_width;
    static int window_height;
    static int window_proportional_width;
    public static int screenOffsetY;
    static final int KEY_LEFT = 1;
    static final int KEY_UP = 2;
    static final int KEY_RIGHT = 4;
    static final int KEY_DOWN = 8;
    static final int KEY_JUMP = 16;
    static final int KEY_ESC = 32;
    static final int KEY_USE = 64;
    static final int KEY_SWITCH = 128;
    static final int KEY_INTERACT = 256;
    static final int KEY_MENU = 512;
    static final int KEY_RUN = 2048;
    static final int KEY_LEFT_DOUBLE = 4096;
    static final int KEY_RIGHT_DOUBLE = 16384;
    static final int KEY_0 = 65536;
    static final int KEY_1 = 131072;
    static final int KEY_2 = 262144;
    static final int KEY_3 = 524288;
    static final int KEY_4 = 0x100000;
    static final int KEY_5 = 0x200000;
    static final int KEY_F11 = 0x400000;
    public static final int UPDATE_RATE = 60;
    static final long UPDATE_PERIOD = 16666666L;
    public static int key_held;
    public static int key_pressed;
    public static int key_buf;
    public static int key_prev;
    private static Controller myController;
    private static int control_buf;
    private int controllerCheckTimer = 100;
    public static Player pc;
    public static RipPC ripPc;
    public static RisaPC risaPc;
    public static Entity034Partner partnerPc;
    public static Stage currentMap;
    public static Flags scriptFlags;
    public static Inventory inventory;
    public static SaveFile[] saves;
    public static SaveFile loadedSave;
    public static EntityManager entMan;
    public static EffectManager effectMan;
    static GUI guiMan;
    public static GraphicsManager gMan;
    private static long leftPressTime;
    private static long rightPressTime;
    public static int gameState;
    public static int fadeValue;
    public static boolean gameReadyForDraw;
    public static int cgState;
    public static int cgAlpha;
    public static int cgFPSflag;
    public static final int BEGIN_CG = 1;
    public static final int IN_CG = 2;
    public static final int END_CG = 4;
    public static final int SHOW_CG_OVERLAY = 8;
    public static final int CAN_MOVE_PLAYER = 1;
    public static final int SCRIPT_RUNNING = 2;
    public static final int FULLSCREEN_IMAGE = 4;
    public static final int SAVE_SCREEN = 8;
    public static final int LOAD_SCREEN = 16;
    public static final int PLAYER_VISIBLE = 32;
    public static final int SHOW_MAP = 64;
    public static final int TITLE_SCREEN = 128;
    public static final int PAUSED = 256;
    public static final int ESC_MENU = 512;
    public static final int OPTIONS_MENU = 1024;
    public static final int KEYSET_MENU = 2048;
    public static final int SHOW_HUD_OVERRIDE = 4096;
    public static final int INVENTORY_MENU = 8192;
    public static final int ONLY_DRAW_PLAYER = 16384;
    public static final int SKIP_CUTSCENE = 32768;
    public static final int LANG_ENGLISH = 1;
    private static int gameLanguage;
    public static MusicPlayer musicPlayer;
    public static SoundPlayer soundPlayer;
    public static SaveManager saveMan;
    public static ScriptRunner scriptRunner;
    private GameCanvas canvas;
    static BufferedImage tempScreen;
    static BufferedImage finalTempScreen;
    Graphics2D tempGraphics;
    Graphics2D finalTempGraphics;
    BufferedImage scaledScreen = new BufferedImage(1, 1, 6);
    Graphics2D scaledGraphics = this.scaledScreen.createGraphics();
    AffineTransform at = new AffineTransform();
    AffineTransformOp scaleOp;
    AffineTransformOp scaleOpDouble;
    private int screenDeviceID;
    static GraphicsConfiguration graphConfig;
    private BufferStrategy strategy;
    private static PaintThread pThread;
    private boolean isGameVisible = false;
    private boolean hasFocus = true;
    private static Insets insets;
    public static int myTimer;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 1;
        versionNumber = nArray;
        ENABLE_FULLSCREEN = true;
        FULLSCREEN_MODE = false;
        isScreenScaled = false;
        isProportionalScaled = true;
        window_width = 800;
        window_height = 600;
        window_proportional_width = 800;
        screenOffsetY = 0;
        key_held = 0;
        key_pressed = 0;
        key_buf = 0;
        key_prev = 0;
        pc = null;
        ripPc = null;
        risaPc = null;
        partnerPc = null;
        currentMap = null;
        entMan = new EntityManager();
        effectMan = new EffectManager();
        leftPressTime = System.currentTimeMillis();
        rightPressTime = System.currentTimeMillis();
        gameState = 33;
        fadeValue = 255;
        gameReadyForDraw = false;
        cgState = 0;
        cgAlpha = 0;
        cgFPSflag = 0;
        gameLanguage = 1;
        myTimer = 0;
    }

    public static int getKeyPress() {
        return key_pressed;
    }

    public static int getKeyHeld() {
        return key_held;
    }

    public String versionNumber() {
        return String.valueOf(versionNumber[0]) + "." + versionNumber[1] + "." + versionNumber[2] + "." + versionNumber[3];
    }

    public GameApp() {
        URL iconURL = GameApp.class.getResource("rip-icon3.png");
        Image icon = Toolkit.getDefaultToolkit().createImage(iconURL);
        this.setIconImage(icon);
        GameConfig.assignDefaultKeys();
        rand = new Random();
        this.canvas = new GameCanvas();
        this.canvas.setSize(new Dimension(800, 600));
        this.getContentPane().add(this.canvas);
        this.setDefaultCloseOperation(3);
        this.pack();
        insets = this.getInsets();
        this.setSize(new Dimension(800 + GameApp.insets.left + GameApp.insets.right - 10, 600 + GameApp.insets.top + GameApp.insets.bottom - 10));
        this.setTitle("Rip " + this.versionNumber());
        this.fullScreenSetup();
        if (ENABLE_FULLSCREEN) {
            this.scaledScreen = new BufferedImage(window_width, window_height, 6);
            this.scaleScreen(window_width, window_height);
            if (FULLSCREEN_MODE) {
                this.fullScreen();
            }
        }
        this.setLocation((window_width - this.getWidth()) / 2, (window_height - this.getHeight()) / 2);
        try {
            BufferedImage cursorImg;
            if (FULLSCREEN_MODE) {
                cursorImg = new BufferedImage(16, 16, 2);
            } else {
                Dimension d = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
                cursorImg = GraphicsManager.loadImage("data/cursor_axe").getSubimage(0, 0, d.width, d.height);
            }
            Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "cursor");
            this.getContentPane().setCursor(blankCursor);
        }
        catch (Exception e) {
            System.out.println("Setting cursor failed\n");
            e.printStackTrace();
        }
        this.setVisible(true);
        this.isGameVisible = true;
        this.setResizable(false);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        graphConfig = ge.getScreenDevices()[this.screenDeviceID].getDefaultConfiguration();
        finalTempScreen = graphConfig.createCompatibleImage(800, 600, 1);
        finalTempScreen.setAccelerationPriority(1.0f);
        tempScreen = graphConfig.createCompatibleImage(400, 300, 3);
        tempScreen.setAccelerationPriority(1.0f);
        BufferedImage LoadImg = GraphicsManager.loadImage("data/load");
        this.getGraphics().drawImage(LoadImg, GameApp.insets.left, GameApp.insets.top, 800 + GameApp.insets.left, 600 + GameApp.insets.top, 0, 0, LoadImg.getWidth(), LoadImg.getHeight(), null);
        Thread gameLoad = new Thread(){

            @Override
            public void run() {
                GameApp.this.gameInit();
            }
        };
        LoadImg.flush();
        gameLoad.run();
        try {
            Thread.sleep(500L);
            while (gameLoad.isAlive()) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.gameStart();
    }

    private void scaleScreen(int x, int y) {
        this.at = new AffineTransform();
        this.at.scale((double)x / 800.0, (double)y / 600.0);
        this.scaleOp = new AffineTransformOp(this.at, 2);
    }

    public void fullScreenSetup() {
        GraphicsEnvironment ge;
        GraphicsDevice[] defaultScreens;
        Preferences prefs = Preferences.userNodeForPackage(GameApp.class);
        this.screenDeviceID = prefs.getInt(PREF_FULLSCREEN_DEVICE, -1);
        if (this.screenDeviceID == -1) {
            OptionDialog d = new OptionDialog(this);
            this.screenDeviceID = d.getScreenDeviceID();
        }
        if (this.screenDeviceID >= (defaultScreens = (ge = GraphicsEnvironment.getLocalGraphicsEnvironment()).getScreenDevices()).length || this.screenDeviceID < 0) {
            this.screenDeviceID = 0;
            ENABLE_FULLSCREEN = false;
            return;
        }
        GraphicsDevice g = defaultScreens[this.screenDeviceID];
        window_width = (int)g.getDefaultConfiguration().getBounds().getWidth();
        window_height = (int)g.getDefaultConfiguration().getBounds().getHeight();
        window_proportional_width = window_height / 3 * 4;
        this.setVisible(true);
    }

    private void fullScreen() {
        while (pThread.isDrawing()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.isGameVisible = false;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] defaultScreens = ge.getScreenDevices();
        GraphicsDevice g = this.screenDeviceID >= 0 && this.screenDeviceID < defaultScreens.length ? defaultScreens[this.screenDeviceID] : defaultScreens[0];
        this.setVisible(false);
        this.dispose();
        this.setUndecorated(true);
        defaultDM = g.getDisplayMode();
        g.setFullScreenWindow(this);
        this.setSize(new Dimension(window_width, window_height));
        this.canvas.setSize(new Dimension(window_width, window_height));
        this.canvas.setLocation(0, 0);
        isScreenScaled = true;
        this.setVisible(true);
        FULLSCREEN_MODE = true;
        this.isGameVisible = true;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.canvas.requestFocus();
    }

    private void fullScreenOff() {
        GraphicsDevice[] defaultScreens;
        while (pThread.isDrawing()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.isGameVisible = false;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = defaultScreens = ge.getScreenDevices();
        if (defaultScreens.length != 0) {
            GraphicsDevice g = graphicsDeviceArray[0];
            this.setVisible(false);
            this.dispose();
            this.setUndecorated(false);
            g.setFullScreenWindow(null);
            isScreenScaled = false;
            this.setSize(new Dimension(800 + GameApp.insets.left + GameApp.insets.right - 10, 600 + GameApp.insets.top + GameApp.insets.bottom - 10));
            this.canvas.setSize(new Dimension(800, 600));
            this.setVisible(true);
        }
        FULLSCREEN_MODE = false;
        this.isGameVisible = true;
    }

    public void gameInit() {
        this.canvas.createBufferStrategy(2);
        this.strategy = this.canvas.getBufferStrategy();
        pThread = new PaintThread();
        pThread.start();
        gMan = new GraphicsManager();
        musicPlayer = new MusicPlayer();
        soundPlayer = new SoundPlayer();
        scriptRunner = new ScriptRunner();
        saveMan = new SaveManager();
        guiMan = new GUI();
        this.tryToGetController();
        effectMan.initialize();
        NumObj.initialize();
        saves = new SaveFile[4];
        GameApp.saves[0] = saveMan.loadSave(1);
        GameApp.saves[1] = saveMan.loadSave(2);
        GameApp.saves[2] = saveMan.loadSave(3);
        GameApp.saves[3] = saveMan.loadSave(4);
        if (saves[0] != null || saves[1] != null || saves[2] != null || saves[3] != null) {
            GameApp.guiMan.titleScreenIndex = 1;
        }
        GameConfig.doConfig();
        GameApp.startTitleScreen();
    }

    public void gameStart() {
        Thread gameThread = new Thread(){

            @Override
            public void run() {
                GameApp.this.gameLoop();
            }
        };
        gameThread.start();
    }

    private void gameLoop() {
        while (true) {
            ++myTimer;
            long beginTime = System.nanoTime();
            if ((key_pressed & 0x20) != 0 && (gameState & 0x200) == 0) {
                gameState |= 0x200;
            }
            if (ENABLE_FULLSCREEN && (key_pressed & 0x400000) != 0) {
                if (FULLSCREEN_MODE) {
                    this.fullScreenOff();
                } else {
                    this.fullScreen();
                }
            }
            this.gameUpdate();
            if ((gameState & 0x8000) != 0) continue;
            if (cgState == 0 || !isScreenScaled) {
                pThread.paint();
            } else if ((cgFPSflag ^= 1) == 0) {
                pThread.paint();
            }
            long timeTaken = System.nanoTime() - beginTime;
            long timeLeft = (16666666L - timeTaken) / 1000000L;
            if (timeLeft < 10L) {
                timeLeft = 1L;
            }
            if ((key_held & 0x10000) != 0) continue;
            try {
                Thread.sleep(timeLeft);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static void gameShutdown() {
        System.exit(0);
    }

    public void gameUpdate() {
        if (myController != null) {
            this.pollController();
        }
        this.updateKeys();
        if ((gameState & 0x800) == 0) {
            if ((gameState & 0x200) != 0) {
                guiMan.escMenuLogic();
            } else if ((gameState & 0x400) != 0) {
                guiMan.optionsMenuLogic();
            } else if (GameApp.isScriptRunning()) {
                scriptRunner.update();
            }
        }
        if ((gameState & 0x2700) == 0) {
            entMan.runEntityAI();
            entMan.updateDamageBoxes();
            if ((gameState & 0x20) != 0) {
                entMan.entityPCCollisions(pc);
            }
            entMan.damageEntityCollisions();
            effectMan.runEffectAI();
            if ((gameState & 0x20) != 0) {
                pc.update();
            }
            NumObj.updateNumbObjs();
            gMan.cameraUpdate();
        }
        soundPlayer.soundAI();
        guiMan.gui_AI();
    }

    public void tryToGetController() {
        try {
            DirectAndRawInputEnvironmentPlugin directEnv = new DirectAndRawInputEnvironmentPlugin();
            Controller[] controllers = directEnv.isSupported() ? directEnv.getControllers() : ControllerEnvironment.getDefaultEnvironment().getControllers();
            if (controllers.length > 0) {
                int i = 0;
                while (i < controllers.length) {
                    Controller controller = controllers[i];
                    if (controller.getType() == Controller.Type.GAMEPAD) {
                        myController = controller;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void pollButton(Component.Identifier b, int key) {
        Component comp = myController.getComponent(b);
        if (comp != null) {
            control_buf = comp.getPollData() == 0.0f ? (control_buf &= ~key) : (control_buf |= key);
        }
    }

    private void pollController() {
        if (!this.hasFocus) {
            return;
        }
        control_buf = 0;
        if (!myController.poll()) {
            myController = null;
            return;
        }
        this.pollButton(Component.Identifier.Button._0, 16);
        this.pollButton(Component.Identifier.Button._2, 64);
        this.pollButton(Component.Identifier.Button._3, 256);
        this.pollButton(Component.Identifier.Button._4, 512);
        this.pollButton(Component.Identifier.Button._5, 2048);
        this.pollButton(Component.Identifier.Button._7, 32);
        Component dPadComp = myController.getComponent(Component.Identifier.Axis.POV);
        float dPadPos = 0.0f;
        if (dPadComp != null) {
            dPadPos = dPadComp.getPollData();
        }
        Component comp = myController.getComponent(Component.Identifier.Axis.X);
        float axisValue = 0.0f;
        if (comp != null) {
            axisValue = comp.getPollData();
        }
        control_buf = axisValue < -0.125f || dPadPos == 1.0f || dPadPos == 0.125f || dPadPos == 0.875f ? (control_buf |= 1) : (control_buf &= 0xFFFFFFFE);
        control_buf = axisValue > 0.125f || dPadPos == 0.5f || dPadPos == 0.375f || dPadPos == 0.625f ? (control_buf |= 4) : (control_buf &= 0xFFFFFFFB);
        comp = myController.getComponent(Component.Identifier.Axis.Y);
        axisValue = 0.0f;
        if (comp != null) {
            axisValue = comp.getPollData();
        }
        control_buf = axisValue < -0.125f || dPadPos == 0.25f || dPadPos == 0.125f || dPadPos == 0.375f ? (control_buf |= 2) : (control_buf &= 0xFFFFFFFD);
        control_buf = axisValue > 0.125f || dPadPos == 0.75f || dPadPos == 0.875f || dPadPos == 0.625f ? (control_buf |= 8) : (control_buf &= 0xFFFFFFF7);
    }

    public void prepGameForRend() {
        if (entMan != null) {
            entMan.updateAllRendCoords();
        }
        if (pc != null) {
            pc.updateRendCoords();
        }
        effectMan.updateAllRendCoords();
        gMan.updateRendCamera();
    }

    public void drawMap(Graphics2D g) {
        if ((gameState & 0x4000) != 0) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 400, 300);
            pc.draw(this.tempGraphics);
            return;
        }
        GameApp.currentMap.background.draw(this.tempGraphics);
        if (GameApp.currentMap.background2 != null) {
            GameApp.currentMap.background2.draw(this.tempGraphics);
        }
        if (currentMap != null) {
            currentMap.draw(0, this.tempGraphics);
            currentMap.draw(1, this.tempGraphics);
        }
        if (entMan != null) {
            entMan.drawEntities(this.tempGraphics);
        }
        if (pc != null && (gameState & 0x20) != 0) {
            pc.draw(this.tempGraphics);
        }
        effectMan.drawEffects(this.tempGraphics);
        if (currentMap != null) {
            currentMap.draw(2, this.tempGraphics);
            currentMap.draw(3, this.tempGraphics);
        }
        NumObj.drawNumbObjs(this.tempGraphics);
    }

    public void gameDraw(Graphics g) {
        this.tempGraphics = tempScreen.createGraphics();
        this.tempGraphics.setBackground(new Color(0, 255, 0, 0));
        if (!gameReadyForDraw) {
            return;
        }
        this.prepGameForRend();
        if ((cgState & 1) != 0) {
            gMan.getSheet((byte)14).getGraphics().drawImage(tempScreen, 0, 0, 800, 600, 0, 0, 400, 300, null);
            cgState &= 0xFFFFFFFE;
        }
        this.tempGraphics.clearRect(0, 0, 400, 300);
        if ((cgState & 2) == 0 || (cgState & 4) != 0 || (gameState & 0x40) != 0) {
            this.drawMap(this.tempGraphics);
        }
        if (fadeValue != 0) {
            this.tempGraphics.setColor(new Color(0, 0, 0, fadeValue));
            this.tempGraphics.fillRect(0, 0, 400, 300);
        }
        if ((gameState & 0x2000) != 0 && ((cgState & 2) == 0 || (cgState & 4) != 0 || (cgState & 8) != 0)) {
            guiMan.drawInventory(this.tempGraphics);
        }
        if ((gameState & 1) != 0 || (gameState & 0x1000) != 0) {
            guiMan.drawHUD(this.tempGraphics);
        }
        guiMan.drawTextBox(this.tempGraphics);
        if ((gameState & 8) != 0) {
            guiMan.drawSaveScreen(this.tempGraphics);
        } else if ((gameState & 0x10) != 0) {
            guiMan.drawSaveScreen(this.tempGraphics);
        } else if ((gameState & 0x80) != 0) {
            guiMan.drawTitleCursor(this.tempGraphics);
        }
        if ((gameState & 0x200) != 0) {
            guiMan.drawEscapeMenu(this.tempGraphics);
        } else if ((gameState & 0x400) != 0) {
            guiMan.drawOptionsMenu(this.tempGraphics);
        }
        this.finalTempGraphics = finalTempScreen.createGraphics();
        if ((cgState & 2) != 0 && (cgState & 8) == 0) {
            gMan.drawCGs(this.finalTempGraphics);
        }
        if ((cgState & 4) == 0) {
            this.tempGraphics.dispose();
            this.finalTempGraphics.drawImage(tempScreen, 0, -2 * screenOffsetY, 800, 600 - 2 * screenOffsetY, 0, 0, 400, 300, null);
            if (screenOffsetY != 0) {
                this.finalTempGraphics.drawImage(tempScreen, 0, -2 * screenOffsetY + 600, 800, 1200 - 2 * screenOffsetY, 0, 0, 400, 300, null);
            }
        }
        if ((cgState & 8) != 0 && (gameState & 0x600) == 0) {
            gMan.drawCGs(this.finalTempGraphics);
        }
        this.finalTempGraphics.dispose();
        if (isScreenScaled) {
            if (isProportionalScaled) {
                g.setColor(Color.black);
                int xOff = (window_width - window_proportional_width) / 2;
                g.fillRect(0, 0, xOff, window_height);
                if (cgState != 0) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2d.drawImage(finalTempScreen, xOff, 0, window_proportional_width + xOff, window_height, 0, 0, 800, 600, null);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                } else {
                    g.drawImage(finalTempScreen, xOff, 0, window_proportional_width + xOff, window_height, 0, 0, 800, 600, null);
                }
                g.fillRect(xOff + window_proportional_width, 0, xOff, window_height);
            } else {
                g.drawImage(this.scaledScreen, 0, 0, window_width, window_height, 0, 0, window_width, window_height, null);
            }
        } else {
            g.drawImage(finalTempScreen, 0, 0, 800, 600, 0, 0, 800, 600, null);
        }
    }

    public static void drawSaveIcon() {
        Point camera = gMan.getRendCamera();
        int xDraw = GameApp.pc.xPos / 512 - camera.x - 48;
        int yDraw = GameApp.pc.yPos / 512 - camera.y - 48;
        if (xDraw < 0) {
            xDraw = 0;
        }
        if (yDraw < 0) {
            yDraw = 0;
        }
        if (xDraw > 304) {
            xDraw = 304;
        }
        if (yDraw > 204) {
            yDraw = 204;
        }
        Graphics2D g = (Graphics2D)gMan.getSheet((byte)13).getGraphics();
        g.drawImage(tempScreen, 0, 0, 48, 48, xDraw, yDraw, xDraw + 96, yDraw + 96, null);
    }

    private void updateKeys() {
        int key_buf_copy = key_buf;
        if (control_buf != 0) {
            key_buf_copy = control_buf;
            key_buf = 0;
        }
        key_held = key_buf_copy;
        key_pressed = key_buf_copy & ~key_prev;
        key_prev = key_buf_copy;
    }

    public void gameKeyPressed(int keyCode) {
        long tapTime = 250L;
        int keyPressed = GameConfig.getKeyAssigned(keyCode);
        switch (keyCode) {
            case 27: {
                key_buf |= 0x20;
                break;
            }
            case 122: {
                key_buf |= 0x400000;
                break;
            }
        }
        switch (keyPressed) {
            case 1: {
                long difference = System.currentTimeMillis() - leftPressTime;
                if (difference < tapTime) {
                    key_buf |= 0x1000;
                }
                leftPressTime = System.currentTimeMillis();
                break;
            }
            case 4: {
                long difference = System.currentTimeMillis() - rightPressTime;
                if (difference < tapTime) {
                    key_buf |= 0x4000;
                }
                rightPressTime = System.currentTimeMillis();
                break;
            }
        }
        key_buf |= keyPressed;
    }

    public void gameKeyReleased(int keyCode) {
        int keyReleased = GameConfig.getKeyAssigned(keyCode);
        switch (keyCode) {
            case 27: {
                key_buf &= 0xFFFFFFDF;
                break;
            }
            case 122: {
                key_buf &= 0xFFBFFFFF;
                break;
            }
        }
        switch (keyReleased) {
            case 1: {
                key_buf &= 0xFFFFEFFF;
                break;
            }
            case 4: {
                key_buf &= 0xFFFFBFFF;
                break;
            }
        }
        key_buf &= ~keyReleased;
    }

    public void gameKeyPressedOld(int keyCode) {
        long tapTime = 250L;
        switch (keyCode) {
            case 38: {
                key_buf |= 2;
                break;
            }
            case 40: {
                key_buf |= 8;
                break;
            }
            case 37: {
                key_buf |= 1;
                long difference = System.currentTimeMillis() - leftPressTime;
                if (difference < tapTime) {
                    key_buf |= 0x1000;
                }
                leftPressTime = System.currentTimeMillis();
                break;
            }
            case 39: {
                key_buf |= 4;
                long difference = System.currentTimeMillis() - rightPressTime;
                if (difference < tapTime) {
                    key_buf |= 0x4000;
                }
                rightPressTime = System.currentTimeMillis();
                break;
            }
            case 90: {
                key_buf |= 0x10;
                break;
            }
            case 88: {
                key_buf |= 0x40;
                break;
            }
            case 27: {
                key_buf |= 0x20;
                break;
            }
            case 48: {
                key_buf |= 0x10000;
                break;
            }
            case 49: {
                key_buf |= 0x20000;
                break;
            }
            case 50: {
                key_buf |= 0x40000;
                break;
            }
            case 51: {
                key_buf |= 0x80000;
                break;
            }
            case 52: {
                key_buf |= 0x100000;
                break;
            }
            case 53: {
                key_buf |= 0x200000;
            }
        }
    }

    public void gameKeyReleasedOld(int keyCode) {
        switch (keyCode) {
            case 38: {
                key_buf &= 0xFFFFFFFD;
                break;
            }
            case 40: {
                key_buf &= 0xFFFFFFF7;
                break;
            }
            case 37: {
                key_buf &= 0xFFFFFFFE;
                key_buf &= 0xFFFFEFFF;
                break;
            }
            case 39: {
                key_buf &= 0xFFFFFFFB;
                key_buf &= 0xFFFFBFFF;
                break;
            }
            case 90: {
                key_buf &= 0xFFFFFFEF;
                break;
            }
            case 88: {
                key_buf &= 0xFFFFFFBF;
                break;
            }
            case 27: {
                key_buf &= 0xFFFFFFDF;
                break;
            }
            case 48: {
                key_buf &= 0xFFFEFFFF;
                break;
            }
            case 49: {
                key_buf &= 0xFFFDFFFF;
                break;
            }
            case 50: {
                key_buf &= 0xFFFBFFFF;
                break;
            }
            case 51: {
                key_buf &= 0xFFF7FFFF;
                break;
            }
            case 52: {
                key_buf &= 0xFFEFFFFF;
                break;
            }
            case 53: {
                key_buf &= 0xFFDFFFFF;
            }
        }
    }

    public void gameKeyTyped(char keyChar) {
    }

    public static int randomInt(int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GameApp();
            }
        });
    }

    public static boolean isScriptRunning() {
        return (gameState & 2) != 0;
    }

    public static void loadSave() {
        if (loadedSave == null) {
            musicPlayer.play(0);
            GameApp.startTitleScreen();
            return;
        }
        guiMan.hideBossHPbar();
        ripPc = loadedSave.getRip();
        risaPc = loadedSave.getRisa();
        switch (loadedSave.getCurrentPlayerType()) {
            case 1: {
                pc = ripPc;
                break;
            }
            case 2: {
                pc = risaPc;
            }
        }
        GameApp.inventory.items = loadedSave.getItems();
        GameApp.inventory.notes = loadedSave.getNotes();
        GameApp.inventory.weaponBooks = loadedSave.getBooks();
        gMan.setCameraTarget(pc);
        gMan.setCameraSpeed(13);
        musicPlayer.play(loadedSave.getSongID());
        scriptFlags = loadedSave.getFlags();
        try {
            currentMap = new Stage(loadedSave.getMapNum());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (loadedSave.hasMirror()) {
            currentMap.setMirrors(loadedSave.getMirrors(), loadedSave.getMirrorDirs());
        }
        gMan.cameraUpdateInstant();
        gMan.cameraUpdate();
        gMan.updateRendCamera();
        gameState = 99;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void startTitleScreen() {
        loadedSave = null;
        gameReadyForDraw = false;
        cgState = 0;
        guiMan.closeTextBox();
        guiMan.hideBossHPbar();
        fadeValue = 255;
        gameState = 64;
        ripPc = new RipPC();
        risaPc = new RisaPC();
        pc = ripPc;
        gMan.setCameraTarget(pc);
        scriptFlags = new Flags();
        inventory = new Inventory();
        try {
            currentMap = new Stage(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        scriptRunner.runEvent(100);
        gameReadyForDraw = true;
    }

    public void disableClosing() {
        this.setDefaultCloseOperation(0);
    }

    public static int getLanguage() {
        return gameLanguage;
    }

    class GameCanvas
    extends Canvas
    implements KeyListener {
        private static final long serialVersionUID = 1L;
        private boolean doDraw = true;

        public GameCanvas() {
            this.setBackground(Color.black);
            System.out.println("Canvas initialized");
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    System.out.println("canvas focus gained");
                    GameApp.this.hasFocus = true;
                    GameCanvas.this.doDraw = true;
                }

                @Override
                public void focusLost(FocusEvent e) {
                    System.out.println("canvas focus lost");
                    if ((gameState & 0x600) == 0) {
                        gameState |= 0x200;
                    }
                    GameApp.this.hasFocus = false;
                }
            });
            this.setFocusable(true);
            this.requestFocus();
            this.addKeyListener(this);
        }

        public void paintComponent(Graphics g) {
            if (GameApp.this.hasFocus) {
                this.doDraw = true;
            }
            if (this.doDraw) {
                GameApp.this.gameDraw(g);
                g.dispose();
            }
            if (!GameApp.this.hasFocus) {
                this.doDraw = false;
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if ((gameState & 0x800) != 0) {
                guiMan.keySetLogic(e.getKeyCode());
            } else {
                GameApp.this.gameKeyPressed(e.getKeyCode());
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            GameApp.this.gameKeyReleased(e.getKeyCode());
        }

        @Override
        public void keyTyped(KeyEvent e) {
            GameApp.this.gameKeyTyped(e.getKeyChar());
        }
    }

    class PaintThread
    extends Thread {
        private boolean killThread = false;
        private boolean drawRequest = false;
        private boolean isDrawing = false;
        public double droppedFrames = 0.0;
        public double requestedFrames = 0.0;
        public double drawnFrames = 0.0;

        PaintThread() {
        }

        @Override
        public void run() {
            while (!this.killThread) {
                if (!this.drawRequest) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                this.isDrawing = true;
                this.drawRequest = false;
                try {
                    GameApp.this.canvas.paintComponent(GameApp.this.strategy.getDrawGraphics());
                    while (!GameApp.this.isGameVisible) {
                        Thread.sleep(1L);
                    }
                    GameApp.this.strategy.show();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.drawnFrames += 1.0;
                this.isDrawing = false;
            }
        }

        public void paint() {
            this.drawRequest = true;
            if (this.isDrawing) {
                this.droppedFrames += 1.0;
            }
            this.requestedFrames += 1.0;
            if (this.requestedFrames > 600.0) {
                System.out.println("BUSY RATE: " + this.droppedFrames / this.requestedFrames);
                System.out.println("DRAW RATE: " + this.drawnFrames / this.requestedFrames);
                this.drawnFrames = 0.0;
                this.requestedFrames = 0.0;
                this.droppedFrames = 0.0;
            }
        }

        public boolean isDrawing() {
            return this.isDrawing;
        }
    }
}

