/*
 * Decompiled with CFR 0.152.
 */
package local.rip.engine;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Vector;
import local.rip.engine.GameApp;
import local.rip.engine.GameConfig;
import local.rip.engine.Messages;
import local.rip.engine.NumObj;
import local.rip.engine.RipPC;
import local.rip.engine.RisaPC;
import local.rip.engine.SaveFile;
import local.rip.engine.SoundPlayer;
import local.rip.engine.Stage;
import local.rip.entity.Entity;

public class GUI {
    private final int textBuffX = 280;
    private final int textBuffY = 48;
    private final int textLineBreak = 12;
    static final String[] keySetStrings = new String[]{"Up", "Down", "Left", "Right", "Run", "Jump/OK", "Attack/Cancel", "Inventory", "Investigate"};
    static final int[] keySets = new int[]{2, 8, 1, 4, 2048, 16, 64, 512, 256};
    static final int SAVE_WIDTH = 370;
    static final int SAVE_HEIGHT = 60;
    static final int INV_OPTIONS = 0;
    static final int INV_ITEMS = 1;
    static final int INV_NOTES = 2;
    static final int Y_TABS = 0;
    static final int Y_ITEMS = 1;
    static final int Y_NOTES = 2;
    static final int Y_READING_NOTE = 3;
    int inventorySelectIndex = 1;
    int inventoryYIndex = 1;
    public int notesPages;
    int notesSelectIndex = 0;
    int notesIndexTimer = 0;
    static final int NOTES_TIMER = 5;
    int notesFadeTimer = 0;
    int currentNotesPage = 0;
    int currentNoteIndex = 0;
    final int HUD_X = 20;
    int inventoryXOff = 0;
    int saveScreenXOff = 0;
    int saveScreenIndex = 0;
    int titleScreenIndex = 0;
    int choiceIndex = 0;
    int escMenuIndex = 0;
    int optionsMenuIndex = 0;
    int keySetIndex = -1;
    int textTimer = 0;
    final int HUD_Y = 20;
    final int WEAP_ANI_LENGTH = 15;
    byte currentWeapon;
    byte oldWeapon;
    int weaponAniTimer = 0;
    int dispHP = 0;
    int itemIcon = -1;
    public int textBoxX = 10;
    public int textBoxY = 180;
    public int textBoxWidth = 300;
    private Color textBoxColor = new Color(0, 0, 10, 210);
    BufferedImage textBuffer;
    Graphics2D textGraphics;
    public Vector<String> textBoxStrings;
    public int textCurrentLine = 0;
    public int textYOff = 0;
    private int nodTimer = 0;
    private int mapNameTimer = 0;
    public boolean displayChoice = false;
    public boolean displayNodButtons = false;
    public boolean textBoxVisible = false;
    public boolean notesVisible = false;
    public boolean showFacePic1 = false;
    public boolean showFacePic2 = false;
    private int bossMaxHP = 0;
    private int bossDispHP = 0;
    private int bossHPincrement = 1;
    private Entity boss = null;
    private boolean showBossHP = false;
    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy, HH:mm:ss");

    GUI() {
        this.textBuffer = new BufferedImage(280, 48, 2);
        this.textGraphics = (Graphics2D)this.textBuffer.getGraphics();
        this.textGraphics.setBackground(new Color(0, 0, 0, 0));
        this.textBoxStrings = new Vector(4);
        this.textBoxStrings.addElement(new String(""));
        try {
            Font customFont = Font.createFont(0, new File("data/st01r.ttf"));
            customFont = customFont.deriveFont(0, 10.0f);
            this.textGraphics.setFont(customFont);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.textGraphics.setFont(null);
    }

    public void switchWeap(byte curWeap, byte oldWeap) {
        this.currentWeapon = curWeap;
        this.oldWeapon = oldWeap;
        this.weaponAniTimer = 15;
    }

    public void gui_AI() {
        if (this.weaponAniTimer > 0) {
            --this.weaponAniTimer;
        }
        if (this.mapNameTimer > 0) {
            --this.mapNameTimer;
        }
        ++this.nodTimer;
        if (this.nodTimer >= 40) {
            this.nodTimer = 0;
        }
        if (this.notesFadeTimer < 255) {
            this.notesFadeTimer += 8;
        }
        if (this.notesFadeTimer > 255) {
            this.notesFadeTimer = 255;
        }
        if (this.textYOff < 0) {
            this.textYOff += 3;
            if (this.textYOff > 0) {
                this.textYOff = 0;
            }
        } else {
            this.textYOff -= 3;
            if (this.textYOff < 0) {
                this.textYOff = 0;
            }
        }
        this.inventoryXOff = this.inventoryXOff * 4 / 5;
        if (this.nodTimer % 3 == 0) {
            if (this.dispHP < GameApp.pc.getCurrentHP()) {
                ++this.dispHP;
            } else if (this.dispHP > GameApp.pc.getCurrentHP() && this.dispHP > 0) {
                --this.dispHP;
            }
        }
        if (this.boss != null) {
            if (Math.abs(this.bossDispHP - this.boss.currentHP) < this.bossHPincrement) {
                this.bossDispHP = this.boss.currentHP;
            } else if (this.bossDispHP < this.boss.currentHP) {
                this.bossDispHP += this.bossHPincrement;
            } else if (this.bossDispHP > this.boss.currentHP && this.bossDispHP > 0) {
                this.bossDispHP -= this.bossHPincrement;
            }
        }
    }

    public boolean nodLogic() {
        if (this.textYOff == 0 && this.textCurrentLine > 3 && (GameApp.key_held & 2) != 0) {
            --this.textCurrentLine;
            this.textYOff = 12;
        }
        if (this.textYOff == 0 && this.textCurrentLine < this.textBoxStrings.size() - 1 && (GameApp.key_held & 8) != 0) {
            ++this.textCurrentLine;
            this.textYOff = -12;
        }
        if ((GameApp.key_pressed & 0x50) != 0) {
            if (this.textCurrentLine == this.textBoxStrings.size() - 1) {
                GameApp.key_pressed = 0;
                return true;
            }
            this.textCurrentLine = this.textBoxStrings.size() - 1;
            this.textYOff = 0;
        }
        this.displayNodButtons = true;
        return false;
    }

    public int choiceLogic(int start, int numOfChoices) {
        if ((GameApp.key_pressed & 2) != 0) {
            --this.choiceIndex;
            if (this.choiceIndex < start) {
                this.choiceIndex = numOfChoices - 1;
            }
            GameApp.soundPlayer.playSound(26);
        } else if ((GameApp.key_pressed & 8) != 0) {
            ++this.choiceIndex;
            if (this.choiceIndex > numOfChoices - 1) {
                this.choiceIndex = start;
            }
            GameApp.soundPlayer.playSound(26);
        } else {
            if ((GameApp.key_pressed & 0x10) != 0) {
                GameApp.key_pressed = 0;
                GameApp.key_held = 0;
                return this.choiceIndex;
            }
            if ((GameApp.key_pressed & 0x40) != 0) {
                GameApp.soundPlayer.playSound(26);
                if (this.choiceIndex != numOfChoices - 1) {
                    this.choiceIndex = numOfChoices - 1;
                } else {
                    GameApp.key_pressed = 0;
                    GameApp.key_held = 0;
                    return numOfChoices - 1;
                }
            }
        }
        return -1;
    }

    public boolean saveScreenLogic() {
        if ((GameApp.key_pressed & 2) != 0) {
            --this.saveScreenIndex;
            if (this.saveScreenIndex < 0) {
                this.saveScreenIndex = 3;
            }
            GameApp.soundPlayer.playSound(12);
        } else if ((GameApp.key_pressed & 8) != 0) {
            ++this.saveScreenIndex;
            if (this.saveScreenIndex > 3) {
                this.saveScreenIndex = 0;
            }
            GameApp.soundPlayer.playSound(12);
        } else {
            if ((GameApp.key_pressed & 0x10) != 0) {
                GameApp.soundPlayer.playSound(11);
                GameApp.saveMan.save(this.saveScreenIndex);
                GameApp.loadedSave = GameApp.saves[this.saveScreenIndex];
                return true;
            }
            if ((GameApp.key_pressed & 0x40) != 0) {
                GameApp.soundPlayer.playSound(13);
                return true;
            }
        }
        return false;
    }

    public boolean titleScreenLogic() {
        if ((GameApp.key_pressed & 2) != 0) {
            --this.titleScreenIndex;
            if (this.titleScreenIndex < 0) {
                this.titleScreenIndex = 2;
            }
            GameApp.soundPlayer.playSound(15);
        } else if ((GameApp.key_pressed & 8) != 0) {
            ++this.titleScreenIndex;
            if (this.titleScreenIndex > 2) {
                this.titleScreenIndex = 0;
            }
            GameApp.soundPlayer.playSound(15);
        } else {
            if ((GameApp.key_pressed & 0x10) != 0) {
                GameApp.soundPlayer.playSound(11);
                switch (this.titleScreenIndex) {
                    case 0: {
                        GameApp.scriptRunner.runEvent(200);
                        break;
                    }
                    case 1: {
                        GameApp.scriptRunner.runEvent(102);
                        break;
                    }
                    case 2: {
                        GameApp.gameShutdown();
                    }
                }
                return true;
            }
            if ((GameApp.key_pressed & 0x40) != 0) {
                GameApp.soundPlayer.playSound(15);
                if (this.titleScreenIndex != 2) {
                    this.titleScreenIndex = 2;
                } else {
                    GameApp.gameShutdown();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean escMenuLogic() {
        if ((GameApp.key_pressed & 2) != 0) {
            --this.escMenuIndex;
            if (this.escMenuIndex < 0) {
                this.escMenuIndex = 3;
            }
            GameApp.soundPlayer.playSound(15);
        } else if ((GameApp.key_pressed & 8) != 0) {
            ++this.escMenuIndex;
            if (this.escMenuIndex > 3) {
                this.escMenuIndex = 0;
            }
            GameApp.soundPlayer.playSound(15);
        } else {
            if ((GameApp.key_pressed & 0x10) != 0) {
                GameApp.soundPlayer.playSound(11);
                switch (this.escMenuIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        GameApp.musicPlayer.play(0);
                        GameApp.startTitleScreen();
                        break;
                    }
                    case 2: {
                        GameApp.gameState |= 0x400;
                        break;
                    }
                    case 3: {
                        GameApp.gameShutdown();
                    }
                }
                GameApp.gameState &= 0xFFFFFDFF;
                GameApp.key_pressed = 0;
                return true;
            }
            if ((GameApp.key_pressed & 0x40) != 0 || (GameApp.key_pressed & 0x20) != 0) {
                GameApp.soundPlayer.playSound(15);
                if (this.escMenuIndex != 0) {
                    this.escMenuIndex = 0;
                } else {
                    GameApp.gameState &= 0xFFFFFDFF;
                    GameApp.key_pressed = 0;
                    return true;
                }
            }
        }
        return false;
    }

    public int combineInventoryLogic() {
        if ((GameApp.key_pressed & 4) != 0) {
            GameApp.soundPlayer.playSound(26);
            this.inventoryXOff += 60;
            GameApp.inventory.nextItem();
            return 1;
        }
        if ((GameApp.key_pressed & 1) != 0) {
            GameApp.soundPlayer.playSound(26);
            this.inventoryXOff -= 60;
            GameApp.inventory.lastItem();
            return 1;
        }
        if ((GameApp.key_pressed & 2) != 0) {
            GameApp.soundPlayer.playSound(14);
        } else if ((GameApp.key_pressed & 8) != 0) {
            GameApp.soundPlayer.playSound(14);
        } else {
            if ((GameApp.key_pressed & 0x10) != 0) {
                return 2;
            }
            if ((GameApp.key_pressed & 0x240) != 0) {
                GameApp.soundPlayer.playSound(13);
                return -1;
            }
        }
        return 0;
    }

    public int idleNotesLogic() {
        if ((GameApp.key_pressed & 0x200) != 0) {
            GameApp.soundPlayer.playSound(13);
            return -1;
        }
        if ((GameApp.key_pressed & 0x40) != 0) {
            this.notesFadeTimer = 0;
            this.inventoryYIndex = 2;
            this.currentNotesPage = this.currentNoteIndex / 15;
            this.notesSelectIndex = this.currentNoteIndex % 15;
            GameApp.soundPlayer.playSound(13);
            return 1;
        }
        if ((GameApp.key_pressed & 0x14) != 0 && this.currentNotesPage < this.notesPages - 1) {
            ++this.currentNotesPage;
            this.notesFadeTimer = 0;
            GameApp.soundPlayer.playSound(42);
            return 2;
        }
        if ((GameApp.key_pressed & 1) != 0 && this.currentNotesPage > 0) {
            --this.currentNotesPage;
            this.notesFadeTimer = 0;
            GameApp.soundPlayer.playSound(42);
            return 3;
        }
        return 0;
    }

    public int idleInventoryLogic() {
        if ((GameApp.key_pressed & 4) != 0) {
            if (this.inventoryYIndex == 1) {
                GameApp.soundPlayer.playSound(26);
                this.inventoryXOff += 60;
                GameApp.inventory.nextItem();
                return 1;
            }
            if (this.inventoryYIndex == 0) {
                GameApp.soundPlayer.playSound(26);
                ++this.inventorySelectIndex;
                if (this.inventorySelectIndex > 2) {
                    this.inventorySelectIndex = 0;
                }
                if (this.inventorySelectIndex == 2) {
                    if (GameApp.inventory.notes.size() > 0) {
                        return 3;
                    }
                    this.inventorySelectIndex = 0;
                }
                return 1;
            }
            if (this.inventoryYIndex == 2 && this.currentNotesPage < this.getNotesIndexPages()) {
                GameApp.soundPlayer.playSound(42);
                ++this.currentNotesPage;
                this.notesFadeTimer = 0;
                this.populateNotesList();
                if (this.notesSelectIndex > this.getMaxNotesIndex()) {
                    this.notesSelectIndex = this.getMaxNotesIndex();
                }
            }
        } else if ((GameApp.key_pressed & 1) != 0) {
            if (this.inventoryYIndex == 1) {
                GameApp.soundPlayer.playSound(26);
                this.inventoryXOff -= 60;
                GameApp.inventory.lastItem();
                return 1;
            }
            if (this.inventoryYIndex == 0) {
                GameApp.soundPlayer.playSound(26);
                --this.inventorySelectIndex;
                if (this.inventorySelectIndex < 0) {
                    this.inventorySelectIndex = 2;
                }
                if (this.inventorySelectIndex == 2) {
                    if (GameApp.inventory.notes.size() > 0) {
                        return 3;
                    }
                    this.inventorySelectIndex = 1;
                }
                return 1;
            }
            if (this.inventoryYIndex == 2 && this.currentNotesPage > 0) {
                GameApp.soundPlayer.playSound(42);
                --this.currentNotesPage;
                this.notesFadeTimer = 0;
                this.populateNotesList();
            }
        } else if ((GameApp.key_pressed & 2) != 0) {
            if (this.inventoryYIndex == 0) {
                switch (this.inventorySelectIndex) {
                    case 0: 
                    case 1: {
                        GameApp.soundPlayer.playSound(26);
                        this.inventoryYIndex = 1;
                        break;
                    }
                    case 2: {
                        GameApp.soundPlayer.playSound(1);
                        this.notesSelectIndex = this.getMaxNotesIndex();
                        this.inventoryYIndex = 2;
                    }
                }
            } else if (this.inventoryYIndex == 1) {
                GameApp.soundPlayer.playSound(26);
                this.inventoryYIndex = 0;
            } else if (this.inventoryYIndex == 2) {
                if (this.notesSelectIndex == 0) {
                    GameApp.soundPlayer.playSound(26);
                    this.inventoryYIndex = 0;
                } else {
                    GameApp.soundPlayer.playSound(1);
                    --this.notesSelectIndex;
                    this.notesIndexTimer = 10;
                }
            }
        } else if ((GameApp.key_held & 2) != 0) {
            if (this.inventoryYIndex == 2) {
                if (this.notesIndexTimer <= 0) {
                    if (this.notesSelectIndex == 0) {
                        GameApp.soundPlayer.playSound(26);
                        this.inventoryYIndex = 0;
                    } else {
                        GameApp.soundPlayer.playSound(1);
                        --this.notesSelectIndex;
                    }
                    this.notesIndexTimer = 5;
                } else {
                    --this.notesIndexTimer;
                }
            }
        } else if ((GameApp.key_pressed & 8) != 0) {
            if (this.inventoryYIndex == 0) {
                switch (this.inventorySelectIndex) {
                    case 0: 
                    case 1: {
                        GameApp.soundPlayer.playSound(26);
                        this.inventoryYIndex = 1;
                        break;
                    }
                    case 2: {
                        GameApp.soundPlayer.playSound(1);
                        this.inventoryYIndex = 2;
                        this.notesIndexTimer = 10;
                        this.notesSelectIndex = 0;
                    }
                }
            } else if (this.inventoryYIndex == 1) {
                GameApp.soundPlayer.playSound(26);
                this.inventoryYIndex = 0;
            } else if (this.inventoryYIndex == 2 && this.notesSelectIndex < this.getMaxNotesIndex()) {
                GameApp.soundPlayer.playSound(1);
                ++this.notesSelectIndex;
                this.notesIndexTimer = 10;
            }
        } else if ((GameApp.key_held & 8) != 0) {
            if (this.inventoryYIndex == 2) {
                if (this.notesIndexTimer <= 0) {
                    if (this.notesSelectIndex < this.getMaxNotesIndex()) {
                        GameApp.soundPlayer.playSound(1);
                        ++this.notesSelectIndex;
                        this.notesIndexTimer = 5;
                    }
                } else {
                    --this.notesIndexTimer;
                }
            }
        } else if ((GameApp.key_pressed & 0x10) != 0) {
            if (this.inventoryYIndex == 1) {
                return 2;
            }
            if (this.inventoryYIndex == 0) {
                switch (this.inventorySelectIndex) {
                    case 0: {
                        GameApp.gameState |= 0x200;
                        break;
                    }
                    case 1: {
                        GameApp.soundPlayer.playSound(26);
                        this.inventoryYIndex = 1;
                        break;
                    }
                    case 2: {
                        GameApp.soundPlayer.playSound(26);
                        this.inventoryYIndex = 1;
                    }
                }
            } else if (this.inventoryYIndex == 2) {
                GameApp.soundPlayer.playSound(42);
                this.currentNoteIndex = 15 * this.currentNotesPage + this.notesSelectIndex;
                this.inventoryYIndex = 3;
                this.notesFadeTimer = 0;
                this.currentNotesPage = 0;
                return 4000 + GameApp.inventory.notes.get(this.currentNoteIndex);
            }
        } else if ((GameApp.key_pressed & 0x240) != 0) {
            GameApp.soundPlayer.playSound(13);
            return -1;
        }
        return 0;
    }

    public boolean optionsMenuLogic() {
        block24: {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block23: {
                                if ((GameApp.key_pressed & 2) == 0) break block23;
                                --this.optionsMenuIndex;
                                if (this.optionsMenuIndex < 0) {
                                    this.optionsMenuIndex = 3;
                                }
                                GameApp.soundPlayer.playSound(15);
                                break block24;
                            }
                            if ((GameApp.key_pressed & 8) == 0) break block25;
                            ++this.optionsMenuIndex;
                            if (this.optionsMenuIndex > 3) {
                                this.optionsMenuIndex = 0;
                            }
                            GameApp.soundPlayer.playSound(15);
                            break block24;
                        }
                        if ((GameApp.key_pressed & 0x10) == 0) break block26;
                        switch (this.optionsMenuIndex) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                GameConfig.clearAllKeys();
                                GameApp.soundPlayer.playSound(15);
                                GameApp.gameState |= 0x800;
                                this.optionsMenuIndex = -1;
                                this.keySetIndex = 0;
                                break;
                            }
                            case 3: {
                                GameConfig.saveConfigFile();
                                GameApp.gameState &= 0xFFFFFBFF;
                                GameApp.gameState |= 0x200;
                                GameApp.key_pressed = 0;
                            }
                        }
                        break block24;
                    }
                    if ((GameApp.key_held & 4) == 0) break block27;
                    switch (this.optionsMenuIndex) {
                        case 0: {
                            if (GameApp.musicPlayer.visibleVolume <= 98) {
                                GameApp.musicPlayer.visibleVolume += 2;
                                GameApp.musicPlayer.setVolume();
                                break;
                            }
                            break block24;
                        }
                        case 1: {
                            if ((double)SoundPlayer.volume < 100.0) {
                                SoundPlayer.volume = (float)((double)SoundPlayer.volume + 2.0);
                                break;
                            }
                            break block24;
                        }
                    }
                    break block24;
                }
                if ((GameApp.key_held & 1) == 0) break block28;
                switch (this.optionsMenuIndex) {
                    case 0: {
                        if (GameApp.musicPlayer.visibleVolume >= 2) {
                            GameApp.musicPlayer.visibleVolume -= 2;
                            GameApp.musicPlayer.setVolume();
                            break;
                        }
                        break block24;
                    }
                    case 1: {
                        if ((double)SoundPlayer.volume > 0.0) {
                            SoundPlayer.volume = (float)((double)SoundPlayer.volume - 2.0);
                            break;
                        }
                        break block24;
                    }
                }
                break block24;
            }
            if ((GameApp.key_pressed & 0x40) != 0 || (GameApp.key_pressed & 0x20) != 0) {
                GameApp.soundPlayer.playSound(15);
                if (this.optionsMenuIndex != 3) {
                    this.optionsMenuIndex = 3;
                } else {
                    GameConfig.saveConfigFile();
                    GameApp.gameState &= 0xFFFFFBFF;
                    GameApp.gameState |= 0x200;
                    GameApp.key_pressed = 0;
                    return true;
                }
            }
        }
        return false;
    }

    public void keySetLogic(int VK_key) {
        int keyIndex = GameConfig.getKeyAssignIndex(VK_key);
        if (keyIndex == -1) {
            GameApp.soundPlayer.playSound(14);
            return;
        }
        if (GameConfig.getKeyAssigned(VK_key) != 0) {
            GameApp.soundPlayer.playSound(14);
            return;
        }
        GameConfig.assignKey(VK_key, keySets[this.keySetIndex]);
        ++this.keySetIndex;
        if (this.keySetIndex >= keySets.length) {
            GameApp.gameState &= 0xFFFFF7FF;
            this.optionsMenuIndex = 2;
        }
    }

    public boolean loadScreenLogic() {
        if ((GameApp.key_pressed & 2) != 0) {
            --this.saveScreenIndex;
            if (this.saveScreenIndex < 0) {
                this.saveScreenIndex = 3;
            }
            GameApp.soundPlayer.playSound(12);
        } else if ((GameApp.key_pressed & 8) != 0) {
            ++this.saveScreenIndex;
            if (this.saveScreenIndex > 3) {
                this.saveScreenIndex = 0;
            }
            GameApp.soundPlayer.playSound(12);
        } else if ((GameApp.key_pressed & 0x10) != 0) {
            SaveFile save = GameApp.saves[this.saveScreenIndex];
            if (save != null) {
                GameApp.soundPlayer.playSound(11);
                GameApp.loadedSave = GameApp.saves[this.saveScreenIndex];
                return true;
            }
            GameApp.soundPlayer.playSound(14);
        } else if ((GameApp.key_pressed & 0x40) != 0) {
            GameApp.soundPlayer.playSound(13);
            return true;
        }
        return false;
    }

    public void drawHUD(Graphics2D g) {
        if (GameApp.scriptFlags.checkFlag(2000)) {
            this.drawHPbar(g, 10, 10);
        }
        if (this.showBossHP) {
            this.drawBossHPbar(g, 60, 260);
        }
    }

    public void drawMapName(Graphics2D g, int x, int y) {
        g.setColor(Color.BLACK);
        g.drawString(GameApp.currentMap.getMapName(), x, y);
        g.setColor(Color.WHITE);
        g.drawString(GameApp.currentMap.getMapName(), x - 1, y - 1);
    }

    public void drawTextBox(Graphics2D g) {
        if (this.textBoxVisible) {
            this.renderTextBox(this.textBoxX, this.textBoxY, this.textBoxWidth, 50, g);
        }
        if (this.mapNameTimer > 0) {
            int xOff = GameApp.currentMap.getMapName().length() * 3;
            this.drawMapName(g, 160 - xOff, 120);
        }
    }

    public void drawInventory(Graphics2D g) {
        g.setColor(new Color(0, 0, 10, 230));
        g.fillRect(0, 0, 400, 300);
        int inventoryTimer = GameApp.scriptRunner.inventoryTimer;
        int yOff = inventoryTimer * inventoryTimer / 4;
        Rectangle frameRect = new Rectangle();
        if (this.inventoryYIndex == 0) {
            g.setColor(new Color(120, 120, 150, 200));
            switch (this.inventorySelectIndex) {
                case 0: {
                    g.fillRect(95, 28 - yOff, 35, 35);
                    break;
                }
                case 1: {
                    g.fillRect(140, 28 - yOff, 106, 34);
                    break;
                }
                case 2: {
                    g.fillRect(255, 28 - yOff, 112, 34);
                }
            }
        }
        frameRect.x = 0;
        frameRect.y = 411;
        frameRect.width = 35;
        frameRect.height = 35;
        GameApp.gMan.mainBlit(11, frameRect, 95, 28 - yOff, g);
        frameRect.x = 35;
        frameRect.y = 411;
        frameRect.width = 98;
        frameRect.height = 26;
        GameApp.gMan.mainBlit(11, frameRect, 144, 32 - yOff, g);
        if (GameApp.inventory.notes.size() > 0) {
            frameRect.x = 133;
            frameRect.y = 411;
            frameRect.width = 104;
            frameRect.height = 26;
            GameApp.gMan.mainBlit(11, frameRect, 259, 32 - yOff, g);
        }
        switch (this.inventorySelectIndex) {
            case 0: 
            case 1: {
                this.drawItems(g);
                break;
            }
            case 2: {
                this.drawNotes(g);
            }
        }
    }

    public void drawItems(Graphics2D g) {
        int inventoryTimer = GameApp.scriptRunner.inventoryTimer;
        int yOff = inventoryTimer * inventoryTimer / 4;
        GameApp.inventory.drawItems(g, this.inventoryXOff, 120 - yOff);
    }

    public void drawNotes(Graphics2D g) {
        int inventoryTimer = GameApp.scriptRunner.inventoryTimer;
        int yOff = inventoryTimer * inventoryTimer / 4;
        Rectangle frameRect = new Rectangle();
        frameRect.x = 0;
        frameRect.y = 186;
        frameRect.width = 321;
        frameRect.height = 225;
        GameApp.gMan.mainBlit(11, frameRect, 40, 65 - yOff, g);
        this.renderNotesText(g);
        if (this.inventoryYIndex == 2) {
            frameRect.x = 212;
            frameRect.y = 12;
            frameRect.width = 14;
            frameRect.height = 14;
            GameApp.gMan.mainBlit(11, frameRect, 60, 88 + this.notesSelectIndex * 12 - yOff, g);
            if (this.currentNotesPage > 0) {
                frameRect.x = 212;
                frameRect.y = 26;
                frameRect.width = 12;
                frameRect.height = 12;
                GameApp.gMan.mainBlit(11, frameRect, 20 + this.nodTimer / 20 * 2, 170 - yOff, g);
            }
            if (this.currentNotesPage < this.getNotesIndexPages()) {
                frameRect.x = 224;
                frameRect.y = 26;
                frameRect.width = 12;
                frameRect.height = 12;
                GameApp.gMan.mainBlit(11, frameRect, 368 - this.nodTimer / 20 * 2, 170 - yOff, g);
            }
        } else if (this.inventoryYIndex == 3) {
            if (this.currentNotesPage > 0) {
                frameRect.x = 212;
                frameRect.y = 26;
                frameRect.width = 12;
                frameRect.height = 12;
                GameApp.gMan.mainBlit(11, frameRect, 20 + this.nodTimer / 20 * 2, 170 - yOff, g);
            }
            if (this.currentNotesPage < this.notesPages - 1) {
                frameRect.x = 224;
                frameRect.y = 26;
                frameRect.width = 12;
                frameRect.height = 12;
                GameApp.gMan.mainBlit(11, frameRect, 368 - this.nodTimer / 20 * 2, 170 - yOff, g);
            }
        }
    }

    public void drawEscapeMenu(Graphics2D g) {
        String[] escapeOptions = new String[]{"Return to Game", "Return to Title", "Options", "Quit Game"};
        g.setColor(new Color(0, 0, 10, 230));
        g.fillRect(0, 0, 400, 300);
        int i = 0;
        while (i < 4) {
            if (i == this.escMenuIndex) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(new Color(130, 130, 130, 255));
            }
            g.drawString(escapeOptions[i], 40, 60 + i * 20);
            ++i;
        }
        this.drawKeySetMenu(g);
    }

    public void drawOptionsMenu(Graphics2D g) {
        String[] options = new String[]{"BGM Volume", "SFX Volume", "Set Keys", "Back"};
        g.setColor(new Color(0, 0, 10, 230));
        g.fillRect(0, 0, 400, 300);
        int i = 0;
        while (i < 4) {
            if (i == this.optionsMenuIndex) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(new Color(130, 130, 130, 255));
            }
            g.drawString(options[i], 40, 60 + i * 20);
            ++i;
        }
        this.drawVolumeBar(GameApp.musicPlayer.visibleVolume, 150, 48, g);
        this.drawVolumeBar((int)SoundPlayer.volume, 150, 68, g);
        this.drawKeySetMenu(g);
    }

    public void drawKeySetMenu(Graphics2D g) {
        int i = 0;
        while (i < keySets.length) {
            if (i == this.keySetIndex) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(new Color(130, 130, 130, 255));
            }
            g.drawString(String.valueOf(keySetStrings[i]) + " : " + GameConfig.getKeyName(keySets[i]), 40 + i / 5 * 160, 164 + i % 5 * 24);
            ++i;
        }
    }

    public void drawVolumeBar(int volume, int x, int y, Graphics2D g) {
        Rectangle frameRect = new Rectangle();
        frameRect.x = 132;
        frameRect.y = 72;
        frameRect.width = 4;
        frameRect.height = 16;
        GameApp.gMan.mainBlit(11, frameRect, x, y, g);
        frameRect.x += 4;
        GameApp.gMan.mainBlit(11, frameRect, x + 101, y, g);
        frameRect.x = 140;
        frameRect.y = 74;
        frameRect.width = volume;
        frameRect.height = 12;
        GameApp.gMan.mainBlit(11, frameRect, x + 2, y + 2, g);
        NumObj.drawNumb(x + 110, y, 1, volume, g);
    }

    public void drawTitleCursor(Graphics2D g) {
        int xDraw = 40 + this.titleScreenIndex * 14 + GameApp.scriptRunner.titleTimer / 16 * 4;
        int yDraw = 160 + this.titleScreenIndex * 35;
        g.drawImage(GameApp.gMan.getSheet((byte)11), xDraw, yDraw, xDraw + 14, yDraw + 14, 212, 12, 226, 26, null);
    }

    public void drawSaveScreen(Graphics2D g) {
        int sTimer = GameApp.scriptRunner.saveScreenTimer;
        this.saveScreenXOff = sTimer >= 25 ? (sTimer - 25) * (sTimer - 25) : (25 - sTimer) * (25 - sTimer);
        this.drawSaveScreen(g, 10 + this.saveScreenXOff, 10);
    }

    private void drawSaveScreen(Graphics2D g, int xOff, int yOff) {
        Color oldColor = g.getColor();
        g.setColor(new Color(0, 0, 10, 200));
        g.fillRect(xOff, yOff, 370, 20);
        g.setColor(Color.WHITE);
        if ((GameApp.gameState & 0x10) == 0) {
            g.drawString("Save Game: Please select a file", xOff + 8, yOff + 14);
        } else {
            g.drawString("Load Game: Please select a file", xOff + 8, yOff + 14);
        }
        this.drawSave(g, xOff, yOff + 25, GameApp.saves[0], 0);
        this.drawSave(g, xOff, yOff + 30 + 60, GameApp.saves[1], 1);
        this.drawSave(g, xOff, yOff + 35 + 120, GameApp.saves[2], 2);
        this.drawSave(g, xOff, yOff + 40 + 180, GameApp.saves[3], 3);
        g.setColor(oldColor);
    }

    private void drawSave(Graphics2D g, int xOff, int yOff, SaveFile s, int saveNumber) {
        Color oldColor = g.getColor();
        if (saveNumber != this.saveScreenIndex) {
            g.setColor(new Color(0, 0, 10, 200));
        } else {
            xOff += 10;
            g.setColor(new Color(60, 60, 80, 200));
        }
        g.fillRect(xOff, yOff, 370, 60);
        g.setColor(Color.WHITE);
        if (s == null) {
            g.drawString("File Empty.", xOff + 8, yOff + 14);
            return;
        }
        g.setColor(Color.WHITE);
        String fileName = "File " + s.getSaveNumber() + ":";
        g.drawString(fileName, xOff + 8, yOff + 14);
        g.drawString(Stage.getMapName(s.getMapNum()), xOff + 48, yOff + 14);
        g.drawString("HP:  " + s.getPlayerCurrentHP() + "/" + s.getPlayerMaxHP(), xOff + 90, yOff + 48);
        g.drawString(this.dateFormat.format(s.getDate()), xOff + 90, yOff + 32);
        int iconDrawX = xOff + 370 - 54;
        int iconDrawY = yOff + 6;
        g.drawImage(s.getIcon(), iconDrawX, iconDrawY, iconDrawX + 48, iconDrawY + 48, 0, 0, 48, 48, null);
        Rectangle frameRect = new Rectangle(0, 32, 40, 40);
        g.setColor(new Color(0, 150, 200, 100));
        g.fillRect(xOff + 4, yOff + 16, frameRect.width, 40);
        GameApp.gMan.mainBlit(11, frameRect, xOff + 4, yOff + 16, g);
        g.setColor(oldColor);
    }

    private void drawHPbar(Graphics2D g, int xOff, int yOff) {
        Rectangle frameRect = new Rectangle();
        if (GameApp.scriptFlags.checkFlag(2005)) {
            frameRect.x = 132;
            frameRect.y = 109;
            frameRect.width = 35;
            frameRect.height = 8;
            GameApp.gMan.mainBlit(11, frameRect, xOff, yOff + 18, g);
        }
        if (GameApp.pc instanceof RipPC) {
            frameRect.x = 0;
            frameRect.y = 0;
            frameRect.height = 16;
            frameRect.width = 40;
            GameApp.gMan.mainBlit(11, frameRect, xOff, yOff, g);
            xOff += 40;
        } else if (GameApp.pc instanceof RisaPC) {
            frameRect.x = 0;
            frameRect.y = 16;
            frameRect.height = 16;
            frameRect.width = 50;
            GameApp.gMan.mainBlit(11, frameRect, xOff, yOff, g);
            xOff += 50;
        }
        frameRect.x = 48;
        frameRect.y = 0;
        frameRect.width = 2 + GameApp.pc.getMaxHP() * 4;
        frameRect.height = 16;
        GameApp.gMan.mainBlit(11, frameRect, xOff, yOff, g);
        frameRect.x = 210;
        frameRect.width = 2;
        GameApp.gMan.mainBlit(11, frameRect, xOff + 2 + GameApp.pc.getMaxHP() * 4, yOff, g);
        frameRect.x = 50;
        frameRect.y = 16;
        frameRect.width = this.dispHP * 4;
        GameApp.gMan.mainBlit(11, frameRect, xOff + 2, yOff, g);
    }

    private void drawBossHPbar(Graphics2D g, int xOff, int yOff) {
        Rectangle frameRect = new Rectangle(0, 122, 280, 14);
        GameApp.gMan.mainBlit(11, frameRect, xOff, yOff, g);
        frameRect.y = 136 + this.nodTimer % 20 / 4 * 10;
        frameRect.height = 10;
        frameRect.width = this.bossMaxHP != 0 ? this.bossDispHP * 276 / this.bossMaxHP : 0;
        if (frameRect.width > 276) {
            frameRect.width = 276;
        } else if (frameRect.width < 0) {
            frameRect.width = 0;
        }
        GameApp.gMan.mainBlit(11, frameRect, xOff + 2, yOff + 2, g);
        frameRect.x = 132;
        frameRect.y = 103;
        frameRect.width = 16;
        frameRect.height = 5;
        GameApp.gMan.mainBlit(11, frameRect, xOff + 3, yOff + 3, g);
    }

    public void renderNotesText(Graphics2D g) {
        int yOffset = 88;
        g.setColor(new Color(0, 0, 0, this.notesFadeTimer));
        int i = 0;
        while (i < this.textBoxStrings.size()) {
            g.drawString(this.textBoxStrings.get(i), 80, yOffset);
            yOffset += 12;
            ++i;
        }
    }

    public void renderText(Graphics2D g, int xPos, int yPos) {
        this.textGraphics.clearRect(0, 0, 280, 48);
        this.textGraphics.setColor(new Color(255, 255, 255, 255));
        int textOffset = 0;
        int yOffset = 10;
        if (this.textCurrentLine >= 3) {
            textOffset = this.textCurrentLine - 4;
            yOffset -= this.textYOff + 12;
        }
        while (textOffset <= this.textCurrentLine) {
            if (textOffset >= 0) {
                this.textGraphics.drawString(this.textBoxStrings.get(textOffset), 0, yOffset);
            }
            yOffset += 12;
            ++textOffset;
        }
        g.drawImage(this.textBuffer, xPos, yPos, xPos + 280, yPos + 48, 0, 0, 280, 48, null);
    }

    public void renderTextBox(int xPos, int yPos, int xSize, int ySize, Graphics2D g) {
        Color oldColor = g.getColor();
        g.setColor(this.textBoxColor);
        g.fillRect(xPos, yPos, xSize, ySize);
        g.setColor(oldColor);
        int textBoxX = xPos;
        int textBoxY = yPos;
        Rectangle frameRect = new Rectangle(0, 0, 80, 120);
        if (this.showFacePic1) {
            frameRect.x = 0;
            frameRect.y = 0;
            frameRect.width = GameApp.gMan.getWidth((byte)7);
            frameRect.height = GameApp.gMan.getHeight((byte)7);
            GameApp.gMan.mainBlit(7, frameRect, textBoxX, textBoxY - frameRect.height, g);
        } else if (this.showFacePic2) {
            frameRect.x = 0;
            frameRect.y = 0;
            frameRect.width = GameApp.gMan.getWidth((byte)7);
            frameRect.height = GameApp.gMan.getHeight((byte)7);
            GameApp.gMan.mainBlit(7, frameRect, textBoxX + xSize - frameRect.width, textBoxY - frameRect.height, g);
        }
        if (this.itemIcon >= 0) {
            g.setColor(new Color(0, 0, 10, 210));
            g.fillRect(xPos + xSize / 2 - 20, yPos - 40, 40, 40);
            g.setColor(oldColor);
            frameRect.x = this.itemIcon % 10 * 40;
            frameRect.y = this.itemIcon / 10 * 40;
            frameRect.width = 40;
            frameRect.height = 40;
            GameApp.gMan.mainBlit(5, frameRect, xPos + xSize / 2 - 20, yPos - 40, g);
        }
        this.renderText(g, textBoxX + 10, textBoxY);
        if (this.displayNodButtons) {
            if (this.nodTimer >= 20) {
                frameRect.x = 236;
                frameRect.y = 0;
                frameRect.width = 12;
                frameRect.height = 12;
                GameApp.gMan.mainBlit(11, frameRect, textBoxX + xSize - 20, textBoxY + 18, g);
            }
            if (this.textCurrentLine < this.textBoxStrings.size() - 1) {
                frameRect.x = 224;
                frameRect.y = 0;
                frameRect.width = 12;
                frameRect.height = 12;
                GameApp.gMan.mainBlit(11, frameRect, textBoxX + xSize - 20, textBoxY + 34 + this.nodTimer / 20 * 2, g);
            }
            if (this.textCurrentLine > 3) {
                frameRect.x = 212;
                frameRect.y = 0;
                frameRect.width = 12;
                frameRect.height = 12;
                GameApp.gMan.mainBlit(11, frameRect, textBoxX + xSize - 20, textBoxY + 4 - this.nodTimer / 20 * 2, g);
            }
        }
        if (this.displayChoice) {
            frameRect.x = 212;
            frameRect.y = 12;
            frameRect.width = 14;
            frameRect.height = 14;
            GameApp.gMan.mainBlit(11, frameRect, textBoxX + 10, textBoxY + this.choiceIndex * 12, g);
        }
    }

    public void addText(String substring) {
        if (substring.equals("\n")) {
            ++this.textCurrentLine;
            this.textBoxStrings.add(new String(""));
            if (this.textCurrentLine >= 4) {
                this.textYOff = -12;
            }
        } else {
            this.textBoxStrings.set(this.textCurrentLine, this.textBoxStrings.get(this.textCurrentLine).concat(substring));
        }
    }

    public void openTextBox() {
        this.textBoxVisible = true;
        this.textBoxX = 10;
        this.textBoxY = 240;
        this.textBoxWidth = 380;
        this.textBoxColor = new Color(0, 0, 10, 210);
    }

    public void showMapName() {
        this.mapNameTimer = 150;
    }

    public void setTextBoxColor(Color newColor) {
        this.textBoxColor = newColor;
    }

    public void openCustomTextBox(int x, int y, int width) {
        this.textBoxVisible = true;
        this.textBoxX = x;
        this.textBoxY = y;
        this.textBoxWidth = width;
        this.textBoxColor = new Color(0, 0, 10, 210);
    }

    public void closeTextBox() {
        this.clearText();
        this.displayChoice = false;
        this.textBoxVisible = false;
        this.showFacePic1 = false;
        this.showFacePic2 = false;
        this.itemIcon = -1;
        this.textBoxColor = new Color(0, 0, 10, 210);
    }

    public void clearText() {
        this.textBoxStrings.clear();
        this.textBoxStrings.add("");
        this.textCurrentLine = 0;
    }

    public void setupBossHPbar(Entity E) {
        this.boss = E;
        this.bossMaxHP = E.maxHP;
        this.showBossHP = true;
        this.bossHPincrement = this.bossMaxHP * 3 / 276;
        if (this.bossHPincrement <= 0) {
            this.bossHPincrement = 1;
        }
    }

    public void hideBossHPbar() {
        this.boss = null;
        this.bossMaxHP = 0;
        this.bossDispHP = 0;
        this.showBossHP = false;
    }

    public void openInventory() {
        this.inventoryYIndex = 1;
        this.inventorySelectIndex = 1;
    }

    public void populateNotesList() {
        this.textBoxStrings.clear();
        this.textBoxStrings.add(" Index:");
        int startIndex = this.currentNotesPage * 15;
        int endIndex = startIndex + this.getMaxNotesIndex() + 1;
        int i = startIndex;
        while (i < endIndex) {
            String nameString = String.valueOf(Integer.toString(i + 1)) + ". ";
            nameString = String.valueOf(nameString) + Messages.getString("NOTE." + GameApp.inventory.notes.get(i));
            this.textBoxStrings.add(nameString);
            ++i;
        }
    }

    public int getMaxNotesIndex() {
        if (this.currentNotesPage < this.getNotesIndexPages()) {
            return 14;
        }
        return GameApp.inventory.notes.size() - 15 * this.getNotesIndexPages() - 1;
    }

    public int getNotesIndexPages() {
        return GameApp.inventory.notes.size() / 15;
    }
}

