/*
 * Decompiled with CFR 0.152.
 */
package local.rip.effect;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Vector;
import local.rip.effect.Effect;
import local.rip.effect.Effect001KnifeOverlay;
import local.rip.effect.Effect002SparkParticle;
import local.rip.effect.Effect003SwapSmear;
import local.rip.effect.Effect004WaterDrop;
import local.rip.effect.Effect005ExclamationMark;
import local.rip.effect.Effect006GlitchPixel;
import local.rip.effect.Effect007GlitchPixelBig;
import local.rip.effect.Effect008DandelionSeed;
import local.rip.effect.Effect009WarningArrow;
import local.rip.effect.Effect010ElevatorDoorLabOverlay;
import local.rip.effect.Effect011DandelionSeedFade;
import local.rip.engine.GameApp;

public class EffectManager {
    private ArrayList<Effect> effectArray;

    public void updateAllRendCoords() {
        if (this.effectArray == null) {
            return;
        }
        for (Effect E : this.effectArray) {
            E.updateRendCoords();
        }
    }

    public void addEffect(Effect E) {
        this.effectArray.add(E);
    }

    public Effect addEffect(int eType, int x, int y, int xV, int yV, int var) {
        Effect E;
        switch (eType) {
            case 1: {
                E = new Effect001KnifeOverlay(eType, x, y, xV, yV, var);
                break;
            }
            case 2: {
                E = new Effect002SparkParticle(eType, x, y, xV, yV, var);
                break;
            }
            case 3: {
                E = new Effect003SwapSmear(eType, x, y, xV, yV, var);
                break;
            }
            case 4: {
                E = new Effect004WaterDrop(eType, x, y, xV, yV, var);
                break;
            }
            case 5: {
                E = new Effect005ExclamationMark(eType, x, y, xV, yV, var);
                break;
            }
            case 6: {
                E = new Effect006GlitchPixel(eType, x, y, xV, yV, var);
                break;
            }
            case 7: {
                E = new Effect007GlitchPixelBig(eType, x, y, xV, yV, var);
                break;
            }
            case 8: {
                E = new Effect008DandelionSeed(eType, x, y, xV, yV, var);
                break;
            }
            case 9: {
                E = new Effect009WarningArrow(eType, x, y, xV, yV, var);
                break;
            }
            case 10: {
                E = new Effect010ElevatorDoorLabOverlay(eType, x, y, xV, yV, var);
                break;
            }
            case 11: {
                E = new Effect011DandelionSeedFade(eType, x, y, xV, yV, var);
                break;
            }
            default: {
                E = new Effect(eType, x, y, xV, yV, var);
            }
        }
        this.effectArray.add(E);
        return E;
    }

    public void drawEffects(Graphics2D g) {
        ArrayList drawArray = (ArrayList)this.effectArray.clone();
        for (Effect drawE : drawArray) {
            drawE.draw(g);
        }
        if (GameApp.currentMap.isMirror()) {
            for (Effect drawE : drawArray) {
                drawE.drawReflect(g);
            }
        }
    }

    public void initialize() {
        this.effectArray = new ArrayList();
    }

    public void runEffectAI() {
        Vector<Effect> removeE = new Vector<Effect>();
        for (Effect actE : this.effectArray) {
            if (actE.type < 0) {
                removeE.add(actE);
                continue;
            }
            actE.act();
        }
        this.effectArray.removeAll(removeE);
    }

    public void clearEffects() {
        this.effectArray.clear();
    }
}

