/*
 * Decompiled with CFR 0.152.
 */
package local.rip.effect;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import local.rip.engine.GameApp;
import local.rip.engine.Physical;

public class Effect {
    protected int rendX;
    protected int rendY;
    protected int xPos;
    protected int yPos;
    protected int displayOffsetX;
    protected int displayOffsetY;
    protected int xVel;
    protected int yVel;
    protected int yMaxVel = 4000;
    int type;
    int state;
    int variation;
    int frameTimer;
    int frameIndex;
    int scriptTimer;
    protected byte bitmap = (byte)2;
    public static final int LEFT_DIR = 1;
    public static final int UP_DIR = 2;
    public static final int RIGHT_DIR = 4;
    public static final int DOWN_DIR = 8;
    protected int direction;
    protected Rectangle frameRect;
    protected int friction;
    protected int gravity = 240;
    public Physical parent;
    protected int alphaVal = 255;

    public void updateRendCoords() {
        this.rendX = this.xPos;
        this.rendY = this.yPos;
    }

    public Effect(int eType, int x, int y, int xV, int yV, int var) {
        this.type = eType;
        this.xPos = x;
        this.yPos = y;
        this.xVel = xV;
        this.yVel = yV;
        this.variation = var;
        this.frameRect = new Rectangle(0, 0, 0, 0);
        this.state = 0;
    }

    public void setEffect(int eType, int x, int y, int xV, int yV, int var) {
        this.type = eType;
        this.xPos = x;
        this.yPos = y;
        this.xVel = xV;
        this.yVel = yV;
        this.variation = var;
        this.frameRect.x = 0;
        this.frameRect.y = 0;
        this.frameRect.width = 0;
        this.frameRect.height = 0;
        this.state = 0;
    }

    public void setParent(Physical P) {
        this.parent = P;
    }

    public void draw(Graphics2D g) {
        if (this.alphaVal >= 255) {
            GameApp.gMan.camBlit(this.bitmap, this.frameRect, this.rendX - this.displayOffsetX, this.rendY - this.displayOffsetY, g);
        } else {
            GameApp.gMan.alphaCamBlit(this.bitmap, this.frameRect, this.rendX - this.displayOffsetX, this.rendY - this.displayOffsetY, g, this.alphaVal);
        }
    }

    public void drawReflect(Graphics2D g) {
        int numOfMirrors = GameApp.currentMap.getNumOfMirrors();
        int i = 0;
        while (i < numOfMirrors) {
            if (GameApp.currentMap.isReflected(this.rendX - this.displayOffsetX, this.rendY - this.displayOffsetY, this.frameRect, i)) {
                int reflectY = GameApp.currentMap.getMirror((int)i).y;
                int reflectDispY = this.frameRect.height * 512 - this.displayOffsetY;
                if (this.alphaVal >= 255) {
                    GameApp.gMan.reflectCamBlit(this.bitmap, this.frameRect, this.rendX - this.displayOffsetX, 2 * reflectY - this.rendY - reflectDispY, g, i);
                } else {
                    GameApp.gMan.reflectAlphaBlit(this.bitmap, this.frameRect, this.rendX - this.displayOffsetX, 2 * reflectY - this.rendY - reflectDispY, g, this.alphaVal, i);
                }
            }
            ++i;
        }
    }

    public void act() {
    }

    public void movement() {
        this.xPos += this.xVel;
        this.yPos += this.yVel;
    }
}

